/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.event.listeners.TrainListener;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2487;

public class DeparturePrediction {
    private Train train;
    private int ticks;
    private String scheduleTitle;
    private String nextStop;
    private TrainStationAlias.StationInfo info;
    private TrainExitSide exit = TrainExitSide.UNKNOWN;
    private int cycle;

    public DeparturePrediction(Train train, int ticks, String scheduleTitle, String nextStop, int cycle, TrainStationAlias.StationInfo info) {
        this.train = train;
        this.ticks = ticks;
        this.scheduleTitle = scheduleTitle;
        this.nextStop = nextStop;
        this.cycle = cycle;
        this.info = info;
    }

    public DeparturePrediction(GlobalTrainDisplayData.TrainDeparturePrediction prediction) {
        this(prediction.train, prediction.ticks, prediction.scheduleTitle.getString(), prediction.destination, 0, GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(prediction.destination).getInfoForStation(prediction.destination));
    }

    public DeparturePrediction copy() {
        return new DeparturePrediction(this.getTrain(), this.getTicks(), this.getScheduleTitle(), this.getStationName(), this.getCycle(), this.getInfo());
    }

    public static DeparturePrediction withNextCycleTicks(DeparturePrediction current) {
        int cycle = current.getCycle() + 1;
        return new DeparturePrediction(current.getTrain(), DeparturePrediction.getTrainCycleDuration(current.getTrain()) * cycle + current.getTicks(), current.getScheduleTitle(), current.getStationName(), cycle, current.getInfo());
    }

    public static DeparturePrediction withCycleTicks(DeparturePrediction current, int cycles) {
        return new DeparturePrediction(current.getTrain(), DeparturePrediction.getTrainCycleDuration(current.getTrain()) * cycles + current.getTicks(), current.getScheduleTitle(), current.getStationName(), cycles, current.getInfo());
    }

    public Train getTrain() {
        return this.train;
    }

    public int getTicks() {
        return this.ticks;
    }

    public String getScheduleTitle() {
        return this.scheduleTitle;
    }

    public String getStationName() {
        return this.nextStop;
    }

    public TrainStationAlias.StationInfo getInfo() {
        return this.info;
    }

    public TrainStationAlias getNextStop() {
        return GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(this.nextStop);
    }

    public int getCycle() {
        return this.cycle;
    }

    public int getTrainCycleDuration() {
        return DeparturePrediction.getTrainCycleDuration(this.getTrain());
    }

    public static int getTrainCycleDuration(Train train) {
        return TrainListener.getInstance().getApproximatedTrainDuration(train);
    }

    public TrainExitSide getExitSide() {
        return this.exit;
    }

    public void setExit(TrainExitSide exit) {
        this.exit = exit;
    }

    public SimpleDeparturePrediction simplify() {
        return new SimpleDeparturePrediction(this.getNextStop().getAliasName().get(), this.nextStop, this.getTicks(), this.getScheduleTitle(), this.getTrain().name.getString(), this.getTrain().id, this.getInfo(), this.getExitSide());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeparturePrediction) {
            DeparturePrediction other = (DeparturePrediction)obj;
            return this.getTrain().id == other.getTrain().id && this.getTicks() == other.getTicks() && this.getScheduleTitle().equals(other.getScheduleTitle()) && this.getStationName().equals(other.getStationName());
        }
        return false;
    }

    public int hashCode() {
        return 19 * Objects.hash(this.getTrain().id, this.getTicks(), this.getScheduleTitle(), this.getStationName());
    }

    public boolean similar(DeparturePrediction other) {
        return this.getTicks() == other.getTicks() && this.getStationName().equals(other.getStationName());
    }

    public String toString() {
        return String.format("%s, Next stop: %s in %st", this.getTrain().name.getString(), this.getNextStop().getAliasName(), this.getTicks());
    }

    public static enum TrainExitSide {
        UNKNOWN(0),
        RIGHT(1),
        LEFT(-1);

        private byte side;

        private TrainExitSide(byte side) {
            this.side = side;
        }

        public byte getAsByte() {
            return this.side;
        }

        public static TrainExitSide getFromByte(byte side) {
            return Arrays.stream(TrainExitSide.values()).filter(x -> x.getAsByte() == side).findFirst().orElse(UNKNOWN);
        }

        public TrainExitSide getOpposite() {
            return TrainExitSide.getFromByte(-this.getAsByte());
        }
    }

    public record SimpleDeparturePrediction(String stationTagName, String stationName, int departureTicks, String scheduleTitle, String trainName, UUID trainId, TrainStationAlias.StationInfo stationInfo, TrainExitSide exitSide) {
        private static final String NBT_STATION = "station";
        private static final String NBT_STATION_NAME = "stationName";
        private static final String NBT_TICKS = "ticks";
        private static final String NBT_SCHEDULE_TITLE = "title";
        private static final String NBT_TRAIN_NAME = "tname";
        private static final String NBT_ID = "id";
        private static final String NBT_EXIT_SIDE = "exit";

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582(NBT_STATION, this.stationTagName);
            nbt.method_10582(NBT_STATION_NAME, this.stationName);
            nbt.method_10569(NBT_TICKS, this.departureTicks);
            nbt.method_10582(NBT_SCHEDULE_TITLE, this.scheduleTitle);
            nbt.method_10582(NBT_TRAIN_NAME, this.trainName);
            nbt.method_25927(NBT_ID, this.trainId);
            this.stationInfo().writeNbt(nbt);
            nbt.method_10567(NBT_EXIT_SIDE, this.exitSide.getAsByte());
            return nbt;
        }

        public static SimpleDeparturePrediction fromNbt(class_2487 nbt) {
            return new SimpleDeparturePrediction(nbt.method_10558(NBT_STATION), nbt.method_10558(NBT_STATION_NAME), nbt.method_10550(NBT_TICKS), nbt.method_10558(NBT_SCHEDULE_TITLE), nbt.method_10558(NBT_TRAIN_NAME), nbt.method_25926(NBT_ID), TrainStationAlias.StationInfo.fromNbt(nbt), TrainExitSide.getFromByte(nbt.method_10571(NBT_EXIT_SIDE)));
        }
    }
}

