/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.Route;
import de.mrjulsen.crn.data.RoutePart;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class SimpleRoute {
    private static final String NBT_PARTS = "Parts";
    private static final String NBT_REFRESH_TIME = "RefreshTime";
    protected long refreshTime;
    protected final List<SimpleRoutePart> parts;
    protected int stationCount = -1;
    protected StationEntry startStation = null;
    protected StationEntry endStation = null;
    protected StationEntry[] stationArray = null;
    protected boolean valid = true;
    protected String invalidationReason = "";
    protected String invalidationTrainName = "";
    protected UUID listenerId;

    public SimpleRoute(Route route) {
        this(route.getParts().stream().map(x -> new SimpleRoutePart((RoutePart)x, route.getRefreshTime())).toList(), route.getRefreshTime());
    }

    protected SimpleRoute(List<SimpleRoutePart> parts, long refreshTime) {
        this.parts = new ArrayList<SimpleRoutePart>(parts);
        this.refreshTime = refreshTime;
        parts.forEach(x -> x.setParent(this));
        this.tagAll();
    }

    public UUID listen(IJourneyListenerClient initialListener) {
        this.listenerId = JourneyListenerManager.getInstance().create(this, initialListener);
        return this.listenerId;
    }

    public UUID getListenerId() {
        return this.listenerId;
    }

    public List<SimpleRoutePart> getParts() {
        return this.parts;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    protected void tagAll() {
        int maxIndex = this.getParts().size() - 1;
        int partIndex = 0;
        int stationIndex = 0;
        for (SimpleRoutePart part : this.getParts()) {
            StationTrainDetails trainDetails;
            int idx = partIndex;
            part.getStartStation().train = trainDetails = new StationTrainDetails(part.getTrainName(), part.getTrainID(), part.getScheduleTitle());
            part.getStartStation().tag = idx <= 0 ? StationTag.START : StationTag.PART_START;
            part.getStartStation().index = stationIndex++;
            for (StationEntry station : part.getStopovers()) {
                station.train = trainDetails;
                station.tag = StationTag.TRANSIT;
                station.index = stationIndex++;
            }
            part.getEndStation().train = trainDetails;
            part.getEndStation().tag = idx >= maxIndex ? StationTag.END : StationTag.PART_END;
            part.getEndStation().index = stationIndex++;
            ++partIndex;
        }
    }

    public void shiftTime(int amount) {
        this.parts.forEach(x -> x.shiftTime(amount));
        this.refreshTime += (long)amount;
    }

    public int getStationCount(boolean countTransfersTwice) {
        return this.stationCount < 0 ? (this.stationCount = this.parts.stream().mapToInt(x -> x.getStationCount(false)).sum() + (countTransfersTwice ? this.parts.size() * 2 : this.parts.size() + 1)) : this.stationCount;
    }

    public int getTransferCount() {
        return this.getParts().size() - 1;
    }

    public int getTotalDuration() {
        return this.getEndStation().getTicks() - this.getStartStation().getTicks();
    }

    protected void invalidate(String reason, String trainName) {
        this.valid = false;
        this.invalidationReason = reason;
        this.invalidationTrainName = trainName;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getInvalidationReason() {
        return this.invalidationReason;
    }

    public String getInvalidationTrainName() {
        return this.invalidationTrainName;
    }

    public StationEntry getStartStation() {
        return this.startStation == null ? (this.startStation = ((SimpleRoutePart)this.getParts().stream().findFirst().get()).getStartStation()) : this.startStation;
    }

    public StationEntry getEndStation() {
        return this.endStation == null ? (this.endStation = ((SimpleRoutePart)this.getParts().stream().reduce((a, b) -> b).get()).getEndStation()) : this.endStation;
    }

    public String getName() {
        return String.format("%s - %s", this.getStartStation().getStationName(), this.getEndStation().getStationName());
    }

    public StationEntry[] getStationArray() {
        StationEntry[] stationEntryArray;
        if (this.stationArray == null) {
            this.stationArray = (StationEntry[])this.getParts().stream().flatMap(x -> x.getStations().stream()).toArray(StationEntry[]::new);
            stationEntryArray = this.stationArray;
        } else {
            stationEntryArray = this.stationArray;
        }
        return stationEntryArray;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10544(NBT_REFRESH_TIME, this.getRefreshTime());
        class_2499 partsTag = new class_2499();
        partsTag.addAll(this.getParts().stream().map(x -> x.toNbt()).toList());
        nbt.method_10566(NBT_PARTS, (class_2520)partsTag);
        return nbt;
    }

    public static SimpleRoute fromNbt(class_2487 nbt) {
        long refreshTime = nbt.method_10537(NBT_REFRESH_TIME);
        ArrayList<SimpleRoutePart> parts = new ArrayList<SimpleRoutePart>(nbt.method_10554(NBT_PARTS, 10).stream().map(x -> SimpleRoutePart.fromNbt((class_2487)x, refreshTime)).toList());
        SimpleRoute route = new SimpleRoute(parts, refreshTime);
        parts.forEach(x -> x.setParent(route));
        return route;
    }

    public static class StationEntry {
        private static final String NBT_NAME = "Name";
        private static final String NBT_TICKS = "Ticks";
        protected final String stationName;
        protected final TrainStationAlias.StationInfo info;
        protected int ticks;
        protected long refreshTime;
        protected int index;
        protected StationTrainDetails train;
        protected StationTag tag;
        protected boolean departed = false;
        protected boolean willMiss = false;
        protected boolean trainCanceled = false;
        protected int timeShift = 0;
        protected int currentTicks;
        protected long currentRefreshTime;
        protected TrainStationAlias.StationInfo updatedStationInfo;
        protected boolean wasUpdated = false;
        protected SimpleRoutePart parent;

        public StationEntry(TrainStop stop, long refreshTime) {
            this(stop.getStationAlias().getAliasName().get(), stop.getStationAlias().getInfoForStation(stop.getPrediction().getStationName()), stop.getPrediction().getTicks(), refreshTime);
        }

        protected StationEntry(String stationName, TrainStationAlias.StationInfo info, int ticks, long refreshTime) {
            this.stationName = stationName;
            this.info = info;
            this.ticks = ticks;
            this.refreshTime = refreshTime;
            this.currentTicks = ticks;
            this.currentRefreshTime = refreshTime;
            this.updatedStationInfo = info;
        }

        public void shiftTime(int amount) {
            this.timeShift += amount;
            this.refreshTime += (long)amount;
            this.currentRefreshTime += (long)amount;
        }

        public int getTimeShift() {
            return this.timeShift;
        }

        protected void setParent(SimpleRoutePart parent) {
            this.parent = parent;
        }

        public SimpleRoutePart getParent() {
            return this.parent;
        }

        public String getStationName() {
            return this.stationName;
        }

        public int getTicks() {
            return this.ticks;
        }

        public long getRefreshTime() {
            return this.refreshTime;
        }

        public int getCurrentTicks() {
            return this.currentTicks;
        }

        public long getCurrentRefreshTime() {
            return this.currentRefreshTime;
        }

        public long getCurrentTime() {
            return this.currentRefreshTime + (long)this.currentTicks;
        }

        public TrainStationAlias.StationInfo getInfo() {
            return this.info;
        }

        public boolean stationInfoChanged() {
            return !this.getInfo().equals(this.getUpdatedInfo());
        }

        public TrainStationAlias.StationInfo getUpdatedInfo() {
            return this.updatedStationInfo;
        }

        public void updateRealtimeData(int ticks, long refreshTime, TrainStationAlias.StationInfo info, Runnable onDelayed) {
            this.wasUpdated = true;
            this.currentRefreshTime = refreshTime;
            this.currentTicks = ticks;
            this.updatedStationInfo = info;
        }

        public long getScheduleTime() {
            return this.getRefreshTime() + (long)this.getTicks();
        }

        public long getEstimatedTime() {
            return this.getCurrentRefreshTime() + (long)this.getCurrentTicks();
        }

        public long getDifferenceTime() {
            return this.getEstimatedTime() - this.getScheduleTime();
        }

        public long getEstimatedTimeWithThreshold() {
            return this.getScheduleTime() + this.getDifferenceTime() / (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue() * (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue();
        }

        public StationTrainDetails getTrain() {
            return this.train;
        }

        public int getIndex() {
            return this.index;
        }

        public StationTag getTag() {
            return this.tag;
        }

        public boolean isDelayed() {
            return this.getEstimatedTime() - (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() > this.getScheduleTime();
        }

        public void setDeparted(boolean b) {
            this.departed = this.departed || b;
        }

        public void setWillMiss(boolean b) {
            this.willMiss = b;
        }

        public void setTrainCanceled(boolean b, String reason, String trainName) {
            if (b) {
                this.getParent().getParent().invalidate(reason, trainName);
            }
            this.trainCanceled = b;
        }

        public boolean isDeparted() {
            return this.departed;
        }

        public boolean willMissStop() {
            return this.willMiss;
        }

        public boolean isTrainCanceled() {
            return this.trainCanceled;
        }

        public boolean reachable(boolean safeConnection) {
            return (!safeConnection || !this.willMissStop()) && !this.isDeparted() && !this.isTrainCanceled();
        }

        public boolean shouldRenderRealtime() {
            return !this.isDeparted() && !this.isTrainCanceled() && this.relatimeWasUpdated() && this.getEstimatedTime() + (long)((Integer)ModClientConfig.TRANSFER_TIME.get()).intValue() + (long)((Integer)ModClientConfig.REALTIME_EARLY_ARRIVAL_THRESHOLD.get()).intValue() > this.getScheduleTime();
        }

        public boolean relatimeWasUpdated() {
            return this.wasUpdated;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582(NBT_NAME, this.getStationName());
            nbt.method_10569(NBT_TICKS, this.getTicks());
            this.getInfo().writeNbt(nbt);
            return nbt;
        }

        public static StationEntry fromNbt(class_2487 nbt, long refreshTime) {
            String stationName = nbt.method_10558(NBT_NAME);
            int ticks = nbt.method_10550(NBT_TICKS);
            TrainStationAlias.StationInfo info = TrainStationAlias.StationInfo.fromNbt(nbt);
            return new StationEntry(stationName, info, ticks, refreshTime);
        }
    }

    public static class SimpleRoutePart {
        private static final String NBT_TRAIN_NAME = "TrainName";
        private static final String NBT_TRAIN_ID = "TrainId";
        private static final String NBT_TRAIN_ICON_ID = "TrainIconId";
        private static final String NBT_SCHEDULE_TITLE = "ScheduleTitle";
        private static final String NBT_START_STATION = "StartStation";
        private static final String NBT_END_STATION = "EndStation";
        private static final String NBT_STOPOVERS = "Stopovers";
        protected SimpleRoute parent;
        protected final String trainName;
        protected final UUID trainId;
        protected final class_2960 trainIconId;
        protected final String scheduleTitle;
        protected final StationEntry start;
        protected final StationEntry end;
        protected final Collection<StationEntry> stopovers;
        protected List<StationEntry> allStations = null;

        public SimpleRoutePart(RoutePart part, long refreshTime) {
            this(part.getTrain().name.getString(), part.getTrain().id, part.getTrain().icon.getId(), part.getStartStation().getPrediction().getScheduleTitle(), new StationEntry(part.getStartStation(), refreshTime), new StationEntry(part.getEndStation(), refreshTime), part.getStopovers().stream().map(x -> new StationEntry((TrainStop)x, refreshTime)).toList());
        }

        protected SimpleRoutePart(String trainName, UUID trainId, class_2960 trainIconId, String scheduleTitle, StationEntry start, StationEntry end, Collection<StationEntry> stopovers) {
            this.trainName = trainName;
            this.trainId = trainId;
            this.trainIconId = trainIconId;
            this.scheduleTitle = scheduleTitle;
            this.start = start;
            this.end = end;
            this.stopovers = stopovers;
            this.getStations().forEach(x -> x.setParent(this));
        }

        public void shiftTime(int amount) {
            this.getStations().forEach(x -> x.shiftTime(amount));
        }

        protected void setParent(SimpleRoute parent) {
            this.parent = parent;
        }

        protected SimpleRoute getParent() {
            return this.parent;
        }

        public String getTrainName() {
            return this.trainName;
        }

        public UUID getTrainID() {
            return this.trainId;
        }

        public TrainIconType getTrainIcon() {
            return TrainIconType.byId((class_2960)this.trainIconId);
        }

        public String getScheduleTitle() {
            return this.scheduleTitle;
        }

        public StationEntry getStartStation() {
            return this.start;
        }

        public StationEntry getEndStation() {
            return this.end;
        }

        public Collection<StationEntry> getStopovers() {
            return this.stopovers;
        }

        public List<StationEntry> getStations() {
            if (this.allStations != null) {
                return this.allStations;
            }
            this.allStations = new ArrayList<StationEntry>(this.stopovers);
            this.allStations.add(0, this.getStartStation());
            this.allStations.add(this.getEndStation());
            return this.allStations;
        }

        public int getStationCount(boolean includeStartEnd) {
            return this.getStopovers().size() + (includeStartEnd ? 2 : 0);
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582(NBT_TRAIN_NAME, this.getTrainName());
            nbt.method_10582(NBT_SCHEDULE_TITLE, this.getScheduleTitle());
            nbt.method_25927(NBT_TRAIN_ID, this.getTrainID());
            nbt.method_10582(NBT_TRAIN_ICON_ID, this.trainIconId.toString());
            nbt.method_10566(NBT_START_STATION, (class_2520)this.getStartStation().toNbt());
            nbt.method_10566(NBT_END_STATION, (class_2520)this.getEndStation().toNbt());
            class_2499 stopoversTag = new class_2499();
            stopoversTag.addAll(this.stopovers.stream().map(x -> x.toNbt()).toList());
            nbt.method_10566(NBT_STOPOVERS, (class_2520)stopoversTag);
            return nbt;
        }

        public static SimpleRoutePart fromNbt(class_2487 nbt, long refreshTime) {
            String trainName = nbt.method_10558(NBT_TRAIN_NAME);
            String scheduleTitle = nbt.method_10558(NBT_SCHEDULE_TITLE);
            UUID trainId = nbt.method_25926(NBT_TRAIN_ID);
            class_2960 trainIconId = new class_2960(nbt.method_10558(NBT_TRAIN_ICON_ID));
            StationEntry start = StationEntry.fromNbt(nbt.method_10562(NBT_START_STATION), refreshTime);
            StationEntry end = StationEntry.fromNbt(nbt.method_10562(NBT_END_STATION), refreshTime);
            List<StationEntry> stopovers = nbt.method_10554(NBT_STOPOVERS, 10).stream().map(x -> StationEntry.fromNbt((class_2487)x, refreshTime)).toList();
            SimpleRoutePart part = new SimpleRoutePart(trainName, trainId, trainIconId, scheduleTitle, start, end, stopovers);
            start.setParent(part);
            end.setParent(part);
            stopovers.forEach(x -> x.setParent(part));
            return part;
        }
    }

    public record StationTrainDetails(String trainName, UUID trainId, String scheduleTitle) {
    }

    public static enum StationTag {
        TRANSIT,
        START,
        PART_START,
        PART_END,
        END;

    }
}

