/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalTrainData;
import de.mrjulsen.crn.data.SimulatedTrainSchedule;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.event.listeners.TrainListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimpleTrainSchedule {
    private Collection<TrainStop> stops;

    public SimpleTrainSchedule(Train train) {
        this(GlobalTrainData.getInstance().getAllStopsSorted(train));
    }

    private SimpleTrainSchedule(Collection<TrainStop> stations) {
        this.stops = stations;
    }

    public static SimpleTrainSchedule of(Collection<TrainStop> stations) {
        return new SimpleTrainSchedule(stations);
    }

    public Collection<TrainStop> getAllStops() {
        return this.stops;
    }

    public Collection<TrainStop> getAllStopsFrom(TrainStationAlias alias) {
        boolean[] startFound = new boolean[]{false};
        return this.stops.stream().dropWhile(x -> {
            if (x.getStationAlias().equals(alias)) {
                startFound[0] = true;
            }
            return !startFound[0];
        }).toList();
    }

    public SimpleTrainSchedule copy() {
        return new SimpleTrainSchedule(this.stops.stream().map(x -> x.copy()).toList());
    }

    public SimpleTrainSchedule makeScheduleUntilNextRepeat() {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        for (TrainStop stop : this.getAllStops()) {
            if (newList.contains(stop)) break;
            newList.add(stop);
        }
        return SimpleTrainSchedule.of(newList);
    }

    public SimpleTrainSchedule makeScheduleFrom(TrainStationAlias alias, boolean preventDuplicates) {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        int idx = 0;
        for (TrainStop stop : this.getAllStops()) {
            if (preventDuplicates && newList.contains(stop)) continue;
            if (stop.getStationAlias().equals(alias)) {
                idx = 0;
            }
            newList.add(idx, stop);
            ++idx;
        }
        return SimpleTrainSchedule.of(newList);
    }

    public SimpleTrainSchedule makeDirectionalScheduleFrom(TrainStationAlias alias) {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        for (TrainStop stop : this.makeScheduleFrom(alias, false).getAllStops()) {
            if (newList.contains(stop)) break;
            newList.add(stop);
        }
        return SimpleTrainSchedule.of(newList);
    }

    public SimpleTrainSchedule makeDirectionalSchedule() {
        ArrayList<TrainStop> newList = new ArrayList<TrainStop>();
        boolean isRepeating = false;
        for (TrainStop stop : this.getAllStops()) {
            if (newList.contains(stop)) {
                isRepeating = true;
                continue;
            }
            if (isRepeating) {
                newList.add(0, stop);
                continue;
            }
            newList.add(stop);
        }
        return SimpleTrainSchedule.of(newList);
    }

    public boolean hasStation(GlobalStation station) {
        return this.getAllStops().stream().anyMatch(x -> x.isStation(station));
    }

    public boolean hasStationAlias(TrainStationAlias station) {
        return this.getAllStops().stream().anyMatch(x -> x.isStationAlias(station));
    }

    public Optional<TrainStop> getLastStop(TrainStationAlias start) {
        Optional<TrainStop> lastStop = this.getAllStops().stream().reduce((a, b) -> b);
        return lastStop.get().getStationAlias().equals(start) ? this.getFirstStop() : lastStop;
    }

    public Optional<TrainStop> getFirstStop() {
        return this.getAllStops().stream().findFirst();
    }

    public Optional<TrainStop> getNextStop() {
        return this.getAllStops().stream().min((a, b) -> a.getPrediction().getTicks());
    }

    public Optional<TrainStop> getNextStopOf(TrainStationAlias alias) {
        return this.getAllStops().stream().filter(x -> x.getStationAlias().equals(alias)).min(Comparator.comparingInt(x -> x.getPrediction().getTicks()));
    }

    public List<TrainStop> getAllStopsOf(TrainStationAlias alias) {
        return this.getAllStops().stream().filter(x -> x.getStationAlias().equals(alias)).toList();
    }

    public List<TrainStop> getAllStopsOf(String station) {
        return this.getAllStops().stream().filter(x -> x.getPrediction().getStationName().equals(station)).toList();
    }

    public boolean isInDirection(TrainStationAlias start, TrainStationAlias end) {
        for (TrainStop stop : this.getAllStops()) {
            if (stop.getStationAlias().equals(start)) {
                return true;
            }
            if (!stop.getStationAlias().equals(end)) continue;
            return false;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleTrainSchedule) {
            SimpleTrainSchedule other = (SimpleTrainSchedule)obj;
            HashSet<TrainStop> thisStops = new HashSet<TrainStop>(this.getAllStops());
            HashSet<TrainStop> otherStops = new HashSet<TrainStop>(other.getAllStops());
            if (thisStops.size() != otherStops.size()) {
                return false;
            }
            return thisStops.containsAll(otherStops);
        }
        return false;
    }

    public boolean exactEquals(Object obj) {
        if (obj instanceof SimpleTrainSchedule) {
            SimpleTrainSchedule other = (SimpleTrainSchedule)obj;
            if (this.getAllStops().size() != other.getAllStops().size()) {
                return false;
            }
            TrainStop[] a = (TrainStop[])this.getAllStops().toArray(TrainStop[]::new);
            TrainStop[] b = (TrainStop[])other.getAllStops().toArray(TrainStop[]::new);
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 17 * Objects.hash(this.stops);
    }

    public String toString() {
        return Arrays.toString(this.stops.toArray());
    }

    public static int getTrainCycleDuration(Train train) {
        return TrainListener.getInstance().getApproximatedTrainDuration(train);
    }

    public SimulatedTrainSchedule simulate(Train train, int simulationTime, TrainStationAlias simulationTarget) {
        int cycleDuration = SimpleTrainSchedule.getTrainCycleDuration(train);
        int timeToTargetAfterSim = this.getAllStopsOf(simulationTarget).stream().mapToInt(x -> {
            int v = (int)((double)(x.getPrediction().getTicks() - simulationTime) % (double)cycleDuration);
            if (v < 0) {
                v += cycleDuration;
            }
            return v;
        }).min().orElse(0);
        int simToTargetTime = simulationTime + timeToTargetAfterSim;
        return new SimulatedTrainSchedule(this.getAllStops().parallelStream().map(x -> {
            int cycle = (int)((double)(x.getPrediction().getTicks() - simToTargetTime) / (double)cycleDuration);
            int estimatedTicks = (x.getPrediction().getTicks() - simToTargetTime) % cycleDuration;
            while (estimatedTicks < 0) {
                estimatedTicks += cycleDuration;
                ++cycle;
            }
            return new TrainStop(x.getStationAlias(), new DeparturePrediction(x.getPrediction().getTrain(), estimatedTicks, x.getPrediction().getScheduleTitle(), x.getPrediction().getStationName(), cycle += x.getPrediction().getCycle(), x.getPrediction().getInfo()));
        }).sorted(Comparator.comparingInt(x -> x.getPrediction().getTicks())).toList(), new SimulatedTrainSchedule.SimulationData(this.getFirstStop().get().getPrediction().getTrain(), simulationTime, timeToTargetAfterSim));
    }

    public SimulatedTrainSchedule simulate(Train train, int simulationTime, String simulationTarget) {
        int cycleDuration = SimpleTrainSchedule.getTrainCycleDuration(train);
        int timeToTargetAfterSim = this.getAllStopsOf(simulationTarget).stream().mapToInt(x -> {
            int v = (int)((double)(x.getPrediction().getTicks() - simulationTime) % (double)cycleDuration);
            if (v < 0) {
                v += cycleDuration;
            }
            return v;
        }).min().orElse(0);
        int simToTargetTime = simulationTime + timeToTargetAfterSim;
        return new SimulatedTrainSchedule(this.getAllStops().parallelStream().map(x -> {
            int cycle = (int)((double)(x.getPrediction().getTicks() - simToTargetTime) / (double)cycleDuration);
            int estimatedTicks = (x.getPrediction().getTicks() - simToTargetTime) % cycleDuration;
            while (estimatedTicks < 0) {
                estimatedTicks += cycleDuration;
                ++cycle;
            }
            return new TrainStop(x.getStationAlias(), new DeparturePrediction(x.getPrediction().getTrain(), estimatedTicks, x.getPrediction().getScheduleTitle(), x.getPrediction().getStationName(), cycle += x.getPrediction().getCycle(), x.getPrediction().getInfo()));
        }).sorted(Comparator.comparingInt(x -> x.getPrediction().getTicks())).toList(), new SimulatedTrainSchedule.SimulationData(this.getFirstStop().get().getPrediction().getTrain(), simulationTime, timeToTargetAfterSim));
    }

    public SimpleTrainSchedule simulate(Train train, int simulationTime) {
        int cycleDuration = SimpleTrainSchedule.getTrainCycleDuration(train);
        return new SimpleTrainSchedule(this.getAllStops().parallelStream().map(x -> {
            int cycle = (int)((double)(x.getPrediction().getTicks() - simulationTime) / (double)cycleDuration);
            int estimatedTicks = (x.getPrediction().getTicks() - simulationTime) % cycleDuration;
            while (estimatedTicks < 0) {
                estimatedTicks += cycleDuration;
                ++cycle;
            }
            return new TrainStop(x.getStationAlias(), new DeparturePrediction(x.getPrediction().getTrain(), estimatedTicks, x.getPrediction().getScheduleTitle(), x.getPrediction().getStationName(), cycle += x.getPrediction().getCycle(), x.getPrediction().getInfo()));
        }).sorted(Comparator.comparingInt(x -> x.getPrediction().getTicks())).toList());
    }
}

