/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.event.listeners;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_310;

public class JourneyListenerManager {
    private static final int CLEANUP_INTERVALL = 100;
    private static JourneyListenerManager instance;
    private int cleanupTimer = 0;
    private final Map<UUID, JourneyListener> journeyListenerCache = new HashMap<UUID, JourneyListener>();
    private final Map<UUID, Set<UUID>> dataListeners = new HashMap<UUID, Set<UUID>>();

    public UUID register(JourneyListener listener) {
        UUID uuid = UUID.randomUUID();
        while (this.journeyListenerCache.containsKey(uuid)) {
            uuid = UUID.randomUUID();
        }
        this.journeyListenerCache.put(uuid, listener);
        return uuid;
    }

    public UUID create(SimpleRoute route, IJourneyListenerClient initialListener) {
        UUID id = this.register(new JourneyListener(route));
        this.dataListeners.put(id, new HashSet<UUID>(Set.of(initialListener.getJourneyListenerClientId())));
        return id;
    }

    public JourneyListener get(UUID id, IJourneyListenerClient addListener) {
        if (addListener != null) {
            if (this.dataListeners.containsKey(id)) {
                this.dataListeners.get(id).add(addListener.getJourneyListenerClientId());
            } else {
                this.dataListeners.put(id, new HashSet<UUID>(Set.of(addListener.getJourneyListenerClientId())));
            }
        }
        return this.journeyListenerCache.get(id);
    }

    public void removeClientListener(UUID listenerId, IJourneyListenerClient client) {
        if (this.dataListeners.containsKey(listenerId)) {
            this.dataListeners.get(listenerId).removeIf(x -> x.equals(client.getJourneyListenerClientId()));
        }
    }

    public void removeClientListenerForAll(IJourneyListenerClient client) {
        this.dataListeners.values().forEach(x -> x.removeIf(a -> a.equals(client.getJourneyListenerClientId())));
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static void tick() {
        if (!JourneyListenerManager.hasInstance() || class_310.method_1551().field_1687 == null) {
            return;
        }
        instance.tickInstance();
    }

    private void tickInstance() {
        this.journeyListenerCache.values().forEach(x -> x.tick());
        ++this.cleanupTimer;
        this.cleanupTimer %= 100;
        if (this.cleanupTimer == 0) {
            this.dataListeners.entrySet().removeIf(x -> ((Set)x.getValue()).isEmpty());
            this.journeyListenerCache.entrySet().removeIf(e -> !this.dataListeners.containsKey(e.getKey()) || ((JourneyListener)e.getValue()).getCurrentState() == JourneyListener.State.AFTER_JOURNEY);
        }
    }

    public int getCacheSize() {
        return this.journeyListenerCache.size();
    }

    public boolean exists(UUID listenerId) {
        return this.journeyListenerCache.containsKey(listenerId);
    }

    public Collection<JourneyListener> getAllListeners() {
        return this.journeyListenerCache.values();
    }

    public static JourneyListenerManager getInstance() {
        return instance;
    }

    public static JourneyListenerManager start() {
        JourneyListenerManager.stop();
        instance = new JourneyListenerManager();
        CreateRailwaysNavigator.LOGGER.info("Journey Listener started.");
        return instance;
    }

    public static void stop() {
        if (JourneyListenerManager.hasInstance()) {
            instance.stopInstance();
        }
        instance = null;
    }

    private void stopInstance() {
        this.dataListeners.clear();
        this.journeyListenerCache.clear();
        CreateRailwaysNavigator.LOGGER.info("Journey Listener stopped.");
    }
}

