/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.AliasName;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.stc.GlobalSettingsResponsePacket;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class GlobalSettingsUpdatePacket
implements IPacketBase<GlobalSettingsUpdatePacket> {
    private static final String NBT_STRING = "Val";
    private static final String NBT_COMPOUND_TAG = "Tag";
    public long id;
    public class_2487 data;
    public EGlobalSettingsAction action;

    public GlobalSettingsUpdatePacket() {
    }

    public GlobalSettingsUpdatePacket(long id, class_2487 nbt, EGlobalSettingsAction action) {
        this.id = id;
        this.data = nbt;
        this.action = action;
    }

    public static void send(Object data, EGlobalSettingsAction action, Runnable then) {
        class_2487 nbt = new class_2487();
        switch (action) {
            case ADD_TO_BLACKLIST: 
            case REMOVE_FROM_BLACKLIST: 
            case ADD_TRAIN_TO_BLACKLIST: 
            case REMOVE_TRAIN_FROM_BLACKLIST: 
            case UNREGISTER_ALIAS_STRING: 
            case UNREGISTER_TRAIN_GROUP_TRAIN: {
                nbt.method_10582(NBT_STRING, (String)data);
                break;
            }
            case UNREGISTER_ALIAS: 
            case REGISTER_ALIAS: {
                nbt = ((TrainStationAlias)data).toNbt();
                break;
            }
            case UNREGISTER_TRAIN_GROUP: 
            case REGISTER_TRAIN_GROUP: {
                nbt = ((TrainGroup)data).toNbt();
                break;
            }
            case UPDATE_ALIAS: {
                Object[] dataArr = (Object[])data;
                nbt.method_10582(NBT_STRING, (String)dataArr[0]);
                nbt.method_10566(NBT_COMPOUND_TAG, (class_2520)((TrainStationAlias)dataArr[1]).toNbt());
                break;
            }
            case UPDATE_TRAIN_GROUP: {
                Object[] dataArr1 = (Object[])data;
                nbt.method_10582(NBT_STRING, (String)dataArr1[0]);
                nbt.method_10566(NBT_COMPOUND_TAG, (class_2520)((TrainGroup)dataArr1[1]).toNbt());
                break;
            }
            default: {
                return;
            }
        }
        CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new GlobalSettingsUpdatePacket(InstanceManager.registerClientResponseReceievedAction(then), nbt, action));
    }

    public void encode(GlobalSettingsUpdatePacket packet, class_2540 buffer) {
        buffer.writeLong(packet.id);
        buffer.method_10794(packet.data);
        buffer.method_10817((Enum)packet.action);
    }

    public GlobalSettingsUpdatePacket decode(class_2540 buffer) {
        long id = buffer.readLong();
        class_2487 data = buffer.method_10798();
        EGlobalSettingsAction action = (EGlobalSettingsAction)buffer.method_10818(EGlobalSettingsAction.class);
        GlobalSettingsUpdatePacket instance = new GlobalSettingsUpdatePacket(id, data, action);
        return instance;
    }

    public void handle(GlobalSettingsUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            if (GlobalSettingsManager.getInstance().getSettingsData() == null) {
                CreateRailwaysNavigator.LOGGER.error("Failed to handle GlobalSettingsUpdatePacket! The settings instance of the global settings manager is null.");
                return;
            }
            switch (packet.action) {
                case ADD_TO_BLACKLIST: {
                    GlobalSettingsManager.getInstance().getSettingsData().addToBlacklistServer(packet.data.method_10558(NBT_STRING));
                    break;
                }
                case REMOVE_FROM_BLACKLIST: {
                    GlobalSettingsManager.getInstance().getSettingsData().removeFromBlacklistServer(packet.data.method_10558(NBT_STRING));
                    break;
                }
                case ADD_TRAIN_TO_BLACKLIST: {
                    GlobalSettingsManager.getInstance().getSettingsData().addTrainToBlacklistServer(packet.data.method_10558(NBT_STRING));
                    break;
                }
                case REMOVE_TRAIN_FROM_BLACKLIST: {
                    GlobalSettingsManager.getInstance().getSettingsData().removeTrainFromBlacklistServer(packet.data.method_10558(NBT_STRING));
                    break;
                }
                case UNREGISTER_ALIAS_STRING: {
                    GlobalSettingsManager.getInstance().getSettingsData().unregisterAliasServer(packet.data.method_10558(NBT_STRING));
                    break;
                }
                case UNREGISTER_ALIAS: {
                    GlobalSettingsManager.getInstance().getSettingsData().unregisterAliasServer(TrainStationAlias.fromNbt(packet.data));
                    break;
                }
                case REGISTER_ALIAS: {
                    GlobalSettingsManager.getInstance().getSettingsData().registerAliasServer(TrainStationAlias.fromNbt(packet.data));
                    break;
                }
                case UPDATE_ALIAS: {
                    GlobalSettingsManager.getInstance().getSettingsData().updateAliasServer(AliasName.of(packet.data.method_10558(NBT_STRING)), TrainStationAlias.fromNbt(packet.data.method_10562(NBT_COMPOUND_TAG)));
                    break;
                }
                case UNREGISTER_TRAIN_GROUP_TRAIN: {
                    GlobalSettingsManager.getInstance().getSettingsData().unregisterTrainGroupServer(packet.data.method_10558(NBT_STRING));
                    break;
                }
                case UNREGISTER_TRAIN_GROUP: {
                    GlobalSettingsManager.getInstance().getSettingsData().unregisterTrainGroupServer(TrainGroup.fromNbt(packet.data).getGroupName());
                    break;
                }
                case REGISTER_TRAIN_GROUP: {
                    GlobalSettingsManager.getInstance().getSettingsData().registerTrainGroupServer(TrainGroup.fromNbt(packet.data));
                    break;
                }
                case UPDATE_TRAIN_GROUP: {
                    GlobalSettingsManager.getInstance().getSettingsData().updateTrainGroupServer(packet.data.method_10558(NBT_STRING), TrainGroup.fromNbt(packet.data.method_10562(NBT_COMPOUND_TAG)));
                    break;
                }
                default: {
                    return;
                }
            }
            GlobalSettingsManager.getInstance().method_80();
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new GlobalSettingsResponsePacket(packet.id, GlobalSettingsManager.getInstance().getSettingsData()));
        });
    }

    public static enum EGlobalSettingsAction {
        REGISTER_ALIAS,
        UNREGISTER_ALIAS_STRING,
        UNREGISTER_ALIAS,
        UPDATE_ALIAS,
        REGISTER_TRAIN_GROUP,
        UNREGISTER_TRAIN_GROUP_TRAIN,
        UNREGISTER_TRAIN_GROUP,
        UPDATE_TRAIN_GROUP,
        ADD_TO_BLACKLIST,
        REMOVE_FROM_BLACKLIST,
        ADD_TRAIN_TO_BLACKLIST,
        REMOVE_TRAIN_FROM_BLACKLIST;

    }
}

