/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.core.navigation.Graph;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.Route;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.network.packets.stc.NavigationResponsePacket;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacket;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class NavigationRequestPacket
implements IPacketBase<NavigationRequestPacket> {
    public long id;
    public String start;
    public String end;
    public UserSettings filterSettings;

    public NavigationRequestPacket() {
    }

    public NavigationRequestPacket(long id, String start, String end) {
        this(id, start, end, new UserSettings());
    }

    private NavigationRequestPacket(long id, String start, String end, UserSettings settings) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.filterSettings = settings;
    }

    public void encode(NavigationRequestPacket packet, class_2540 buffer) {
        buffer.writeLong(packet.id);
        buffer.method_10814(packet.start);
        buffer.method_10814(packet.end);
        buffer.method_10794(packet.filterSettings.toNbt());
    }

    public NavigationRequestPacket decode(class_2540 buffer) {
        long id = buffer.readLong();
        String start = buffer.method_19772();
        String end = buffer.method_19772();
        UserSettings filterSettings = UserSettings.fromNbt(buffer.method_10798());
        return new NavigationRequestPacket(id, start, end, filterSettings);
    }

    public void handle(NavigationRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Thread navigationThread = new Thread(() -> NavigationRequestPacket.lambda$handle$2((Supplier)contextSupplier, packet));
            navigationThread.setPriority(1);
            navigationThread.setName("Navigator");
            navigationThread.start();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$handle$2(Supplier contextSupplier, NavigationRequestPacket packet) {
        TrainStationAlias endAlias;
        TrainStationAlias startAlias;
        long startTime;
        long updateTime;
        ArrayList<Route> routes;
        block5: {
            routes = new ArrayList<Route>();
            updateTime = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908().method_8532();
            startTime = System.currentTimeMillis();
            startAlias = GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(packet.start);
            endAlias = GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(packet.end);
            if (startAlias != null && endAlias != null) break block5;
            long estimatedTime = System.currentTimeMillis() - startTime;
            CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
            return;
        }
        try {
            Graph graph = new Graph(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908(), packet.filterSettings);
            routes.addAll(graph.navigate(startAlias, endAlias, true));
        }
        catch (Exception e) {
            try {
                CreateRailwaysNavigator.LOGGER.error("Navigation error: ", (Throwable)e);
                CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new ServerErrorPacket(e.getMessage()));
            }
            catch (Throwable throwable) {
                long estimatedTime = System.currentTimeMillis() - startTime;
                CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
                CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
                throw throwable;
            }
            long estimatedTime = System.currentTimeMillis() - startTime;
            CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
        }
        long estimatedTime = System.currentTimeMillis() - startTime;
        CreateRailwaysNavigator.LOGGER.info(String.format("Route calculated. Took %sms.", estimatedTime));
        CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new NavigationResponsePacket(packet.id, new ArrayList<SimpleRoute>(routes.stream().filter(x -> !x.isEmpty()).map(x -> new SimpleRoute((Route)x)).toList()), estimatedTime, updateTime));
    }
}

