/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.network.packets.stc.RealtimeResponsePacket;
import de.mrjulsen.crn.util.TrainUtils;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class RealtimeRequestPacket
implements IPacketBase<RealtimeRequestPacket> {
    public long requestId;
    public Collection<UUID> ids;

    public RealtimeRequestPacket() {
    }

    public RealtimeRequestPacket(long requestId, Collection<UUID> ids) {
        this.requestId = requestId;
        this.ids = ids;
    }

    public void encode(RealtimeRequestPacket packet, class_2540 buffer) {
        buffer.writeLong(packet.requestId);
        buffer.writeInt(packet.ids.size());
        for (UUID u : packet.ids) {
            buffer.method_10797(u);
        }
    }

    public RealtimeRequestPacket decode(class_2540 buffer) {
        long requestId = buffer.readLong();
        int count = buffer.readInt();
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int i = 0; i < count; ++i) {
            uuids.add(buffer.method_10790());
        }
        return new RealtimeRequestPacket(requestId, uuids);
    }

    public void handle(RealtimeRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_1937 level = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908();
            new Thread(() -> RealtimeRequestPacket.lambda$handle$4(level, packet, (Supplier)contextSupplier), "Realtime Provider").run();
        });
    }

    private static /* synthetic */ void lambda$handle$4(class_1937 level, RealtimeRequestPacket packet, Supplier contextSupplier) {
        long updateTime = level.method_8532();
        ArrayList<DeparturePrediction.SimpleDeparturePrediction> predictions = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>();
        packet.ids.forEach(arg_0 -> RealtimeRequestPacket.lambda$handle$3(predictions, (Supplier)contextSupplier, arg_0));
        CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new RealtimeResponsePacket(packet.requestId, predictions, updateTime));
    }

    private static /* synthetic */ void lambda$handle$3(Collection predictions, Supplier contextSupplier, UUID x) {
        if (!TrainUtils.isTrainIdValid(x)) {
            return;
        }
        predictions.addAll(TrainUtils.getTrainDeparturePredictions(x, ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908()).stream().map(a -> a.simplify()).filter(a -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(a.stationName())).sorted(Comparator.comparingInt(a -> a.departureTicks())).toList());
    }

    public record StationData(Collection<String> stationName, Collection<Integer> indices, UUID trainId) {
    }
}

