/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.SimpleTrainSchedule;
import de.mrjulsen.crn.data.TrainStop;
import de.mrjulsen.crn.network.packets.stc.TrainDataResponsePacket;
import de.mrjulsen.crn.util.TrainUtils;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class TrainDataRequestPacket
implements IPacketBase<TrainDataRequestPacket> {
    public long requestId;
    public UUID trainId;
    public boolean getPredictions;

    public TrainDataRequestPacket() {
    }

    public TrainDataRequestPacket(long requestId, UUID trainId, boolean getPredictions) {
        this.requestId = requestId;
        this.trainId = trainId;
        this.getPredictions = getPredictions;
    }

    public void encode(TrainDataRequestPacket packet, class_2540 buffer) {
        buffer.writeLong(packet.requestId);
        buffer.method_10797(packet.trainId);
        buffer.writeBoolean(packet.getPredictions);
    }

    public TrainDataRequestPacket decode(class_2540 buffer) {
        long requestId = buffer.readLong();
        UUID trainId = buffer.method_10790();
        boolean getPredictions = buffer.readBoolean();
        return new TrainDataRequestPacket(requestId, trainId, getPredictions);
    }

    public void handle(TrainDataRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ArrayList<TrainStop> stops;
            class_1937 level = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908();
            long updateTime = level.method_8532();
            Train train = TrainUtils.getTrain(packet.trainId);
            ArrayList<DeparturePrediction.SimpleDeparturePrediction> departurePredictions = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>();
            if (packet.getPredictions && train != null && (stops = new ArrayList<TrainStop>(TrainUtils.getTrainStopsSorted(packet.trainId, level).stream().filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(x.getPrediction().getStationName())).toList())) != null) {
                departurePredictions.addAll(SimpleTrainSchedule.of(stops).makeScheduleUntilNextRepeat().getAllStops().stream().map(x -> x.getPrediction().simplify()).toList());
            }
            CreateRailwaysNavigator.net().CHANNEL.sendToPlayer((class_3222)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new TrainDataResponsePacket(packet.requestId, new TrainData(packet.trainId, train.name.getString(), departurePredictions, train.speed, train.navigation.ticksWaitingForSignal, train.currentlyBackwards), updateTime));
        });
    }

    public static class TrainData {
        private static final String NBT_TRAIN_ID = "Id";
        private static final String NBT_SPEED = "Speed";
        private static final String NBT_WAITING_FOR_SIGNAL = "WaitingForSignal";
        private static final String NBT_NAME = "Name";
        private static final String NBT_PREDICTIONS = "Predictions";
        private static final String NBT_TRAIN_DIRECTION = "Direction";
        private final UUID trainId;
        private final String trainName;
        private final List<DeparturePrediction.SimpleDeparturePrediction> predictions;
        private final double speed;
        private final int ticksWaitingForSignal;
        private final boolean oppositeDirection;
        private final Cache<List<DeparturePrediction.SimpleDeparturePrediction>> stopovers = new Cache(() -> {
            ArrayList<DeparturePrediction.SimpleDeparturePrediction> s = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>();
            if (this.predictions().size() >= 2) {
                for (int i = 1; i < this.predictions().size() - 1; ++i) {
                    s.add(this.predictions().get(i));
                }
            }
            return s;
        });

        public TrainData(UUID trainId, String trainName, List<DeparturePrediction.SimpleDeparturePrediction> predictions, double speed, int ticksWaitingForSignal, boolean oppositeDirection) {
            this.trainId = trainId;
            this.trainName = trainName;
            this.predictions = predictions;
            this.speed = speed;
            this.ticksWaitingForSignal = ticksWaitingForSignal;
            this.oppositeDirection = oppositeDirection;
        }

        public UUID trainId() {
            return this.trainId;
        }

        public String trainName() {
            return this.trainName;
        }

        public List<DeparturePrediction.SimpleDeparturePrediction> predictions() {
            return this.predictions;
        }

        public double speed() {
            return this.speed;
        }

        public int ticksWaitingForSignal() {
            return this.ticksWaitingForSignal;
        }

        public List<DeparturePrediction.SimpleDeparturePrediction> stopovers() {
            return (List)this.stopovers.get();
        }

        public boolean isOppositeDirection() {
            return this.oppositeDirection;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_25927(NBT_TRAIN_ID, this.trainId);
            nbt.method_10549(NBT_SPEED, this.speed);
            nbt.method_10569(NBT_WAITING_FOR_SIGNAL, this.ticksWaitingForSignal);
            nbt.method_10582(NBT_NAME, this.trainName);
            nbt.method_10556(NBT_TRAIN_DIRECTION, this.oppositeDirection);
            class_2499 list = new class_2499();
            list.addAll(this.predictions().stream().map(x -> x.toNbt()).toList());
            nbt.method_10566(NBT_PREDICTIONS, (class_2520)list);
            return nbt;
        }

        public static TrainData fromNbt(class_2487 nbt) {
            return new TrainData(nbt.method_25926(NBT_TRAIN_ID), nbt.method_10558(NBT_NAME), nbt.method_10554(NBT_PREDICTIONS, 10).stream().map(x -> DeparturePrediction.SimpleDeparturePrediction.fromNbt((class_2487)x)).toList(), nbt.method_10574(NBT_SPEED), nbt.method_10550(NBT_WAITING_FOR_SIGNAL), nbt.method_10577(NBT_TRAIN_DIRECTION));
        }

        public Optional<DeparturePrediction.SimpleDeparturePrediction> getNextStop() {
            return this.predictions().size() > 0 ? Optional.of(this.predictions().get(0)) : Optional.empty();
        }

        public Optional<DeparturePrediction.SimpleDeparturePrediction> getLastStop() {
            return this.predictions().size() > 0 ? Optional.of(this.predictions().get(this.predictions().size() - 1)) : Optional.empty();
        }

        public static TrainData empty() {
            class_5250 text = TextUtils.translate((String)"block.createrailwaysnavigator.advanced_display.ber.not_in_service");
            return new TrainData(Constants.ZERO_UUID, "CRN", List.of(new DeparturePrediction.SimpleDeparturePrediction("", "", 0, text.getString(), "", Constants.ZERO_UUID, null, DeparturePrediction.TrainExitSide.UNKNOWN)), 0.0, 0, false);
        }
    }
}

