/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.stc;

import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2540;

public class TrackStationResponsePacket
implements IPacketBase<TrackStationResponsePacket> {
    public long id;
    public Collection<String> stationNames;
    public Collection<String> trainNames;
    public int listingTrainCount;
    public int totalTrainCount;

    public TrackStationResponsePacket() {
    }

    public TrackStationResponsePacket(long id, Collection<String> stationNames, Collection<String> trainNames, int listingTrainCount, int totalTrainCount) {
        this.id = id;
        this.stationNames = stationNames;
        this.trainNames = trainNames;
        this.listingTrainCount = listingTrainCount;
        this.totalTrainCount = totalTrainCount;
    }

    public void encode(TrackStationResponsePacket packet, class_2540 buffer) {
        buffer.writeLong(packet.id);
        buffer.writeInt(packet.listingTrainCount);
        buffer.writeInt(packet.totalTrainCount);
        buffer.writeInt(packet.stationNames.size());
        for (String s : packet.stationNames) {
            buffer.method_10814(s);
        }
        buffer.writeInt(packet.trainNames.size());
        for (String s : packet.trainNames) {
            buffer.method_10814(s);
        }
    }

    public TrackStationResponsePacket decode(class_2540 buffer) {
        long id = buffer.readLong();
        int listingTrainCount = buffer.readInt();
        int totalTrainCount = buffer.readInt();
        int count = buffer.readInt();
        ArrayList<String> stationNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            stationNames.add(buffer.method_19772());
        }
        count = buffer.readInt();
        ArrayList<String> trainNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            trainNames.add(buffer.method_19772());
        }
        return new TrackStationResponsePacket(id, stationNames, trainNames, listingTrainCount, totalTrainCount);
    }

    public void handle(TrackStationResponsePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        EnvExecutor.runInEnv((EnvType)EnvType.CLIENT, () -> () -> TrackStationResponsePacket.lambda$handle$1((Supplier)contextSupplier, packet));
    }

    private static /* synthetic */ void lambda$handle$1(Supplier contextSupplier, TrackStationResponsePacket packet) {
        ((NetworkManager.PacketContext)contextSupplier.get()).queue(() -> {
            ClientTrainStationSnapshot.makeNew(packet.stationNames == null || packet.stationNames.isEmpty() ? new ArrayList<String>() : new ArrayList<String>(packet.stationNames), packet.trainNames == null || packet.trainNames.isEmpty() ? new ArrayList<String>() : new ArrayList<String>(packet.trainNames), packet.listingTrainCount, packet.totalTrainCount);
            InstanceManager.runClientResponseReceievedAction(packet.id);
        });
    }
}

