/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.cog_crank;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.crank.HandCrankBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import uwu.lopyluna.create_dd.blocks.cog_crank.CogCrankBlock;
import uwu.lopyluna.create_dd.client.registry.DDBlockPartials;
import uwu.lopyluna.create_dd.registry.DDBlocks;

public class CogCrankBlockEntity
extends HandCrankBlockEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public CogCrankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.field_11863.field_9236) {
            this.updateGeneratedRotation();
        }
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    public float getGeneratedSpeed() {
        class_2248 block = this.method_11010().method_26204();
        if (!(block instanceof CogCrankBlock)) {
            return 0.0f;
        }
        CogCrankBlock crank = (CogCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.clockwise() ? -1 : 1)) * crank.getRotationSpeed();
        return speed;
    }

    protected boolean clockwise() {
        return this.backwards;
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("InUse", this.inUse);
        compound.method_10556("Backwards", this.backwards);
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.inUse = compound.method_10550("InUse");
        this.backwards = compound.method_10577("Backwards");
        super.read(compound, clientPacket);
    }

    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.field_11863.field_9236) {
                this.sequenceContext = null;
                this.updateGeneratedRotation();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public SuperByteBuffer getRenderedHandle() {
        class_2680 blockState = this.method_11010();
        class_2350 facing = blockState.method_28500((class_2769)CogCrankBlock.FACING).orElse(class_2350.field_11036);
        return CachedBufferer.partialFacing((PartialModel)DDBlockPartials.HAND_CRANK_HANDLE, (class_2680)blockState, (class_2350)facing.method_10153());
    }

    @Environment(value=EnvType.CLIENT)
    public Instancer<ModelData> getRenderedHandleInstance(Material<ModelData> material) {
        class_2680 blockState = this.method_11010();
        class_2350 facing = blockState.method_28500((class_2769)CogCrankBlock.FACING).orElse(class_2350.field_11036);
        return material.getModel(DDBlockPartials.HAND_CRANK_HANDLE, blockState, facing.method_10153());
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderCog() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderShaft() {
        return false;
    }

    protected class_2248 getStressConfigKey() {
        return DDBlocks.cogCrank.has(this.method_11010()) ? (class_2248)DDBlocks.cogCrank.get() : (class_2248)AllBlocks.COPPER_VALVE_HANDLE.get();
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            if (!DDBlocks.cogCrank.has(this.method_11010())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.field_11863, (class_2382)this.field_11867, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }
}

