/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.flywheel;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import uwu.lopyluna.create_dd.blocks.flywheel.FlywheelBlock;

public class FlywheelBlockEntity
extends GeneratingKineticBlockEntity {
    private float generatedCapacity;
    private float generatedSpeed;
    private int stoppingCooldown;
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;

    public FlywheelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void setRotation(float speed, float capacity) {
        if (this.generatedSpeed != speed || this.generatedCapacity != capacity) {
            if (speed == 0.0f) {
                if (this.stoppingCooldown == 0) {
                    this.stoppingCooldown = 40;
                }
                return;
            }
            this.stoppingCooldown = 0;
            this.generatedSpeed = speed;
            this.generatedCapacity = capacity;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        return FlywheelBlockEntity.convertToDirection((float)this.generatedSpeed, (class_2350)((class_2350)this.method_11010().method_11654(FlywheelBlock.HORIZONTAL_FACING)));
    }

    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.generatedCapacity;
        return this.lastCapacityProvided;
    }

    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2.0);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10548("GeneratedSpeed", this.generatedSpeed);
        compound.method_10548("GeneratedCapacity", this.generatedCapacity);
        compound.method_10569("Cooldown", this.stoppingCooldown);
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.generatedSpeed = compound.method_10583("GeneratedSpeed");
        this.generatedCapacity = compound.method_10583("GeneratedCapacity");
        this.stoppingCooldown = compound.method_10550("Cooldown");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.03125, LerpedFloat.Chaser.EXP);
        }
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            float targetSpeed = this.isVirtual() ? this.speed : this.getGeneratedSpeed();
            this.visualSpeed.updateChaseTarget(targetSpeed);
            this.visualSpeed.tickChaser();
            this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
            this.angle %= 360.0f;
            return;
        }
        if (this.getGeneratedSpeed() != 0.0f && this.getSpeed() == 0.0f) {
            this.updateGeneratedRotation();
        }
        if (this.stoppingCooldown == 0) {
            return;
        }
        --this.stoppingCooldown;
        if (this.stoppingCooldown == 0) {
            this.generatedCapacity = 0.0f;
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }
}

