/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.registry.pallettes.gen;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonnullType;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import uwu.lopyluna.create_dd.DDConstants;
import uwu.lopyluna.create_dd.registry.pallettes.DDPaletteStoneTypes;
import uwu.lopyluna.create_dd.registry.pallettes.gen.DDPaletteBlockPattern;

public abstract class DDPaletteBlockPartial<B extends class_2248> {
    public static final DDPaletteBlockPartial<class_2510> STAIR = new Stairs();
    public static final DDPaletteBlockPartial<class_2482> SLAB = new Slab(false);
    public static final DDPaletteBlockPartial<class_2482> UNIQUE_SLAB = new Slab(true);
    public static final DDPaletteBlockPartial<class_2544> WALL = new Wall();
    public static final DDPaletteBlockPartial<?>[] ALL_PARTIALS = new DDPaletteBlockPartial[]{STAIR, SLAB, WALL};
    public static final DDPaletteBlockPartial<?>[] FOR_POLISHED = new DDPaletteBlockPartial[]{STAIR, UNIQUE_SLAB, WALL};
    private String name;

    private DDPaletteBlockPartial(String name) {
        this.name = name;
    }

    @NonnullType
    public BlockBuilder<B, CreateRegistrate> create(String variantName, DDPaletteBlockPattern pattern, BlockEntry<? extends class_2248> block, DDPaletteStoneTypes variant) {
        String patternName = Lang.nonPluralId((String)pattern.createName(variantName));
        String blockName = patternName + "_" + this.name;
        BlockBuilder blockBuilder = (BlockBuilder)DDConstants.REGISTRATE.block(blockName, p -> this.createBlock((Supplier<class_2248>)block)).blockstate((c, p) -> this.generateBlockState((DataGenContext<class_2248, B>)c, (RegistrateBlockstateProvider)p, variantName, pattern, (Supplier<? extends class_2248>)((Supplier<class_2248>)block))).recipe((c, p) -> this.createRecipes(variant, (BlockEntry<? extends class_2248>)((BlockEntry<class_2248>)block), (DataGenContext<class_2248, ? extends class_2248>)((DataGenContext<class_2248, class_2248>)c), (RegistrateRecipeProvider)p)).transform(b -> this.transformBlock((BlockBuilder<B, CreateRegistrate>)b, variantName, pattern));
        ItemBuilder itemBuilder = (ItemBuilder)blockBuilder.item().transform(b -> this.transformItem((ItemBuilder<class_1747, BlockBuilder<B, CreateRegistrate>>)b, variantName, pattern));
        if (this.canRecycle()) {
            itemBuilder.tag(new class_6862[]{variant.materialTag});
        }
        return (BlockBuilder)itemBuilder.build();
    }

    protected class_2960 getTexture(String variantName, DDPaletteBlockPattern pattern, int index) {
        return DDPaletteBlockPattern.toLocation(variantName, pattern.getTexture(index));
    }

    protected BlockBuilder<B, CreateRegistrate> transformBlock(BlockBuilder<B, CreateRegistrate> builder, String variantName, DDPaletteBlockPattern pattern) {
        this.getBlockTags().forEach(xva$0 -> builder.tag(new class_6862[]{xva$0}));
        return (BlockBuilder)builder.transform(TagGen.pickaxeOnly());
    }

    protected ItemBuilder<class_1747, BlockBuilder<B, CreateRegistrate>> transformItem(ItemBuilder<class_1747, BlockBuilder<B, CreateRegistrate>> builder, String variantName, DDPaletteBlockPattern pattern) {
        this.getItemTags().forEach(xva$0 -> builder.tag(new class_6862[]{xva$0}));
        return builder;
    }

    protected boolean canRecycle() {
        return true;
    }

    protected abstract Iterable<class_6862<class_2248>> getBlockTags();

    protected abstract Iterable<class_6862<class_1792>> getItemTags();

    protected abstract B createBlock(Supplier<? extends class_2248> var1);

    protected abstract void createRecipes(DDPaletteStoneTypes var1, BlockEntry<? extends class_2248> var2, DataGenContext<class_2248, ? extends class_2248> var3, RegistrateRecipeProvider var4);

    protected abstract void generateBlockState(DataGenContext<class_2248, B> var1, RegistrateBlockstateProvider var2, String var3, DDPaletteBlockPattern var4, Supplier<? extends class_2248> var5);

    private static class Stairs
    extends DDPaletteBlockPartial<class_2510> {
        public Stairs() {
            super("stairs");
        }

        @Override
        protected class_2510 createBlock(Supplier<? extends class_2248> block) {
            return new class_2510(block.get().method_9564(), class_4970.class_2251.method_9630((class_4970)((class_4970)block.get())));
        }

        @Override
        protected void generateBlockState(DataGenContext<class_2248, class_2510> ctx, RegistrateBlockstateProvider prov, String variantName, DDPaletteBlockPattern pattern, Supplier<? extends class_2248> block) {
            prov.stairsBlock((class_2510)ctx.get(), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<class_6862<class_2248>> getBlockTags() {
            return Arrays.asList(class_3481.field_15459);
        }

        @Override
        protected Iterable<class_6862<class_1792>> getItemTags() {
            return Arrays.asList(class_3489.field_15526);
        }

        @Override
        protected void createRecipes(DDPaletteStoneTypes type, BlockEntry<? extends class_2248> patternBlock, DataGenContext<class_2248, ? extends class_2248> c, RegistrateRecipeProvider p) {
        }
    }

    private static class Slab
    extends DDPaletteBlockPartial<class_2482> {
        private boolean customSide;

        public Slab(boolean customSide) {
            super("slab");
            this.customSide = customSide;
        }

        @Override
        protected class_2482 createBlock(Supplier<? extends class_2248> block) {
            return new class_2482(class_4970.class_2251.method_9630((class_4970)((class_4970)block.get())));
        }

        @Override
        protected boolean canRecycle() {
            return false;
        }

        @Override
        protected void generateBlockState(DataGenContext<class_2248, class_2482> ctx, RegistrateBlockstateProvider prov, String variantName, DDPaletteBlockPattern pattern, Supplier<? extends class_2248> block) {
            String name = ctx.getName();
            class_2960 mainTexture = this.getTexture(variantName, pattern, 0);
            class_2960 sideTexture = this.customSide ? this.getTexture(variantName, pattern, 1) : mainTexture;
            ModelBuilder bottom = prov.models().slab(name, sideTexture, mainTexture, mainTexture);
            ModelBuilder top = prov.models().slabTop(name + "_top", sideTexture, mainTexture, mainTexture);
            Object doubleSlab = this.customSide ? prov.models().cubeColumn(name + "_double", sideTexture, mainTexture) : prov.models().getExistingFile(prov.modLoc(pattern.createName(variantName)));
            prov.slabBlock((class_2482)ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<class_6862<class_2248>> getBlockTags() {
            return Arrays.asList(class_3481.field_15469);
        }

        @Override
        protected Iterable<class_6862<class_1792>> getItemTags() {
            return Arrays.asList(class_3489.field_15535);
        }

        @Override
        protected void createRecipes(DDPaletteStoneTypes type, BlockEntry<? extends class_2248> patternBlock, DataGenContext<class_2248, ? extends class_2248> c, RegistrateRecipeProvider p) {
        }

        @Override
        protected BlockBuilder<class_2482, CreateRegistrate> transformBlock(BlockBuilder<class_2482, CreateRegistrate> builder, String variantName, DDPaletteBlockPattern pattern) {
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class Wall
    extends DDPaletteBlockPartial<class_2544> {
        public Wall() {
            super("wall");
        }

        @Override
        protected class_2544 createBlock(Supplier<? extends class_2248> block) {
            return new class_2544(class_4970.class_2251.method_9630((class_4970)((class_4970)block.get())));
        }

        @Override
        protected ItemBuilder<class_1747, BlockBuilder<class_2544, CreateRegistrate>> transformItem(ItemBuilder<class_1747, BlockBuilder<class_2544, CreateRegistrate>> builder, String variantName, DDPaletteBlockPattern pattern) {
            builder.model((c, p) -> p.wallInventory(c.getName(), this.getTexture(variantName, pattern, 0)));
            return super.transformItem(builder, variantName, pattern);
        }

        @Override
        protected void generateBlockState(DataGenContext<class_2248, class_2544> ctx, RegistrateBlockstateProvider prov, String variantName, DDPaletteBlockPattern pattern, Supplier<? extends class_2248> block) {
            prov.wallBlock((class_2544)ctx.get(), pattern.createName(variantName), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<class_6862<class_2248>> getBlockTags() {
            return Arrays.asList(class_3481.field_15504);
        }

        @Override
        protected Iterable<class_6862<class_1792>> getItemTags() {
            return Arrays.asList(class_3489.field_15560);
        }

        @Override
        protected void createRecipes(DDPaletteStoneTypes type, BlockEntry<? extends class_2248> patternBlock, DataGenContext<class_2248, ? extends class_2248> c, RegistrateRecipeProvider p) {
        }
    }
}

