/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.registry.pallettes.gen;

import com.simibubi.create.content.decoration.palettes.ConnectedPillarBlock;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.block.connected.RotatedPillarCTBehaviour;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.registry.pallettes.gen.DDPaletteBlockPartial;

public class DDPaletteBlockPattern {
    public static final DDPaletteBlockPattern CUT = DDPaletteBlockPattern.create("cut", PatternNameType.PREFIX, DDPaletteBlockPartial.ALL_PARTIALS);
    public static final DDPaletteBlockPattern BRICKS = DDPaletteBlockPattern.create("cut_bricks", PatternNameType.WRAP, DDPaletteBlockPartial.ALL_PARTIALS).textures("brick");
    public static final DDPaletteBlockPattern SMALL_BRICKS = DDPaletteBlockPattern.create("small_bricks", PatternNameType.WRAP, DDPaletteBlockPartial.ALL_PARTIALS).textures("small_brick");
    public static final DDPaletteBlockPattern POLISHED = DDPaletteBlockPattern.create("polished_cut", PatternNameType.PREFIX, DDPaletteBlockPartial.FOR_POLISHED).textures("polished", "slab");
    public static final DDPaletteBlockPattern LAYERED = DDPaletteBlockPattern.create("layered", PatternNameType.PREFIX, new DDPaletteBlockPartial[0]).blockStateFactory(p -> p::cubeColumn).textures("layered", "cap").connectedTextures(v -> new HorizontalCTBehaviour(DDPaletteBlockPattern.ct(v, CTs.LAYERED), DDPaletteBlockPattern.ct(v, CTs.CAP)));
    public static final DDPaletteBlockPattern PILLAR = DDPaletteBlockPattern.create("pillar", PatternNameType.SUFFIX, new DDPaletteBlockPartial[0]).blockStateFactory(p -> p::pillar).block((NonNullFunction<class_4970.class_2251, ? extends class_2248>)((NonNullFunction)ConnectedPillarBlock::new)).textures("pillar", "cap").connectedTextures(v -> new RotatedPillarCTBehaviour(DDPaletteBlockPattern.ct(v, CTs.PILLAR), DDPaletteBlockPattern.ct(v, CTs.CAP)));
    public static final DDPaletteBlockPattern[] STANDARD_RANGE = new DDPaletteBlockPattern[]{CUT, POLISHED, BRICKS, SMALL_BRICKS, LAYERED, PILLAR};
    static final String TEXTURE_LOCATION = "block/palettes/stone_types/%s/%s";
    private PatternNameType nameType;
    private String[] textures;
    private String id;
    private boolean isTranslucent;
    private Optional<Function<String, ConnectedTextureBehaviour>> ctFactory;
    private IPatternBlockStateGenerator blockStateGenerator;
    private NonNullFunction<class_4970.class_2251, ? extends class_2248> blockFactory;
    private NonNullFunction<NonNullSupplier<class_2248>, NonNullBiConsumer<DataGenContext<class_2248, ? extends class_2248>, RegistrateRecipeProvider>> additionalRecipes;
    private DDPaletteBlockPartial<? extends class_2248>[] partials;
    @Environment(value=EnvType.CLIENT)
    private class_1921 renderType;

    private static DDPaletteBlockPattern create(String name, PatternNameType nameType, DDPaletteBlockPartial<?> ... partials) {
        DDPaletteBlockPattern pattern = new DDPaletteBlockPattern();
        pattern.id = name;
        pattern.ctFactory = Optional.empty();
        pattern.nameType = nameType;
        pattern.partials = partials;
        pattern.additionalRecipes = $ -> NonNullBiConsumer.noop();
        pattern.isTranslucent = false;
        pattern.blockFactory = class_2248::new;
        pattern.textures = new String[]{name};
        pattern.blockStateGenerator = p -> p::cubeAll;
        return pattern;
    }

    public IPatternBlockStateGenerator getBlockStateGenerator() {
        return this.blockStateGenerator;
    }

    public NonNullFunction<class_4970.class_2251, ? extends class_2248> getBlockFactory() {
        return this.blockFactory;
    }

    public DDPaletteBlockPartial<? extends class_2248>[] getPartials() {
        return this.partials;
    }

    public String getTexture(int index) {
        return this.textures[index];
    }

    public Optional<Supplier<ConnectedTextureBehaviour>> createCTBehaviour(String variant) {
        return this.ctFactory.map(d -> () -> (ConnectedTextureBehaviour)d.apply(variant));
    }

    private DDPaletteBlockPattern blockStateFactory(IPatternBlockStateGenerator factory) {
        this.blockStateGenerator = factory;
        return this;
    }

    private DDPaletteBlockPattern textures(String ... textures) {
        this.textures = textures;
        return this;
    }

    private DDPaletteBlockPattern block(NonNullFunction<class_4970.class_2251, ? extends class_2248> blockFactory) {
        this.blockFactory = blockFactory;
        return this;
    }

    private DDPaletteBlockPattern connectedTextures(Function<String, ConnectedTextureBehaviour> factory) {
        this.ctFactory = Optional.of(factory);
        return this;
    }

    public IBlockStateProvider cubeAll(String variant) {
        class_2960 all = DDPaletteBlockPattern.toLocation(variant, this.textures[0]);
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.get(), (ModelFile)prov.models().cubeAll(this.createName(variant), all));
    }

    public IBlockStateProvider cubeBottomTop(String variant) {
        class_2960 side = DDPaletteBlockPattern.toLocation(variant, this.textures[0]);
        class_2960 bottom = DDPaletteBlockPattern.toLocation(variant, this.textures[1]);
        class_2960 top = DDPaletteBlockPattern.toLocation(variant, this.textures[2]);
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.get(), (ModelFile)prov.models().cubeBottomTop(this.createName(variant), side, bottom, top));
    }

    public IBlockStateProvider pillar(String variant) {
        class_2960 side = DDPaletteBlockPattern.toLocation(variant, this.textures[0]);
        class_2960 end = DDPaletteBlockPattern.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStatesExcept(state -> {
            class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
            if (axis == class_2350.class_2351.field_11052) {
                return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumn(this.createName(variant), side, end)).uvLock(false).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumnHorizontal(this.createName(variant) + "_horizontal", side, end)).uvLock(false).rotationX(90).rotationY(axis == class_2350.class_2351.field_11048 ? 90 : 0).build();
        }, new class_2769[]{class_2741.field_12508, ConnectedPillarBlock.NORTH, ConnectedPillarBlock.SOUTH, ConnectedPillarBlock.EAST, ConnectedPillarBlock.WEST});
    }

    public IBlockStateProvider cubeColumn(String variant) {
        class_2960 side = DDPaletteBlockPattern.toLocation(variant, this.textures[0]);
        class_2960 end = DDPaletteBlockPattern.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.get(), (ModelFile)prov.models().cubeColumn(this.createName(variant), side, end));
    }

    public String createName(String variant) {
        String[] split;
        if (this.nameType == PatternNameType.WRAP && (split = this.id.split("_")).length == 2) {
            String formatString = "%s_%s_%s";
            return String.format(formatString, split[0], variant, split[1]);
        }
        String formatString = "%s_%s";
        return this.nameType == PatternNameType.SUFFIX ? String.format(formatString, variant, this.id) : String.format(formatString, this.id, variant);
    }

    public static class_2960 toLocation(String variant, String texture) {
        return DDCreate.asResource(String.format(TEXTURE_LOCATION, texture, variant + (texture.equals("cut") ? "_" : "_cut_") + texture));
    }

    protected static CTSpriteShiftEntry ct(String variant, CTs texture) {
        class_2960 resLoc = texture.srcFactory.apply(variant);
        class_2960 resLocTarget = texture.targetFactory.apply(variant);
        return CTSpriteShifter.getCT((CTType)texture.type, (class_2960)resLoc, (class_2960)new class_2960(resLocTarget.method_12836(), resLocTarget.method_12832() + "_connected"));
    }

    static enum PatternNameType {
        PREFIX,
        SUFFIX,
        WRAP;

    }

    @FunctionalInterface
    static interface IPatternBlockStateGenerator
    extends Function<DDPaletteBlockPattern, Function<String, IBlockStateProvider>> {
    }

    @FunctionalInterface
    static interface IBlockStateProvider
    extends NonNullBiConsumer<DataGenContext<class_2248, ? extends class_2248>, RegistrateBlockstateProvider> {
    }

    public static enum CTs {
        PILLAR((CTType)AllCTTypes.RECTANGLE, s -> DDPaletteBlockPattern.toLocation(s, "pillar")),
        CAP((CTType)AllCTTypes.OMNIDIRECTIONAL, s -> DDPaletteBlockPattern.toLocation(s, "cap")),
        LAYERED((CTType)AllCTTypes.HORIZONTAL_KRYPPERS, s -> DDPaletteBlockPattern.toLocation(s, "layered"));

        public CTType type;
        private Function<String, class_2960> srcFactory;
        private Function<String, class_2960> targetFactory;

        private CTs(CTType type, Function<String, class_2960> factory) {
            this(type, factory, factory);
        }

        private CTs(CTType type, Function<String, class_2960> srcFactory, Function<String, class_2960> targetFactory) {
            this.type = type;
            this.srcFactory = srcFactory;
            this.targetFactory = targetFactory;
        }
    }
}

