/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryOnData {
    private CarryType type;
    private class_2487 nbt;
    private boolean keyPressed = false;
    private CarryOnScript activeScript;
    private int selectedSlot = 0;

    public CarryOnData(class_2487 data) {
        this.type = data.method_10545("type") ? CarryType.valueOf(data.method_10558("type")) : CarryType.INVALID;
        this.nbt = data;
        if (data.method_10545("keyPressed")) {
            this.keyPressed = data.method_10577("keyPressed");
        }
        if (data.method_10545("activeScript")) {
            DataResult res = CarryOnScript.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)data.method_10580("activeScript"));
            this.activeScript = (CarryOnScript)res.getOrThrow(false, s -> {
                throw new RuntimeException("Failed to decode activeScript during CarryOnData serialization: " + s);
            });
        }
        if (data.method_10545("selected")) {
            this.selectedSlot = data.method_10550("selected");
        }
    }

    public class_2487 getNbt() {
        this.nbt.method_10582("type", this.type.toString());
        this.nbt.method_10556("keyPressed", this.keyPressed);
        if (this.activeScript != null) {
            DataResult res = CarryOnScript.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.activeScript);
            class_2520 tag = (class_2520)res.getOrThrow(false, s -> {
                throw new RuntimeException("Failed to encode activeScript during CarryOnData serialization: " + s);
            });
            this.nbt.method_10566("activeScript", tag);
        }
        this.nbt.method_10569("selected", this.selectedSlot);
        return this.nbt;
    }

    public class_2487 getContentNbt() {
        if (this.type == CarryType.BLOCK && this.nbt.method_10545("block")) {
            return this.nbt.method_10562("block");
        }
        if (this.type == CarryType.ENTITY && this.nbt.method_10545("entity")) {
            return this.nbt.method_10562("entity");
        }
        return null;
    }

    public void setBlock(class_2680 state, @Nullable class_2586 tile) {
        this.type = CarryType.BLOCK;
        if (state.method_28498((class_2769)class_2741.field_12508)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        }
        class_2487 stateData = class_2512.method_10686((class_2680)state);
        this.nbt.method_10566("block", (class_2520)stateData);
        if (tile != null) {
            class_2487 tileData = tile.method_38243();
            this.nbt.method_10566("tile", (class_2520)tileData);
        }
    }

    public class_2680 getBlock() {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlock on data that contained " + this.type);
        }
        return class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)this.nbt.method_10562("block"));
    }

    @Nullable
    public class_2586 getBlockEntity(class_2338 pos) {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlockEntity on data that contained " + this.type);
        }
        if (!this.nbt.method_10545("tile")) {
            return null;
        }
        return class_2586.method_11005((class_2338)pos, (class_2680)this.getBlock(), (class_2487)this.nbt.method_10562("tile"));
    }

    public void setEntity(class_1297 entity) {
        this.type = CarryType.ENTITY;
        class_2487 entityData = new class_2487();
        entity.method_5662(entityData);
        this.nbt.method_10566("entity", (class_2520)entityData);
    }

    public class_1297 getEntity(class_1937 level) {
        if (this.type != CarryType.ENTITY) {
            throw new IllegalStateException("Called getEntity on data that contained " + this.type);
        }
        Optional optionalEntity = class_1299.method_5892((class_2487)this.nbt.method_10562("entity"), (class_1937)level);
        if (optionalEntity.isPresent()) {
            return (class_1297)optionalEntity.get();
        }
        Constants.LOG.error("Called EntityType#create even though no entity data was present. Data: " + this.nbt.toString());
        this.clear();
        return new class_1295(level, 0.0, 0.0, 0.0);
    }

    public Optional<CarryOnScript> getActiveScript() {
        if (this.activeScript == null) {
            return Optional.empty();
        }
        return Optional.of(this.activeScript);
    }

    public void setActiveScript(CarryOnScript script) {
        this.activeScript = script;
    }

    public void setCarryingPlayer() {
        this.type = CarryType.PLAYER;
    }

    public boolean isCarrying() {
        return this.type != CarryType.INVALID;
    }

    public boolean isCarrying(CarryType type) {
        return this.type == type;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public void setKeyPressed(boolean val) {
        this.keyPressed = val;
        this.nbt.method_10556("keyPressed", val);
    }

    public void setSelected(int selectedSlot) {
        this.selectedSlot = selectedSlot;
    }

    public int getSelected() {
        return this.selectedSlot;
    }

    public void clear() {
        this.type = CarryType.INVALID;
        this.nbt = new class_2487();
        this.activeScript = null;
    }

    public int getTick() {
        if (!this.nbt.method_10545("tick")) {
            return -1;
        }
        return this.nbt.method_10550("tick");
    }

    public static enum CarryType {
        BLOCK,
        ENTITY,
        PLAYER,
        INVALID;

    }
}

