/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robocraft999.creategoggles.registry.CGRecipeTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class NBTCraftingRecipeBuilder
implements class_5797 {
    private final class_1792 result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final class_161.class_162 advancement = class_161.class_162.method_707();
    @javax.annotation.Nullable
    private String group;

    public NBTCraftingRecipeBuilder(class_1935 result, int count) {
        this.result = result.method_8389();
        this.count = count;
    }

    public static NBTCraftingRecipeBuilder shaped(class_1935 result) {
        return NBTCraftingRecipeBuilder.shaped(result, 1);
    }

    public static NBTCraftingRecipeBuilder shaped(class_1935 result, int count) {
        return new NBTCraftingRecipeBuilder(result, count);
    }

    public NBTCraftingRecipeBuilder define(Character tag, class_6862<class_1792> item) {
        return this.define(tag, class_1856.method_8106(item));
    }

    public NBTCraftingRecipeBuilder define(Character tag, class_1935 item) {
        return this.define(tag, class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public NBTCraftingRecipeBuilder define(Character tag, class_1856 item) {
        if (this.key.containsKey(tag)) {
            throw new IllegalArgumentException("Symbol '" + tag + "' is already defined!");
        }
        if (tag.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(tag, item);
        return this;
    }

    public NBTCraftingRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public NBTCraftingRecipeBuilder unlockedBy(String name, class_184 trigger) {
        this.advancement.method_709(name, trigger);
        return this;
    }

    public NBTCraftingRecipeBuilder group(@javax.annotation.Nullable String group) {
        this.group = group;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> writer, class_2960 id) {
        this.ensureValid(id);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
        writer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, new class_2960(id.method_12836(), "recipes/" + id.method_12832())));
    }

    private void ensureValid(class_2960 p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public Result(class_2960 resourceLocation, class_1792 item, int i, String string, List<String> list, Map<Character, class_1856> map, class_161.class_162 builder, class_2960 resourceLocation2) {
            this.id = resourceLocation;
            this.result = item;
            this.count = i;
            this.group = string;
            this.pattern = list;
            this.key = map;
            this.advancement = builder;
            this.advancementId = resourceLocation2;
        }

        public void method_10416(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : this.pattern) {
                jsonArray.add(string);
            }
            jsonObject.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject2 = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonObject2.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            jsonObject.add("key", (JsonElement)jsonObject2);
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty("item", this.result.arch$registryName().toString());
            if (this.count > 1) {
                jsonObject3.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject3);
        }

        public class_1865<?> method_17800() {
            return (class_1865)CGRecipeTypes.CRAFTING_NBT.get();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

