/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.fabric.util.compat;

import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import xaeroplus.fabric.util.compat.MinimapBaseVersionCheck;
import xaeroplus.fabric.util.compat.VersionCheckResult;

public class XaeroPlusCompatibleMinimapMixinPlugin
implements IMixinConfigPlugin {
    private VersionCheckResult versionCheckResult;
    private boolean tryMinimapSettingsMixins;
    private Set<String> xaeroMinimapSettingsMixins;
    private Set<String> xaeroWorldMapSettingsMixins;

    public void onLoad(String mixinPackage) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        this.versionCheckResult = MinimapBaseVersionCheck.versionCheck();
        this.tryMinimapSettingsMixins = this.versionCheckResult.anyPresentMinimapVersion().isPresent();
        if (!this.versionCheckResult.minimapCompatible()) {
            if (this.tryMinimapSettingsMixins) {
                this.xaeroMinimapSettingsMixins = Set.of("MixinBetterPVP", "MixinCrashHandler", "MixinMinimapModOption", "MixinMinimapModOptionsAccessor", "MixinMinimapModSettings", "MixinXaeroMinimap");
            }
            this.xaeroWorldMapSettingsMixins = Set.of("MixinWorldMap", "MixinWorldMapModSettings", "MixinWorldMapOption", "MixinMinecraftClientFabric");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return true;
        }
        if (this.versionCheckResult.minimapCompatible()) {
            return true;
        }
        if (mixinClassName.startsWith("xaeroplus")) {
            String[] classNameSplit = mixinClassName.split("\\.");
            String mixinName = classNameSplit[classNameSplit.length - 1];
            if (this.xaeroWorldMapSettingsMixins.contains(mixinName)) {
                return true;
            }
            if (this.tryMinimapSettingsMixins) {
                return this.xaeroMinimapSettingsMixins.contains(mixinName);
            }
            return false;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

