/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import org.joml.Vector2f;
import org.joml.Vector3f;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.module.impl.FpsLimiter;

public class BufferedComponent {
    private static final class_310 minecraft = class_310.method_1551();
    private static Model model = null;
    private final class_276 renderTarget = new class_6367(100, 100, true, false);
    private long fpsTimer = System.currentTimeMillis();
    private int guiScale = 0;
    private boolean isRendering = false;
    private final Supplier<Integer> fpsLimitSupplier;

    public BufferedComponent(Supplier<Integer> fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private static void refreshModel(int screenWidth, int screenHeight) {
        if (model != null) {
            model.close();
        }
        Vector3f[] modelData = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, 0.0f, -90.0f), new Vector3f(0.0f, 0.0f, -90.0f)};
        Vector2f[] uvData = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        model = new Model(modelData, uvData);
    }

    public boolean render() {
        boolean updateFrame;
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        boolean forceRender = false;
        if (this.renderTarget.field_1482 != minecraft.method_22683().method_4489() || this.renderTarget.field_1481 != minecraft.method_22683().method_4506() || (Integer)BufferedComponent.minecraft.field_1690.method_42474().method_41753() != this.guiScale) {
            this.renderTarget.method_1234(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506(), true);
            BufferedComponent.refreshModel(screenWidth, screenHeight);
            this.guiScale = (Integer)BufferedComponent.minecraft.field_1690.method_42474().method_41753();
            forceRender = true;
        }
        if (model == null) {
            BufferedComponent.refreshModel(screenWidth, screenHeight);
        }
        boolean bl = updateFrame = forceRender || System.currentTimeMillis() > this.fpsTimer;
        if (!updateFrame) {
            this.renderTextureOverlay(this.renderTarget.method_30277());
            return true;
        }
        this.renderTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.renderTarget.method_1230(false);
        this.renderTarget.method_1235(false);
        this.isRendering = true;
        FpsLimiter.renderTargetOverwrite = this.renderTarget;
        BufferedComponent.applyBlend();
        this.renderTarget.method_1235(false);
        return false;
    }

    public void postRender() {
        if (!this.isRendering) {
            return;
        }
        FpsLimiter.renderTargetOverwrite = null;
        this.renderTarget.method_1240();
        class_310.method_1551().method_1522().method_1235(true);
        this.fpsTimer = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.get());
        this.isRendering = false;
        this.renderTextureOverlay(this.renderTarget.method_30277());
    }

    private void renderTextureOverlay(int textureid) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)textureid);
        model.draw(RenderSystem.getModelViewMatrix());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void applyBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }
}

