/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightBaseCacheHandler;
import xaeroplus.feature.render.highlights.ChunkHighlightData;
import xaeroplus.feature.render.highlights.ChunkHighlightDatabase;
import xaeroplus.util.ChunkUtils;

public class ChunkHighlightCacheDimensionHandler
extends ChunkHighlightBaseCacheHandler {
    private final int dimension;
    private int windowRegionX = 0;
    private int windowRegionZ = 0;
    private int windowRegionSize = 0;
    private final ChunkHighlightDatabase database;
    private final ListeningExecutorService executorService;

    public ChunkHighlightCacheDimensionHandler(int dimension, ChunkHighlightDatabase database) {
        this.dimension = dimension;
        this.database = database;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("XaeroPlus-ChunkHighlightCacheDimensionHandler-" + database.databaseName + "-Dim" + dimension).build()));
    }

    public void setWindow(int regionX, int regionZ, int regionSize) {
        this.windowRegionX = regionX;
        this.windowRegionZ = regionZ;
        this.windowRegionSize = regionSize;
        this.writeHighlightsOutsideWindowToDatabase();
        this.loadHighlightsInWindow();
    }

    private void loadHighlightsInWindow() {
        this.executorService.execute(() -> {
            List<ChunkHighlightData> chunks = this.database.getHighlightsInWindow(this.dimension, this.windowRegionX - this.windowRegionSize, this.windowRegionX + this.windowRegionSize, this.windowRegionZ - this.windowRegionSize, this.windowRegionZ + this.windowRegionSize);
            try {
                if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                    for (ChunkHighlightData chunk : chunks) {
                        this.chunks.put(ChunkUtils.chunkPosToLong(chunk.x(), chunk.z()), chunk.foundTime());
                    }
                    this.lock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to load highlights in window", (Throwable)e);
            }
        });
    }

    private void writeHighlightsOutsideWindowToDatabase() {
        this.executorService.execute(() -> {
            ArrayList<ChunkHighlightData> chunksToWrite = new ArrayList<ChunkHighlightData>();
            try {
                if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                    this.chunks.long2LongEntrySet().removeIf(entry -> {
                        long chunkPos = entry.getLongKey();
                        int chunkX = ChunkUtils.longToChunkX(chunkPos);
                        int chunkZ = ChunkUtils.longToChunkZ(chunkPos);
                        if (chunkX < ChunkUtils.regionCoordToChunkCoord(this.windowRegionX - this.windowRegionSize) || chunkX > ChunkUtils.regionCoordToChunkCoord(this.windowRegionX + this.windowRegionSize) || chunkZ < ChunkUtils.regionCoordToChunkCoord(this.windowRegionZ - this.windowRegionSize) || chunkZ > ChunkUtils.regionCoordToChunkCoord(this.windowRegionZ + this.windowRegionSize)) {
                            chunksToWrite.add(new ChunkHighlightData(chunkX, chunkZ, entry.getLongValue()));
                            return true;
                        }
                        return false;
                    });
                    this.lock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error while writing highlights outside window to database", (Throwable)e);
            }
            this.database.insertHighlightList(chunksToWrite, this.dimension);
        });
    }

    public ListenableFuture<?> writeAllHighlightsToDatabase() {
        return this.executorService.submit(() -> {
            ArrayList<ChunkHighlightData> chunksToWrite = new ArrayList<ChunkHighlightData>();
            try {
                if (this.lock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
                    this.chunks.long2LongEntrySet().forEach(entry -> {
                        long chunkPos = entry.getLongKey();
                        int chunkX = ChunkUtils.longToChunkX(chunkPos);
                        int chunkZ = ChunkUtils.longToChunkZ(chunkPos);
                        chunksToWrite.add(new ChunkHighlightData(chunkX, chunkZ, entry.getLongValue()));
                    });
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error while writing all chunks to database", (Throwable)e);
            }
            this.database.insertHighlightList(chunksToWrite, this.dimension);
        });
    }

    @Override
    public boolean removeHighlight(int x, int z) {
        super.removeHighlight(x, z);
        this.database.removeHighlight(x, z, this.dimension);
        return true;
    }

    public void close() {
        this.executorService.shutdown();
    }

    @Override
    public void handleWorldChange() {
    }

    @Override
    public void handleTick() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }
}

