/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.io.DataInputStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.map.MapProcessor;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;
import xaeroplus.feature.extensions.SeenChunksTrackingMapTileChunk;

@Mixin(value={MapTileChunk.class}, remap=false)
public class MixinMapTileChunk
implements SeenChunksTrackingMapTileChunk {
    private final boolean[][] seenTiles = new boolean[4][4];
    @Shadow
    private LeafRegionTexture leafTexture;

    @Override
    public boolean[][] getSeenTiles() {
        return this.seenTiles;
    }

    @Inject(method={"setTile"}, at={@At(value="HEAD")})
    public void setTile(int x, int z, MapTile tile, BlockStateShortShapeCache blockStateShortShapeCache, CallbackInfo ci) {
        this.seenTiles[x][z] = tile != null;
    }

    @Inject(method={"readCacheData"}, at={@At(value="RETURN")})
    public void readCacheData(int minorSaveVersion, int majorSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer, MapProcessor mapProcessor, int x, int y, CallbackInfo ci) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.seenTiles[i][j] = this.leafTexture.getHeight(i << 4, j << 4) != -1;
            }
        }
    }
}

