/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapFBORenderer;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.OptimizedMath;
import xaeroplus.Globals;
import xaeroplus.feature.extensions.CustomMinimapFBORenderer;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.mixin.client.mc.AccessorGameOptions;
import xaeroplus.settings.XaeroPlusSettingRegistry;

@Mixin(value={MinimapFBORenderer.class}, remap=false)
public abstract class MixinMinimapFBORenderer
extends MinimapRenderer
implements CustomMinimapFBORenderer {
    @Shadow
    private ImprovedFramebuffer scalingFramebuffer;
    @Shadow
    private ImprovedFramebuffer rotationFramebuffer;
    @Shadow
    private boolean loadedFBO;

    public MixinMinimapFBORenderer(IXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface, CompassRenderer compassRenderer) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface, compassRenderer);
    }

    @ModifyConstant(method={"loadFrameBuffer"}, constant={@Constant(intValue=512)})
    public int overrideFrameBufferSize(int size) {
        return Globals.minimapScalingFactor * 512;
    }

    @Override
    public void reloadMapFrameBuffers() {
        if (!XaeroMinimapSession.getCurrentSession().getMinimapProcessor().canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            if (this.scalingFramebuffer != null) {
                this.scalingFramebuffer.method_1238();
            }
            if (this.rotationFramebuffer != null) {
                this.rotationFramebuffer.method_1238();
            }
            int scaledSize = Globals.minimapScalingFactor * 512;
            this.scalingFramebuffer = new ImprovedFramebuffer(scaledSize, scaledSize, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(scaledSize, scaledSize, true);
            this.rotationFramebuffer.method_1232(9729);
            this.loadedFBO = this.scalingFramebuffer.field_1476 != -1 && this.rotationFramebuffer.field_1476 != -1;
        }
    }

    @ModifyArg(method={"renderChunks"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapFBORenderer;renderChunksToFBO(Lxaero/common/XaeroMinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;DDDDIIFFIZZZIDDZZLxaero/common/graphics/CustomVertexConsumers;)V"), index=10, remap=true)
    public int modifyViewW(int viewW) {
        return viewW * Globals.minimapScalingFactor;
    }

    @Inject(method={"renderChunksToFBO"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;pose()Lcom/mojang/blaze3d/vertex/PoseStack;")}, remap=true)
    public void modifyScaledSize(XaeroMinimapSession minimapSession, class_332 guiGraphics, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, double playerX, double playerZ, double playerDimDiv, double mapDimensionScale, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc, CallbackInfo ci, @Share(value="scaledSize") LocalIntRef scaledSize) {
        scaledSize.set(256 * Globals.minimapScalingFactor);
        Globals.minimapDrawContext = guiGraphics;
    }

    @Inject(method={"renderChunksToFBO"}, at={@At(value="RETURN")}, remap=false)
    public void removeDrawContextRef(XaeroMinimapSession minimapSession, class_332 guiGraphics, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, double playerX, double playerZ, double playerDimDiv, double mapDimensionScale, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc, CallbackInfo ci) {
        Globals.minimapDrawContext = null;
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", ordinal=0), remap=true)
    public void modifyShaderMatrixStackTranslate(class_4587 instance, float x, float y, float z, @Share(value="scaledSize") LocalIntRef scaledSize) {
        instance.method_46416((float)scaledSize.get(), (float)scaledSize.get(), -2000.0f);
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), remap=true)
    public void modifyMMBackgroundFill(class_332 guiGraphics, int x1, int y1, int x2, int y2, int color, @Share(value="scaledSize") LocalIntRef scaledSize) {
        if (!XaeroPlusSettingRegistry.transparentMinimapBackground.getValue()) {
            guiGraphics.method_25294(-scaledSize.get(), -scaledSize.get(), scaledSize.get(), scaledSize.get(), ColorHelper.getColor(0, 0, 0, 255));
        } else {
            guiGraphics.method_25294(-scaledSize.get(), -scaledSize.get(), scaledSize.get(), scaledSize.get(), ColorHelper.getColor(0, 0, 0, 0));
        }
    }

    @ModifyArg(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;lineWidth(F)V"), remap=false)
    public float modifyChunkGridLineWidth(float original) {
        return original * (float)Globals.minimapScalingFactor;
    }

    @Inject(method={"renderChunksToFBO"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V", ordinal=0)}, remap=true)
    public void drawRenderDistanceSquare(XaeroMinimapSession minimapSession, class_332 guiGraphics, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, double playerX, double playerZ, double playerDimDiv, double mapDimensionScale, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc, CallbackInfo ci, @Local(name={"xFloored"}) int xFloored, @Local(name={"zFloored"}) int zFloored, @Local(name={"renderTypeBuffers"}) class_4597.class_4598 renderTypeBuffers, @Local(name={"matrixStack"}) class_4587 matrixStack) {
        boolean isDimensionSwitched;
        boolean bl = isDimensionSwitched = Globals.getCurrentDimensionId() != class_310.method_1551().field_1687.method_27983();
        if (XaeroPlusSettingRegistry.showRenderDistanceSetting.getValue() && !isDimensionSwitched) {
            double actualPlayerX = minimap.getEntityRadar().getEntityX((class_1297)this.mc.field_1724, partial);
            double actualPlayerZ = minimap.getEntityRadar().getEntityZ((class_1297)this.mc.field_1724, partial);
            int actualXFloored = OptimizedMath.myFloor((double)actualPlayerX);
            int actualZFloored = OptimizedMath.myFloor((double)actualPlayerZ);
            int viewDistance = ((AccessorGameOptions)this.mc.field_1690).getServerRenderDistance();
            int width = viewDistance * 2 + 1;
            int middleChunkX = -(actualXFloored & 0xF);
            int middleChunkZ = -(actualZFloored & 0xF);
            int distanceFlooredX = actualXFloored - xFloored;
            int distanceFlooredZ = actualZFloored - zFloored;
            int x0 = distanceFlooredX + middleChunkX - width / 2 * 16;
            int z0 = distanceFlooredZ + middleChunkZ - width / 2 * 16;
            int x1 = x0 + width * 16;
            int z1 = z0 + width * 16;
            class_4588 lineBufferBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            MinimapShaders.FRAMEBUFFER_LINES.setFrameSize((float)this.scalingFramebuffer.field_1480, (float)this.scalingFramebuffer.field_1477);
            float lineWidth = (float)Math.max(1.0, (double)(this.modMain.getSettings().chunkGridLineWidth * Globals.minimapScalingFactor));
            RenderSystem.lineWidth((float)lineWidth);
            class_4587.class_4665 matrices = matrixStack.method_23760();
            this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, (float)x0, (float)z0, (float)x1, (float)z0, 1.0f, 1.0f, 0.0f, 0.8f);
            this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, (float)x1, (float)z0, (float)x1, (float)z1, 1.0f, 1.0f, 0.0f, 0.8f);
            this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, (float)x1, (float)z1, (float)x0, (float)z1, 1.0f, 1.0f, 0.0f, 0.8f);
            this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, (float)x0, (float)z0, (float)x0, (float)z1, 1.0f, 1.0f, 0.0f, 0.8f);
        }
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapRendererHelper;drawMyTexturedModalRect(Lcom/mojang/blaze3d/vertex/PoseStack;FFIIFFFF)V"), remap=true)
    public void redirectModelViewDraw(MinimapRendererHelper instance, class_4587 matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, @Share(value="scaledSize") LocalIntRef scaledSize) {
        float scaledSizeM = (float)Globals.minimapScalingFactor * 512.0f;
        this.helper.drawMyTexturedModalRect(matrixStack, (float)(-scaledSize.get()), (float)(-scaledSize.get()), 0, 0, scaledSizeM, scaledSizeM, scaledSizeM, scaledSizeM);
    }

    @Inject(method={"renderChunksToFBO"}, at={@At(value="INVOKE", target="Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;draw(Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRenderer;)V")})
    public void drawMinimapFeaturesCaveMode(XaeroMinimapSession minimapSession, class_332 guiGraphics, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, double playerX, double playerZ, double playerDimDiv, double mapDimensionScale, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc, CallbackInfo ci, @Local(name={"xFloored"}) int xFloored, @Local(name={"zFloored"}) int zFloored, @Local(name={"overlayBufferBuilder"}) class_4588 overlayBufferBuilder, @Local(name={"matrixStack"}) class_4587 matrixStack, @Local(name={"minX"}) LocalIntRef minXRef, @Local(name={"maxX"}) LocalIntRef maxXRef, @Local(name={"minZ"}) LocalIntRef minZRef, @Local(name={"maxZ"}) LocalIntRef maxZRef) {
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        Globals.drawManager.drawMinimapFeatures(minXRef.get(), maxXRef.get(), minZRef.get(), maxZRef.get(), chunkX, chunkZ, tileX, tileZ, insideX, insideZ, matrixStack, overlayBufferBuilder, this.helper);
    }
}

