/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2334;
import net.minecraft.class_2338;
import net.minecraft.class_2423;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.PacketReceivedEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;
import xaeroplus.module.Module;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class Portals
extends Module {
    private ChunkHighlightCache portalsCache = new ChunkHighlightLocalCache();
    private final class_310 mc = class_310.method_1551();
    private int portalsColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final String DATABASE_NAME = "XaeroPlusPortals";
    private final ExecutorService searchExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Portals-Search-%d").build());
    private static final ReferenceSet<class_2248> PORTAL_BLOCKS = new ReferenceOpenHashSet();

    public void setPortalsCache(Boolean disk) {
        try {
            Long2LongMap map = this.portalsCache.getHighlightsState();
            this.portalsCache.onDisable();
            this.portalsCache = disk != false ? new ChunkHighlightSavingCache(DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.portalsCache.onEnable();
                if (map != null) {
                    this.portalsCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error setting portals cache", (Throwable)e);
        }
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isPortalChunk, this::getPortalsColor));
        this.portalsCache.onEnable();
        this.searchAllLoadedChunks();
    }

    @Override
    public void onDisable() {
        this.portalsCache.onDisable();
        Globals.drawManager.unregister(this.getClass());
    }

    public boolean inUnknownDimension() {
        class_5321<class_1937> dim = ChunkUtils.getActualDimension();
        return dim != class_1937.field_25179 && dim != class_1937.field_25180 && dim != class_1937.field_25181;
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.findPortalInChunkAsync((class_2791)event.chunk());
    }

    @EventHandler
    public void onPacketReceived(PacketReceivedEvent event) {
        if (event.packet() instanceof class_2626) {
            class_2626 packet = (class_2626)event.packet();
            this.handleBlockChange(packet.method_11309(), packet.method_11308());
        } else if (event.packet() instanceof class_2637) {
            class_2637 packet = (class_2637)event.packet();
            packet.method_30621(this::handleBlockChange);
        }
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (XaeroPlusSettingRegistry.portalsSaveLoadToDisk.getValue() && this.inUnknownDimension() && this.portalsCache instanceof ChunkHighlightSavingCache) {
            XaeroPlusSettingRegistry.portalsSaveLoadToDisk.setValue(false);
            XaeroPlus.LOGGER.warn("Entered unknown dimension with saving cache on, disabling disk saving");
        }
        this.portalsCache.handleWorldChange();
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.portalsCache.handleTick();
    }

    private void findPortalInChunkAsync(class_2791 chunk) {
        this.findPortalInChunkAsync(chunk, 0);
    }

    private void findPortalInChunkAsync(class_2791 chunk, int waitMs) {
        if (this.inUnknownDimension()) {
            return;
        }
        if (chunk == null) {
            return;
        }
        this.searchExecutor.execute(() -> {
            try {
                Thread.sleep(waitMs);
                int iterations = 0;
                while (iterations++ < 3 && !this.findPortalInChunk(chunk)) {
                    Thread.sleep(500L);
                }
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Error searching for portal in chunk: {}, {}", new Object[]{chunk.method_12004().field_9181, chunk.method_12004().field_9180, e});
            }
        });
    }

    private boolean findPortalInChunk(class_2791 chunk) {
        boolean chunkHadPortal = this.portalsCache.isHighlighted(chunk.method_12004().field_9181, chunk.method_12004().field_9180, ChunkUtils.getActualDimension());
        boolean hasPortal = ChunkScanner.chunkContainsBlocks(chunk, PORTAL_BLOCKS, this.mc.field_1687.method_31607());
        if (hasPortal) {
            return this.portalsCache.addHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
        if (chunkHadPortal) {
            this.portalsCache.removeHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
        return true;
    }

    private boolean findPortalAtBlockPos(class_2338 pos) {
        if (this.mc.field_1687 == null || this.inUnknownDimension()) {
            return false;
        }
        int chunkX = ChunkUtils.posToChunkPos(pos.method_10263());
        int chunkZ = ChunkUtils.posToChunkPos(pos.method_10260());
        class_2818 worldChunk = this.mc.field_1687.method_2935().method_12126(chunkX, chunkZ, false);
        if (worldChunk == null || worldChunk instanceof class_2812) {
            return false;
        }
        class_2680 blockState = worldChunk.method_8320(pos);
        return blockState.method_26204() instanceof class_2423 || blockState.method_26204() instanceof class_2334;
    }

    private void searchAllLoadedChunks() {
        if (this.mc.field_1687 == null || this.inUnknownDimension()) {
            return;
        }
        int renderDist = (Integer)this.mc.field_1690.method_42503().method_41753();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                class_2818 chunk = this.mc.field_1687.method_2935().method_12126(x, z, false);
                if (chunk instanceof class_2812) continue;
                this.findPortalInChunkAsync((class_2791)chunk);
            }
        }
    }

    private void handleBlockChange(class_2338 pos, class_2680 state) {
        int chunkZ;
        if (this.inUnknownDimension()) {
            return;
        }
        int chunkX = ChunkUtils.posToChunkPos(pos.method_10263());
        if (this.portalsCache.isHighlighted(chunkX, chunkZ = ChunkUtils.posToChunkPos(pos.method_10260()), ChunkUtils.getActualDimension())) {
            if (this.findPortalAtBlockPos(pos)) {
                if (this.mc.field_1687 == null || this.mc.field_1687.method_2935() == null) {
                    return;
                }
                class_2818 worldChunk = this.mc.field_1687.method_2935().method_12126(chunkX, chunkZ, false);
                if (worldChunk != null && !(worldChunk instanceof class_2812)) {
                    this.findPortalInChunkAsync((class_2791)worldChunk, 250);
                }
            }
        } else if (state.method_26204() instanceof class_2423 || state.method_26204() instanceof class_2334) {
            this.portalsCache.addHighlight(chunkX, chunkZ);
        }
    }

    public int getPortalsColor() {
        return this.portalsColor;
    }

    public void setRgbColor(int color) {
        this.portalsColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.portalsAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.portalsColor = ColorHelper.getColorWithAlpha(this.portalsColor, (int)a);
    }

    public boolean isPortalChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.portalsCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    static {
        PORTAL_BLOCKS.add((Object)class_2246.field_10316);
        PORTAL_BLOCKS.add((Object)class_2246.field_10027);
        PORTAL_BLOCKS.add((Object)class_2246.field_10398);
    }
}

