/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.TranslatableSettingEnum;
import xaeroplus.settings.XaeroPlusBooleanSetting;
import xaeroplus.settings.XaeroPlusEnumSetting;
import xaeroplus.settings.XaeroPlusFloatSetting;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

public class XaeroPlusModSettingsHooks {
    private static int loadCount = 0;

    public static void saveSettings() throws IOException {
        XaeroPlusModSettingsHooks.saveXPSettings();
    }

    public static synchronized void saveXPSettings() throws IOException {
        File tempFile = new File(XaeroPlus.configFile.getAbsolutePath() + ".tmp");
        if (tempFile.exists()) {
            tempFile.delete();
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(tempFile, true));){
            XaeroPlusSettingsReflectionHax.ALL_SETTINGS.get().forEach(k -> writer.println(k.getSettingName() + ":" + (Serializable)(k instanceof XaeroPlusBooleanSetting ? Boolean.valueOf(((XaeroPlusBooleanSetting)k).getValue()) : (k instanceof XaeroPlusFloatSetting ? Float.valueOf(((XaeroPlusFloatSetting)k).getValue()) : (k instanceof XaeroPlusEnumSetting ? Integer.valueOf(((XaeroPlusEnumSetting)k).getValueIndex()) : "")))));
        }
        Files.move(tempFile.toPath(), XaeroPlus.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void loadSettings(File file, List<XaeroPlusSetting> settings) throws IOException {
        if (++loadCount == 1) {
            XaeroPlusModSettingsHooks.loadXPSettings();
        }
        XaeroPlusModSettingsHooks.loadXPSettingsFromFile(file, settings);
        if (loadCount == 2) {
            Globals.onAllSettingsLoaded();
        }
    }

    public static synchronized void loadXPSettings() {
        try {
            if (!XaeroPlus.configFile.exists()) {
                return;
            }
            XaeroPlusModSettingsHooks.loadXPSettingsFromFile(XaeroPlus.configFile, XaeroPlusSettingsReflectionHax.ALL_SETTINGS.get());
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Error loading XaeroPlus settings", e);
        }
    }

    public static synchronized void loadXPSettingsFromFile(File file, List<XaeroPlusSetting> settings) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String s;
            while ((s = reader.readLine()) != null) {
                int value;
                String[] args = s.split(":");
                Optional<XaeroPlusSetting> settingOptional = settings.stream().filter(setting -> setting.getSettingName().equalsIgnoreCase(args[0])).findFirst();
                if (!settingOptional.isPresent()) continue;
                XaeroPlusSetting setting2 = settingOptional.get();
                if (setting2 instanceof XaeroPlusBooleanSetting) {
                    XaeroPlusBooleanSetting set = (XaeroPlusBooleanSetting)setting2;
                    value = Boolean.parseBoolean(args[1]);
                    if (value != set.getValue()) {
                        set.setValue(value != 0);
                    }
                    set.setValue(Boolean.parseBoolean(args[1]));
                    continue;
                }
                if (setting2 instanceof XaeroPlusFloatSetting) {
                    XaeroPlusFloatSetting set = (XaeroPlusFloatSetting)setting2;
                    float value2 = Float.parseFloat(args[1]);
                    if (value2 == set.getValue()) continue;
                    set.setValue(value2);
                    continue;
                }
                if (!(setting2 instanceof XaeroPlusEnumSetting)) continue;
                XaeroPlusEnumSetting set = (XaeroPlusEnumSetting)setting2;
                value = (int)Float.parseFloat(args[1]);
                if (set.getValueIndex() == value) continue;
                set.setValueIndex(value);
            }
        }
    }

    public static void getClientBooleanValue(String enumString, List<XaeroPlusSetting> settings, CallbackInfoReturnable<Boolean> cir) {
        Optional<XaeroPlusBooleanSetting> settingOptional = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString) && xaeroPlusSetting instanceof XaeroPlusBooleanSetting).map(xaeroPlusSetting -> (XaeroPlusBooleanSetting)xaeroPlusSetting).findFirst();
        if (settingOptional.isPresent()) {
            cir.setReturnValue((Object)settingOptional.get().getValue());
            cir.cancel();
        }
    }

    public static void setOptionValue(String enumString, Object value, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> foundSetting = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusBooleanSetting && value instanceof Boolean).map(xaeroPlusSetting -> (XaeroPlusBooleanSetting)xaeroPlusSetting).ifPresent(xaeroPlusBooleanSetting -> xaeroPlusBooleanSetting.setValue((Boolean)value));
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusEnumSetting && value instanceof Integer && (Integer)value <= ((XaeroPlusEnumSetting)xaeroPlusSetting).getIndexMax() && (Integer)value >= 0).map(xaeroPlusSetting -> (XaeroPlusEnumSetting)xaeroPlusSetting).ifPresent(xaeroPlusEnumSetting -> xaeroPlusEnumSetting.setValueIndex((Integer)value));
    }

    public static void getOptionValue(String enumString, CallbackInfoReturnable<Object> cir, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> foundSetting = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusBooleanSetting).map(xaeroPlusSetting -> (XaeroPlusBooleanSetting)xaeroPlusSetting).ifPresent(xaeroPlusBooleanSetting -> cir.setReturnValue((Object)xaeroPlusBooleanSetting.getValue()));
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusEnumSetting).map(xaeroPlusSetting -> (XaeroPlusEnumSetting)xaeroPlusSetting).ifPresent(xaeroPlusEnumSetting -> cir.setReturnValue((Object)xaeroPlusEnumSetting.getValueIndex()));
    }

    public static void setOptionDoubleValue(String enumString, double f, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> foundSetting = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusFloatSetting).map(xaeroPlusSetting -> (XaeroPlusFloatSetting)xaeroPlusSetting).ifPresent(xaeroPlusSetting -> xaeroPlusSetting.setValue((float)f));
    }

    public static void getOptionDoubleValue(String enumString, CallbackInfoReturnable<Double> cir, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> settingOptional = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        settingOptional.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusFloatSetting).map(xaeroPlusSetting -> (XaeroPlusFloatSetting)xaeroPlusSetting).ifPresent(xaeroPlusSetting -> {
            cir.setReturnValue((Object)xaeroPlusSetting.getValue());
            cir.cancel();
        });
    }

    public static void getOptionValueName(String enumString, CallbackInfoReturnable<String> cir, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> settingOptional = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        settingOptional.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusEnumSetting).map(xaeroPlusSetting -> (XaeroPlusEnumSetting)xaeroPlusSetting).ifPresent(xaeroPlusEnumSetting -> cir.setReturnValue((Object)(xaeroPlusEnumSetting.getValue() instanceof TranslatableSettingEnum ? ((TranslatableSettingEnum)xaeroPlusEnumSetting.getValue()).getTranslatedName() : ((Enum)xaeroPlusEnumSetting.getValue()).toString())));
    }

    public static void getSliderOptionText(String enumString, CallbackInfoReturnable<String> cir, List<XaeroPlusSetting> settings) {
        settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst().ifPresent(xaeroPlusSetting -> {
            String s = xaeroPlusSetting.getTranslatedName() + ": ";
            if (xaeroPlusSetting instanceof XaeroPlusFloatSetting) {
                s = s + String.format("%.2f", Float.valueOf(((XaeroPlusFloatSetting)xaeroPlusSetting).getValue()));
            } else if (xaeroPlusSetting instanceof XaeroPlusEnumSetting) {
                XaeroPlusEnumSetting xaeroPlusEnumSetting = (XaeroPlusEnumSetting)xaeroPlusSetting;
                s = s + (xaeroPlusEnumSetting.getValue() instanceof TranslatableSettingEnum ? ((TranslatableSettingEnum)xaeroPlusEnumSetting.getValue()).getTranslatedName() : ((Enum)xaeroPlusEnumSetting.getValue()).toString());
            }
            cir.setReturnValue((Object)s);
        });
    }
}

