/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import com.google.common.net.InternetDomainName;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.file.MapSaveLoad;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSettingRegistry;

public class DataFolderResolveUtil {
    public static void resolveDataFolder(class_634 connection, CallbackInfoReturnable<String> cir) {
        XaeroPlusSettingRegistry.DataFolderResolutionMode dataFolderResolutionMode = Globals.dataFolderResolutionMode;
        if (dataFolderResolutionMode == XaeroPlusSettingRegistry.DataFolderResolutionMode.SERVER_NAME) {
            String serverName;
            if (Objects.nonNull(connection.method_45734()) && (serverName = connection.method_45734().field_3752).length() > 0) {
                cir.setReturnValue((Object)DataFolderResolveUtil.sanitizeDataFolderName("Multiplayer_" + serverName));
                cir.cancel();
                return;
            }
            if (!class_310.method_1551().method_1496()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid MC Server Name. Falling back to default Xaero data folder resolution");
            }
        } else if (dataFolderResolutionMode == XaeroPlusSettingRegistry.DataFolderResolutionMode.BASE_DOMAIN && Objects.nonNull(connection.method_45734())) {
            Object id;
            try {
                id = InternetDomainName.from((String)connection.method_45734().field_3761).topPrivateDomain().toString();
            }
            catch (IllegalArgumentException ex) {
                XaeroPlus.LOGGER.error("Error resolving BASE_DOMAIN data folder. Falling back to default Xaero resolution.", (Throwable)ex);
                return;
            }
            while (((String)id).endsWith(".")) {
                id = ((String)id).substring(0, ((String)id).length() - 1);
            }
            if (!((String)id).isEmpty()) {
                id = "Multiplayer_" + (String)id;
                cir.setReturnValue((Object)DataFolderResolveUtil.sanitizeDataFolderName((String)id));
                cir.cancel();
                return;
            }
            if (!class_310.method_1551().method_1496()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid Base domain. Falling back to default Xaero data folder resolution");
            }
        }
    }

    public static class_2561 getCurrentDataDirPath() {
        try {
            WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
            MapProcessor mapProcessor = currentSession.getMapProcessor();
            String mainId = mapProcessor.getMapWorld().getMainId();
            Path rootFolder = MapSaveLoad.getRootFolder((String)mainId);
            return class_2561.method_43470((String)rootFolder.toString());
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Failed to get data directory", e);
            return class_2561.method_43470((String)"Failed to get data directory");
        }
    }

    public static String sanitizeDataFolderName(String in) {
        String invalidChars = "[<>:\"/\\|?*]";
        return in.replaceAll("[<>:\"/\\|?*]", "_");
    }
}

