/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons;

import io.netty.buffer.ByteBuf;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.larsmans.infinitybuttons.advancement.InfinityButtonsTriggers;
import net.larsmans.infinitybuttons.block.InfinityButtonsBlocks;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButton;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButtonEnum;
import net.larsmans.infinitybuttons.config.InfinityButtonsConfig;
import net.larsmans.infinitybuttons.item.InfinityButtonsItemGroups;
import net.larsmans.infinitybuttons.item.InfinityButtonsItems;
import net.larsmans.infinitybuttons.item.SafeEmergencyButtonItem;
import net.larsmans.infinitybuttons.particle.InfinityButtonsParticleTypes;
import net.larsmans.infinitybuttons.sounds.InfinityButtonsSounds;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2357;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinityButtonsInit
implements ModInitializer {
    public static final String MOD_ID = "infinitybuttons";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"infinitybuttons");
    public static final InfinityButtonsConfig CONFIG = InfinityButtonsConfig.createAndLoad();
    public static final class_2960 LETTER_BUTTON_BLOCK_PACKET = new class_2960("infinitybuttons", "letter_button_block");
    public static final class_2960 LETTER_BUTTON_SCREEN_PACKET = new class_2960("infinitybuttons", "letter_button_screen");
    public static final class_2960 ALARM_PACKET = new class_2960("infinitybuttons", "alarm_packet");
    public static final class_2960 REQUEST_JADE_PACKET = new class_2960("infinitybuttons", "request_jade");
    public static final class_2960 JADE_PACKET = new class_2960("infinitybuttons", "jade_packet");

    public void onInitialize() {
        InfinityButtonsInit.registerPackets();
        InfinityButtonsItems.registerModItems();
        InfinityButtonsBlocks.registerModBlocks();
        InfinityButtonsSounds.registerSounds();
        InfinityButtonsItemGroups.loadItemGroup();
        InfinityButtonsTriggers.register();
        InfinityButtonsParticleTypes.register();
        InfinityButtonsInit.registerDispenserBehavior();
    }

    public static void registerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LETTER_BUTTON_BLOCK_PACKET, (server, player, handler, buf, sender) -> {
            class_2338 pos = buf.method_10811();
            LetterButtonEnum letterButtonEnum = (LetterButtonEnum)buf.method_10818(LetterButtonEnum.class);
            class_1937 world = player.method_37908();
            if (world.method_8320(pos).method_26204() instanceof LetterButton) {
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657(LetterButton.CHARACTER, (Comparable)((Object)letterButtonEnum)));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_JADE_PACKET, (server, player, handler, buf, sender) -> ServerPlayNetworking.send((class_3222)player, (class_2960)JADE_PACKET, (class_2540)PacketByteBufs.copy((ByteBuf)PacketByteBufs.create().writeBoolean(CONFIG.forceJadeHiding()))));
    }

    public static void registerDispenserBehavior() {
        for (class_1792 item : class_7923.field_41178.method_10220().toList()) {
            if (!(item instanceof SafeEmergencyButtonItem)) continue;
            class_2315.method_10009((class_1935)item, (class_2357)new class_2969(){

                protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                    this.method_27955(class_1738.method_7684((class_2342)pointer, (class_1799)stack));
                    return stack;
                }
            });
        }
    }
}

