/*
 * Decompiled with CFR 0.152.
 */
package net.kuro.prettyinpink.structure.block.custom;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.VoxelShaper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Predicate;
import net.kuro.prettyinpink.structure.block.ModVoxelShapes;
import net.kuro.prettyinpink.structure.block.custom.DirectionalBlock;
import net.kuro.prettyinpink.structure.block.custom.HullBlock;
import net.kuro.prettyinpink.structure.properties.ModProperties;
import net.kuro.prettyinpink.structure.properties.custom.HullType;
import net.kuro.prettyinpink.util.HasCustomOutline;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class AxisHullBlock
extends class_2465
implements HasCustomOutline,
IWrenchable {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final class_2754<HullType> TYPE = ModProperties.HULL_TYPE;

    public AxisHullBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11459, (Comparable)class_2350.class_2351.field_11052)).method_11657(TYPE, (Comparable)((Object)HullType.VERTICAL)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11459, TYPE});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos = ctx.method_8037();
        class_2350.class_2351 axis = ctx.method_8038().method_10166();
        class_1937 world = ctx.method_8045();
        if (axis == class_2350.class_2351.field_11052) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11459, (Comparable)axis)).method_11657(TYPE, (Comparable)((Object)HullType.VERTICAL));
        }
        if (ctx.method_17698().field_1351 - (double)blockPos.method_10264() < 0.25 && world.method_8320(blockPos.method_10074()).method_26215()) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11459, (Comparable)axis)).method_11657(TYPE, (Comparable)((Object)HullType.TOP));
        }
        if (ctx.method_17698().field_1351 - (double)blockPos.method_10264() > 0.75 && world.method_8320(blockPos.method_10084()).method_26215()) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11459, (Comparable)axis)).method_11657(TYPE, (Comparable)((Object)HullType.BOTTOM));
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11459, (Comparable)axis)).method_11657(TYPE, (Comparable)((Object)HullType.CENTERED));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2680 blockState = super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        HullType hullType = (HullType)((Object)state.method_11654(TYPE));
        if (blockState.method_26215()) {
            return blockState;
        }
        if (!(hullType != HullType.BOTTOM || direction != class_2350.field_11036 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(TYPE) == HullType.TOP)) {
            return class_2246.field_10124.method_9564();
        }
        if (!(hullType != HullType.TOP || direction != class_2350.field_11033 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(TYPE) == HullType.BOTTOM)) {
            return class_2246.field_10124.method_9564();
        }
        return blockState;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        HullType hullType = (HullType)((Object)state.method_11654(TYPE));
        if (hullType == HullType.BOTTOM || hullType == HullType.TOP) {
            if (hullType == HullType.BOTTOM) {
                class_2338 blockPos = pos.method_10084();
                world.method_8652(blockPos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)HullType.TOP)), 3);
            } else {
                class_2338 blockPos = pos.method_10074();
                world.method_8652(blockPos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)HullType.BOTTOM)), 3);
            }
        }
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && player.method_7337()) {
            AxisHullBlock.onBreakInCreative(world, pos, state, player);
        }
        super.method_9576(world, pos, state, player);
    }

    protected static void onBreakInCreative(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        HullType hullType = (HullType)((Object)state.method_11654(TYPE));
        if (hullType == HullType.TOP && (blockState = world.method_8320(blockPos = pos.method_10074())).method_27852(state.method_26204()) && blockState.method_11654(TYPE) == HullType.BOTTOM) {
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    public boolean method_9522(@NotNull class_2680 state, class_2680 adjacentBlockState, @NotNull class_2350 direction) {
        return adjacentBlockState.method_27852((class_2248)this) && adjacentBlockState.method_11654((class_2769)field_11459) == state.method_11654((class_2769)field_11459) && adjacentBlockState.method_11654(TYPE) == state.method_11654(TYPE);
    }

    @NotNull
    public class_265 method_9571(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos) {
        return class_259.method_1073();
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.getShapeForState(state);
    }

    @NotNull
    public class_265 method_9549(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.getShapeForState(state);
    }

    @NotNull
    public class_265 method_9584(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos) {
        return this.getShapeForState(state);
    }

    @NotNull
    public class_265 getShapeForState(class_2680 state) {
        if (state.method_11654(TYPE) == HullType.BOTTOM) {
            return ModVoxelShapes.HULL_RAISED.get((class_2350.class_2351)state.method_11654((class_2769)field_11459));
        }
        if (state.method_11654(TYPE) == HullType.TOP) {
            return ModVoxelShapes.HULL_LOWERED.get((class_2350.class_2351)state.method_11654((class_2769)field_11459));
        }
        return ModVoxelShapes.HULL.get((class_2350.class_2351)state.method_11654((class_2769)field_11459));
    }

    @Override
    public void customOutline(class_4587 matrixStack, class_4588 consumer, class_2680 state) {
        double offset = state.method_11654(TYPE) == HullType.BOTTOM ? 8.0 : (state.method_11654(TYPE) == HullType.TOP ? -8.0 : 0.0);
        this.drawLineWithAxisOffset(consumer, matrixStack, 1.37258, -8.0, 0.0, -8.0, 1.37258, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, -8.0, 1.37258, 0.0, -8.0, 14.6274, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, -8.0, 14.6274, 0.0, 1.37258, 24.0, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 1.37258, 24.0, 0.0, 14.6274, 24.0, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 14.6274, 24.0, 0.0, 24.0, 14.6274, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 24.0, 14.6274, 0.0, 24.0, 1.37258, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 24.0, 1.37258, 0.0, 14.6274, -8.0, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 14.6274, -8.0, 0.0, 1.37258, -8.0, 0.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 1.37258, -8.0, 16.0, -8.0, 1.37258, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, -8.0, 1.37258, 16.0, -8.0, 14.6274, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, -8.0, 14.6274, 16.0, 1.37258, 24.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 1.37258, 24.0, 16.0, 14.6274, 24.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 14.6274, 24.0, 16.0, 24.0, 14.6274, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 24.0, 14.6274, 16.0, 24.0, 1.37258, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 24.0, 1.37258, 16.0, 14.6274, -8.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 14.6274, -8.0, 16.0, 1.37258, -8.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 1.37258, -8.0, 0.0, 1.37258, -8.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, -8.0, 1.37258, 0.0, -8.0, 1.37258, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, -8.0, 14.6274, 0.0, -8.0, 14.6274, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 1.37258, 24.0, 0.0, 1.37258, 24.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 14.6274, 24.0, 0.0, 14.6274, 24.0, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 24.0, 14.6274, 0.0, 24.0, 14.6274, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 24.0, 1.37258, 0.0, 24.0, 1.37258, 16.0, offset, class_2350.class_2351.field_11052);
        this.drawLineWithAxisOffset(consumer, matrixStack, 14.6274, -8.0, 0.0, 14.6274, -8.0, 16.0, offset, class_2350.class_2351.field_11052);
    }

    public static void rotateY(class_4587 matrixStack, float angleDegrees) {
        Quaternionf quaternionYaw = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternionYaw.setAngleAxis((double)angleDegrees * Math.PI / 180.0, 0.0, 1.0, 0.0);
        matrixStack.method_22907(quaternionYaw);
    }

    public static void rotateX(class_4587 matrixStack, float angleDegrees) {
        Quaternionf quaternionPitch = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternionPitch.setAngleAxis((double)angleDegrees * Math.PI / 180.0, 1.0, 0.0, 0.0);
        matrixStack.method_22907(quaternionPitch);
    }

    @Override
    public void matrixRotation(class_4587 matrixStack, class_2680 state) {
        if (state.method_11654((class_2769)field_11459) == class_2350.class_2351.field_11048) {
            AxisHullBlock.rotateY(matrixStack, 90.0f);
        } else if (state.method_11654((class_2769)field_11459) == class_2350.class_2351.field_11052) {
            AxisHullBlock.rotateX(matrixStack, 90.0f);
        }
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (player.method_5715() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(hand);
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, hit).placeInWorld(world, (class_1747)heldItem.method_7909(), player, hand, hit);
        }
        return class_1269.field_5811;
    }

    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        class_2680 newState = originalState;
        if (originalState.method_11654(TYPE) != HullType.BOTTOM && originalState.method_11654(TYPE) != HullType.TOP) {
            newState = (class_2680)originalState.method_11657((class_2769)field_11459, (Comparable)VoxelShaper.axisAsFace((class_2350.class_2351)((class_2350.class_2351)originalState.method_11654((class_2769)RotatedPillarKineticBlock.AXIS))).method_35833(targetedFace.method_10166()).method_10166());
            newState = newState.method_11654((class_2769)field_11459) == class_2350.class_2351.field_11052 ? (class_2680)newState.method_11657(TYPE, (Comparable)((Object)HullType.VERTICAL)) : (class_2680)newState.method_11657(TYPE, (Comparable)((Object)HullType.CENTERED));
        }
        return newState;
    }

    @class_6328
    private static class PlacementHelper
    extends PoleHelper<class_2350.class_2351> {
        private PlacementHelper() {
            super(state -> state.method_26204() instanceof HullBlock || state.method_26204() instanceof AxisHullBlock, state -> state.method_26204() instanceof HullBlock ? ((class_2350)state.method_11654((class_2769)DirectionalBlock.FACING)).method_10166() : (class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459), (class_2769)class_2465.field_11459);
        }

        public Predicate<class_1799> getItemPredicate() {
            return i -> i.method_7909() instanceof class_1747 && (((class_1747)i.method_7909()).method_7711() instanceof AxisHullBlock || ((class_1747)i.method_7909()).method_7711() instanceof HullBlock);
        }

        public Predicate<class_2680> getStatePredicate() {
            return state -> state.method_26204() instanceof AxisHullBlock || state.method_26204() instanceof HullBlock;
        }

        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            PlacementOffset offset = PlacementOffset.fail();
            List directions = IPlacementHelper.orderedByDistance((class_2338)pos, (class_243)ray.method_17784(), dir -> dir.method_10166() == this.axisFunction.apply(state));
            for (class_2350 dir2 : directions) {
                class_2350 finalDir;
                class_2680 tempState;
                class_2338 tempPos;
                int poles;
                class_1324 reach;
                dir2 = dir2.method_10153();
                int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
                if (player != null && (reach = player.method_5996(ReachEntityAttributes.REACH)) != null && reach.method_6196(ExtendoGripItem.singleRangeAttributeModifier)) {
                    range += 4;
                }
                if ((poles = this.attachedPoles(world, pos, dir2)) >= range) continue;
                class_2338 newPos = pos.method_10079(dir2, poles + 1);
                class_2680 newState = world.method_8320(newPos);
                if (state.method_11654(TYPE) == HullType.BOTTOM) {
                    tempPos = newPos.method_30513(class_2350.class_2351.field_11052, 1);
                    tempState = world.method_8320(tempPos);
                    if (!newState.method_45474() || !tempState.method_45474()) continue;
                    finalDir = dir2;
                    offset = PlacementOffset.success((class_2382)newPos, bState -> bState.method_26204() instanceof AxisHullBlock ? (class_2680)bState.method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))) : (class_2680)bState.method_11657((class_2769)DirectionalBlock.FACING, (Comparable)finalDir));
                    continue;
                }
                if (state.method_11654(TYPE) == HullType.TOP) {
                    tempPos = newPos.method_30513(class_2350.class_2351.field_11052, -1);
                    tempState = world.method_8320(tempPos);
                    if (!newState.method_45474() || !tempState.method_45474()) continue;
                    finalDir = dir2;
                    offset = PlacementOffset.success((class_2382)newPos, bState -> bState.method_26204() instanceof AxisHullBlock ? (class_2680)bState.method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))) : (class_2680)bState.method_11657((class_2769)DirectionalBlock.FACING, (Comparable)finalDir));
                    continue;
                }
                if (!newState.method_45474()) continue;
                class_2350 finalDir2 = dir2;
                offset = PlacementOffset.success((class_2382)newPos, bState -> bState.method_26204() instanceof AxisHullBlock ? (class_2680)bState.method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))) : (class_2680)bState.method_11657((class_2769)DirectionalBlock.FACING, (Comparable)finalDir2));
            }
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> (class_2680)s.method_11657(TYPE, (Comparable)((Object)((HullType)((Object)((Object)state.method_11654(TYPE))))))));
            }
            return offset;
        }

        public void renderAt(class_2338 pos, class_2680 state, class_3965 ray, PlacementOffset offset) {
            this.displayAdjustedGhost(offset, state);
        }

        public void displayAdjustedGhost(PlacementOffset offset, class_2680 state) {
            if (!offset.hasGhostState()) {
                return;
            }
            if (state.method_11654(TYPE) == HullType.TOP) {
                CreateClient.GHOST_BLOCKS.showGhostState((Object)this, (class_2680)((class_2680)offset.getTransform().apply(offset.getGhostState())).method_11657(TYPE, (Comparable)((Object)HullType.BOTTOM))).at(offset.getBlockPos().method_30513(class_2350.class_2351.field_11052, -1)).breathingAlpha();
            } else {
                CreateClient.GHOST_BLOCKS.showGhostState((Object)this, (class_2680)offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
            }
        }
    }
}

