/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.computercraft.peripherals;

import cc.tweaked_programs.cccbridge.common.computercraft.TweakedPeripheral;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.TargetBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;

public class TargetBlockPeripheral
extends TweakedPeripheral<TargetBlockEntity> {
    private final Terminal term = new Terminal(32, 24, false);

    public static double getVersion() {
        return 1.1;
    }

    public TargetBlockPeripheral(TargetBlockEntity blockentity) {
        super("create_target", blockentity);
    }

    public void replaceLine(int y, String line) {
        if (y < 0 || y >= this.term.getHeight()) {
            return;
        }
        this.term.setCursorPos(0, y);
        this.term.clearLine();
        this.term.write(line);
    }

    public int getWidth() {
        return this.term.getWidth();
    }

    public int getHeight() {
        return this.term.getHeight();
    }

    @LuaFunction
    public final void setWidth(int width) throws LuaException {
        if (width < 1 || width > 164) {
            throw new LuaException("Expected number in range 1-164");
        }
        this.term.resize(width, 16);
    }

    @LuaFunction
    public final void clear() {
        this.term.clear();
    }

    @LuaFunction
    public final void clearLine(int y) {
        if (y < 1 || y > this.term.getHeight()) {
            return;
        }
        this.term.setCursorPos(0, y - 1);
        this.term.clearLine();
    }

    @LuaFunction
    public final String getLine(int y) throws LuaException {
        if (y < 1 || y > this.term.getHeight()) {
            throw new LuaException("Expected number in range 1-" + this.term.getHeight());
        }
        TextBuffer line = this.term.getLine(y - 1);
        return line.toString();
    }

    @LuaFunction
    public final Object[] getSize() {
        return new Object[]{this.term.getWidth(), this.term.getHeight()};
    }
}

