/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads;

import com.google.common.base.Strings;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.ITabFiller;
import shetiphian.terraheads.EnumHeadType;
import shetiphian.terraheads.client.RenderItemMobHead;

public class ItemMobHead
extends class_1809
implements ITabFiller {
    private final EnumHeadType type;

    public ItemMobHead(EnumHeadType type, class_2248 floorBlock, class_2248 wallBlock, class_1792.class_1793 settings) {
        super(floorBlock, wallBlock, settings);
        this.type = type;
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::registerItemRenderer);
    }

    @Environment(value=EnvType.CLIENT)
    private void registerItemRenderer() {
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)this, (BuiltinItemRendererRegistry.DynamicItemRenderer)RenderItemMobHead.INSTANCE);
    }

    public EnumHeadType getType() {
        return this.type;
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        switch (this.type) {
            case VILLAGER: 
            case ZOMBIE_VILLAGER: {
                Set villages = class_7923.field_41194.method_10235();
                Set professions = class_7923.field_41195.method_10235();
                for (class_2960 village : villages) {
                    for (class_2960 entry : professions) {
                        entries.method_45420(ItemMobHead.create(new class_1799((class_1935)this), village.toString(), entry.toString()));
                    }
                }
                break;
            }
            case ILLAGER: {
                entries.method_45420(ItemMobHead.create(new class_1799((class_1935)this), "evoker"));
                entries.method_45420(ItemMobHead.create(new class_1799((class_1935)this), "illusioner"));
                entries.method_45420(ItemMobHead.create(new class_1799((class_1935)this), "pillager"));
                entries.method_45420(ItemMobHead.create(new class_1799((class_1935)this), "vindicator"));
                break;
            }
            default: {
                entries.method_45420(new class_1799((class_1935)this));
            }
        }
    }

    public static class_1799 create(class_1799 stack, String ... data) {
        if (!stack.method_7960() && data.length > 0) {
            class_2487 nbt = stack.method_7911("BlockEntityTag");
            int index = 0;
            for (String entry : data) {
                ++index;
                if (Strings.isNullOrEmpty((String)entry)) continue;
                nbt.method_10582("data" + index, entry);
            }
        }
        return stack;
    }

    public static String getData1(class_1799 stack) {
        class_2487 nbt = stack.method_7911("BlockEntityTag");
        return nbt.method_10545("data1") ? nbt.method_10558("data1") : "";
    }

    public static String getData2(class_1799 stack) {
        class_2487 nbt = stack.method_7911("BlockEntityTag");
        return nbt.method_10545("data2") ? nbt.method_10558("data2") : "";
    }

    public class_2561 method_7864(class_1799 stack) {
        String data1 = ItemMobHead.getData1(stack);
        String data2 = ItemMobHead.getData2(stack);
        Object name = null;
        switch (this.type) {
            case VILLAGER: 
            case ZOMBIE_VILLAGER: {
                name = this.type == EnumHeadType.ZOMBIE_VILLAGER ? class_2561.method_43471((String)"entity.minecraft.zombie").getString() + " " : "";
                if (!Strings.isNullOrEmpty((String)data1)) {
                    String villageKey = !data1.contains(":") ? "biome.minecraft." + data1 : "biome." + data1.replace(":", ".");
                    name = (String)name + class_2561.method_43471((String)villageKey).getString() + " ";
                }
                if (!Strings.isNullOrEmpty((String)data2)) {
                    data2 = data2.startsWith("minecraft:") ? data2.substring(10) : data2.replace(":", ".");
                    name = (String)name + class_2561.method_43471((String)("entity.minecraft.villager." + data2)).getString();
                    break;
                }
                name = (String)name + class_2561.method_43471((String)"entity.minecraft.villager").getString();
                break;
            }
            case ILLAGER: {
                if (Strings.isNullOrEmpty((String)data1)) break;
                name = class_2561.method_43471((String)("entity.minecraft." + data1)).getString();
                break;
            }
            default: {
                String key = "entity.minecraft." + this.type;
                name = class_2561.method_43471((String)key).getString();
                if (!((String)name).equals(key)) break;
                name = null;
            }
        }
        if (name != null) {
            return class_2561.method_43469((String)"block.minecraft.player_head.named", (Object[])new Object[]{name});
        }
        return super.method_7864(stack);
    }
}

