/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.mojang.logging.LogUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import shetiphian.core.common.events.DamageSourcesCallback;
import shetiphian.core.common.events.ModifyLootCallback;
import shetiphian.core.common.events.VillagerTradesCallback;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Setup;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.EventHandler;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.worldgen.StructureHandler;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.modintegration.ModIntegration;

public class Terraqueous
implements ModInitializer {
    public static final String MOD_ID = "terraqueous";
    public static Terraqueous INSTANCE;
    public static Logger LOGGER;
    public static Configuration CONFIG;

    public Terraqueous() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
    }

    public void onInitialize() {
        Roster.process();
        AutoConfig.register(Configuration.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        CONFIG = (Configuration)AutoConfig.getConfigHolder(Configuration.class).getConfig();
        ServerLifecycleEvents.SERVER_STARTING.register(Terraqueous::serverStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(Terraqueous::serverStopped);
        CommandRegistrationCallback.EVENT.register(EventHandler::registerCommands);
        CommonLifecycleEvents.TAGS_LOADED.register(EventHandler::onTagsLoaded);
        VillagerTradesCallback.PROFESSION_TRADES.register(EventHandler::villagerTrades);
        VillagerTradesCallback.WANDERER_TRADES.register(EventHandler::wandererTrades);
        ServerEntityEvents.ENTITY_LOAD.register(EventHandler::onEntitySpawn);
        PlayerBlockBreakEvents.BEFORE.register(EventHandler::beforeBlockBreakEvent);
        PlayerBlockBreakEvents.AFTER.register(EventHandler::onBlockBreakEvent);
        ServerEntityEvents.EQUIPMENT_CHANGE.register(EventHandler::onEquipmentChange);
        UseItemCallback.EVENT.register(EventHandler::playerUseItem);
        UseBlockCallback.EVENT.register(EventHandler::playerRightClickBlock);
        UseEntityCallback.EVENT.register(EventHandler::playerRightClickEntity);
        LootTableEvents.MODIFY.register(EventHandler::onLootTablesLoad);
        ModifyLootCallback.EVENT.register(EventHandler::onLootGenerated);
        DamageSourcesCallback.EVENT.register(Roster.DamageSources::init);
        NetworkHandler.initialise();
        WorldGenerator.initialize();
        Setup.setFireInfo();
        Setup.setCompostInfo();
        Setup.setFuelInfo();
        new ModIntegration().load();
    }

    private static void serverStarting(MinecraftServer server) {
        StructureHandler.init(server);
    }

    private static void serverStopped(MinecraftServer server) {
        Values.canProcessTags = false;
    }

    static {
        CONFIG = new Configuration();
    }
}

