/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.IStormForgeRepairHandler;
import shetiphian.terraqueous.api.machines.IStormForgeSortableHandler;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;

public class StormForgeRegistry {
    private static final Comparator<IStormForgeSortableHandler> COMPARATOR = new HandlerComparator();
    private static final Set<IStormForgeRechargeHandler> RECHARGE_HANDLERS = new TreeSet<IStormForgeSortableHandler>(COMPARATOR);
    private static final Set<IStormForgeRepairHandler> REPAIR_HANDLERS = new TreeSet<IStormForgeSortableHandler>(COMPARATOR);
    private static final Set<IStormForgeStackHandler> STACK_HANDLERS = new HashSet<IStormForgeStackHandler>();

    public static void register(IStormForgeRechargeHandler handler) {
        RECHARGE_HANDLERS.add(handler);
    }

    public static void register(IStormForgeRepairHandler handler) {
        REPAIR_HANDLERS.add(handler);
    }

    public static void register(IStormForgeStackHandler handler) {
        STACK_HANDLERS.add(handler);
    }

    public static Set<IStormForgeRechargeHandler> getRechargeHandlers() {
        return Collections.unmodifiableSet(RECHARGE_HANDLERS);
    }

    public static Set<IStormForgeRepairHandler> getRepairHandlers() {
        return Collections.unmodifiableSet(REPAIR_HANDLERS);
    }

    public static Set<IStormForgeStackHandler> getStackHandlers() {
        return Collections.unmodifiableSet(STACK_HANDLERS);
    }

    private static class HandlerComparator
    implements Comparator<IStormForgeSortableHandler> {
        private HandlerComparator() {
        }

        @Override
        public int compare(IStormForgeSortableHandler handler1, IStormForgeSortableHandler handler2) {
            int priority2;
            if (handler1 == null || handler2 == null || handler1.equals(handler2)) {
                return 0;
            }
            int priority1 = handler1.priority();
            return priority1 < (priority2 = handler2.priority()) ? 1 : (priority1 > priority2 ? -1 : handler1.getID().compareTo(handler2.getID()));
        }
    }
}

