/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.ColorHelper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.network.PacketColorizer;

@Environment(value=EnvType.CLIENT)
public class GuiColorizer
extends class_437 {
    private final String TEXT_PRESET_SAVE = class_1074.method_4662((String)"info.terraqueous.colorizer.preset.save", (Object[])new Object[0]);
    private final String TEXT_PRESET_LOAD = class_1074.method_4662((String)"info.terraqueous.colorizer.preset.load", (Object[])new Object[0]);
    private static final Map<class_1767, class_1799> WOOL_STACKS = GuiColorizer.buildMap();
    private final class_1799 colorizer;
    private class_342 textField;
    private final int xSize = 138;
    private final int ySize = 116;
    private Mode mode = Mode.HSL;
    private final float[] slider = new float[]{0.5f, 1.0f, 0.5f};
    private final float[] lastSlider = new float[]{-1.0f, -1.0f, -1.0f};
    private int sColor = -1;
    private int lvColor = -1;
    private int resultColor = -1;
    private short resultIndex = (short)4096;
    private class_1767 resultDye = class_1767.field_7952;
    private final short[] presetIndex = new short[18];
    private final String[] presetName = new String[18];
    private byte savePreset = (byte)-1;
    private final class_2960 guiTexture = Textures.COLORIZER.get();

    private static Map<class_1767, class_1799> buildMap() {
        HashMap<class_1767, class_1799> map = new HashMap<class_1767, class_1799>();
        map.put(class_1767.field_7952, new class_1799((class_1935)class_2246.field_10446));
        map.put(class_1767.field_7946, new class_1799((class_1935)class_2246.field_10095));
        map.put(class_1767.field_7958, new class_1799((class_1935)class_2246.field_10215));
        map.put(class_1767.field_7951, new class_1799((class_1935)class_2246.field_10294));
        map.put(class_1767.field_7947, new class_1799((class_1935)class_2246.field_10490));
        map.put(class_1767.field_7961, new class_1799((class_1935)class_2246.field_10028));
        map.put(class_1767.field_7954, new class_1799((class_1935)class_2246.field_10459));
        map.put(class_1767.field_7944, new class_1799((class_1935)class_2246.field_10423));
        map.put(class_1767.field_7967, new class_1799((class_1935)class_2246.field_10222));
        map.put(class_1767.field_7955, new class_1799((class_1935)class_2246.field_10619));
        map.put(class_1767.field_7945, new class_1799((class_1935)class_2246.field_10259));
        map.put(class_1767.field_7966, new class_1799((class_1935)class_2246.field_10514));
        map.put(class_1767.field_7957, new class_1799((class_1935)class_2246.field_10113));
        map.put(class_1767.field_7942, new class_1799((class_1935)class_2246.field_10170));
        map.put(class_1767.field_7964, new class_1799((class_1935)class_2246.field_10314));
        map.put(class_1767.field_7963, new class_1799((class_1935)class_2246.field_10146));
        return map;
    }

    public GuiColorizer(class_1799 stack) {
        super((class_2561)class_2561.method_43473());
        this.colorizer = stack;
        if (!stack.method_7960() && stack.method_7909() instanceof ItemColorizer) {
            this.resultIndex = ((ItemColorizer)stack.method_7909()).getRGB16(stack);
            this.resultColor = RGB16Helper.getColor((short)this.resultIndex);
            this.setSliders(ColorHelper.colorToHSL((int)this.resultColor));
        }
    }

    public void method_25426() {
        super.method_25426();
        int winX = (this.field_22789 - this.xSize) / 2;
        int winY = (this.field_22790 - this.ySize) / 2;
        if (!this.colorizer.method_7960() && this.colorizer.method_7909() instanceof ItemColorizer) {
            class_1767[] tagList = ((ItemColorizer)this.colorizer.method_7909()).getNBTTagList(this.colorizer);
            for (int preset = 0; preset < 18; preset = (int)((byte)(preset + 1))) {
                class_2487 tagPresets = tagList.method_10602(preset);
                this.presetIndex[preset] = tagPresets.method_10568("rgb16");
                this.presetName[preset] = tagPresets.method_10558("name");
            }
        }
        this.method_37067();
        this.method_37063((class_364)new ButtonMode(this, winX + 17, winY + 12, Mode.RGB));
        this.method_37063((class_364)new ButtonMode(this, winX + 53, winY + 12, Mode.HSL));
        this.method_37063((class_364)new ButtonMode(this, winX + 89, winY + 12, Mode.HSV));
        this.method_37063((class_364)new ButtonSlider(this, winX + 12, winY + 31, 10, 10, ButtonSlider.Segment.RED, ButtonSlider.Operation.SUBTRACT));
        this.method_37063((class_364)new ButtonSlider(this, winX + 26, winY + 33, 50, 6, ButtonSlider.Segment.RED, ButtonSlider.Operation.SELECT));
        this.method_37063((class_364)new ButtonSlider(this, winX + 80, winY + 31, 10, 10, ButtonSlider.Segment.RED, ButtonSlider.Operation.ADD));
        this.method_37063((class_364)new ButtonSlider(this, winX + 12, winY + 45, 10, 10, ButtonSlider.Segment.GREEN, ButtonSlider.Operation.SUBTRACT));
        this.method_37063((class_364)new ButtonSlider(this, winX + 26, winY + 47, 50, 6, ButtonSlider.Segment.GREEN, ButtonSlider.Operation.SELECT));
        this.method_37063((class_364)new ButtonSlider(this, winX + 80, winY + 45, 10, 10, ButtonSlider.Segment.GREEN, ButtonSlider.Operation.ADD));
        this.method_37063((class_364)new ButtonSlider(this, winX + 12, winY + 59, 10, 10, ButtonSlider.Segment.BLUE, ButtonSlider.Operation.SUBTRACT));
        this.method_37063((class_364)new ButtonSlider(this, winX + 26, winY + 61, 50, 6, ButtonSlider.Segment.BLUE, ButtonSlider.Operation.SELECT));
        this.method_37063((class_364)new ButtonSlider(this, winX + 80, winY + 59, 10, 10, ButtonSlider.Segment.BLUE, ButtonSlider.Operation.ADD));
        for (class_1767 color : class_1767.values()) {
            this.method_37063((class_364)new ButtonColor(this, winX + 14 + color.method_7789() * 7, winY + 74, color));
        }
        for (int row = 0; row < 2; row = (int)((byte)(row + 1))) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                int index = row * 9 + col;
                this.method_37063((class_364)new ButtonPreset(this, winX + 17 + col * 12, winY + 84 + row * 12, index));
            }
        }
        if (this.savePreset > -1) {
            for (class_4068 widget : this.field_33816) {
                if (!(widget instanceof class_339)) continue;
                ((class_339)widget).field_22763 = false;
            }
            this.method_37063((class_364)new ButtonPresetMenu(this, winX + 78, winY + 59, 1));
            this.method_37063((class_364)new ButtonPresetMenu(this, winX + 93, winY + 59, 2));
            this.method_37063((class_364)new ButtonPresetMenu(this, winX + 35, winY + 59, 3));
            if (this.savePreset < 32) {
                this.textField = new class_342(this.field_22793, winX + 35, winY + 40, 68, 10, (class_2561)class_2561.method_43473());
                this.textField.method_1862(true);
                this.textField.method_1880(32);
                this.textField.method_25365(true);
                this.textField.method_1852("");
            }
        }
    }

    public void method_25393() {
        if (this.textField != null) {
            this.textField.method_1865();
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        this.drawGuiContainerBackgroundLayer(graphics);
        class_308.method_24210();
        RenderSystem.disableDepthTest();
        for (class_4068 button : this.field_33816) {
            button.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        this.drawGuiContainerForegroundLayer(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        class_308.method_24211();
    }

    private void drawGuiContainerBackgroundLayer(class_332 graphics) {
        int winX = (this.field_22789 - this.xSize) / 2;
        int winY = (this.field_22790 - this.ySize) / 2;
        GuiHelper.drawTexture((class_332)graphics, (double)winX, (double)winY, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (class_2960)this.guiTexture);
        if (this.slider[0] != this.lastSlider[0] || this.slider[1] != this.lastSlider[1] || this.slider[2] != this.lastSlider[2]) {
            this.setupColors();
        }
        switch (this.mode) {
            case RGB: {
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 33), (double)(winX + 76), (double)(winY + 39), (int)-65536, (int)-16777216, (int)-16777216, (int)-65536);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 47), (double)(winX + 76), (double)(winY + 53), (int)-16711936, (int)-16777216, (int)-16777216, (int)-16711936);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 61), (double)(winX + 76), (double)(winY + 67), (int)-16776961, (int)-16777216, (int)-16777216, (int)-16776961);
                break;
            }
            case HSL: {
                GuiHelper.drawTextureScaled((class_332)graphics, (double)(winX + 26), (double)(winY + 33), (int)0, (int)250, (int)50, (int)6, (double)1.0, (int)77, (int)256, (class_2960)this.guiTexture);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 47), (double)(winX + 76), (double)(winY + 53), (int)this.sColor, (int)-8421505, (int)-8421505, (int)this.sColor);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 61), (double)(winX + 51), (double)(winY + 67), (int)this.lvColor, (int)-16777216, (int)-16777216, (int)this.lvColor);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 51), (double)(winY + 61), (double)(winX + 76), (double)(winY + 67), (int)-1, (int)this.lvColor, (int)this.lvColor, (int)-1);
                break;
            }
            case HSV: {
                GuiHelper.drawTextureScaled((class_332)graphics, (double)(winX + 26), (double)(winY + 33), (int)0, (int)250, (int)50, (int)6, (double)1.0, (int)77, (int)256, (class_2960)this.guiTexture);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 47), (double)(winX + 76), (double)(winY + 53), (int)this.sColor, (int)-1, (int)-1, (int)this.sColor);
                GuiHelper.drawGradientRect((class_332)graphics, (double)(winX + 26), (double)(winY + 61), (double)(winX + 76), (double)(winY + 67), (int)this.lvColor, (int)-16777216, (int)-16777216, (int)this.lvColor);
            }
        }
        GuiHelper.drawTextureScaled((class_332)graphics, (double)((double)winX + 24.75 + (double)(50.0f * this.slider[0])), (double)(winY + 33), (int)0, (int)206, (int)10, (int)24, (double)0.25, (class_2960)this.guiTexture);
        GuiHelper.drawTextureScaled((class_332)graphics, (double)((double)winX + 24.75 + (double)(50.0f * this.slider[1])), (double)(winY + 47), (int)0, (int)206, (int)10, (int)24, (double)0.25, (class_2960)this.guiTexture);
        GuiHelper.drawTextureScaled((class_332)graphics, (double)((double)winX + 24.75 + (double)(50.0f * this.slider[2])), (double)(winY + 61), (int)0, (int)206, (int)10, (int)24, (double)0.25, (class_2960)this.guiTexture);
        GuiHelper.drawRect((class_332)graphics, (double)(winX + 94), (double)(winY + 34), (double)(winX + 126), (double)(winY + 66), (int)RGB16Helper.getColor((short)this.resultIndex));
        if (this.savePreset < 0) {
            GuiHelper.renderItemWithOverlays((class_332)graphics, (class_327)this.field_22793, (class_1799)WOOL_STACKS.get(this.resultDye), (int)(winX + 110), (int)(winY + 50));
        }
    }

    private void drawGuiContainerForegroundLayer(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int winX = (this.field_22789 - this.xSize) / 2;
        int winY = (this.field_22790 - this.ySize) / 2;
        if (this.savePreset < 0) {
            if (mouseX >= winX + 94 && mouseY >= winY + 34 && mouseX <= winX + 126 && mouseY <= winY + 66) {
                String colorInfo = RGB16Helper.getTooltip((short)this.resultIndex) + "\u00a77 - \u00a7" + ItemColorizer.getFormatCode(this.resultDye) + class_1074.method_4662((String)this.resultDye.method_7792(), (Object[])new Object[0]);
                ArrayList<class_5250> list = new ArrayList<class_5250>();
                list.add(class_2561.method_43470((String)colorInfo));
                graphics.method_51434(this.field_22793, list, mouseX, mouseY);
                return;
            }
            for (class_4068 button : this.field_33816) {
                if (!(button instanceof ButtonPreset) || !((ButtonPreset)button).method_25405(mouseX, mouseY)) continue;
                if (button instanceof ButtonColor) {
                    graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)((ButtonColor)button).getDyeColor().method_7792()), mouseX, mouseY);
                } else {
                    int index = ((ButtonPreset)button).getIndex();
                    ArrayList<class_5250> list = new ArrayList<class_5250>();
                    if (!Strings.isNullOrEmpty((String)this.presetName[index])) {
                        list.add(class_2561.method_43470((String)this.presetName[index]));
                    }
                    list.add(class_2561.method_43470((String)RGB16Helper.getTooltip((short)this.presetIndex[index])));
                    list.add(class_2561.method_43473());
                    list.add(class_2561.method_43470((String)("\u00a77\u00a7o" + this.TEXT_PRESET_SAVE)));
                    list.add(class_2561.method_43470((String)("\u00a77\u00a7o" + this.TEXT_PRESET_LOAD)));
                    graphics.method_51434(this.field_22793, list, mouseX, mouseY);
                }
                return;
            }
        } else {
            GuiHelper.drawTexture((class_332)graphics, (double)(winX + 18), (double)(winY + 28), (int)154, (int)0, (int)102, (int)53, (class_2960)this.guiTexture);
            for (class_4068 button : this.field_33816) {
                if (!(button instanceof ButtonPresetMenu)) continue;
                button.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            this.textField.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean method_25400(char character, int keyCode) {
        if (this.textField != null && this.textField.method_1885() && this.textField.method_25400(character, keyCode)) {
            return true;
        }
        return super.method_25400(character, keyCode);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.savePreset == -1) {
            if (keyCode == 256 || this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.field_22787.method_1507(null);
                if (this.field_22787.field_1755 == null) {
                    this.field_22787.method_15995(true);
                }
            }
            NetworkHandler.sendToServer((PacketBase)new PacketColorizer(-1, this.resultIndex, ""));
            return true;
        }
        if (keyCode == 256 || keyCode == 257) {
            if (keyCode == 257) {
                this.saveAndSyncPreset();
            }
            this.savePreset = (byte)-1;
            this.method_25426();
            return true;
        }
        if (this.textField != null && this.textField.method_1885() && this.textField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.textField != null && this.textField.method_1885() && this.textField.method_16803(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.textField != null && this.textField.method_1885() && this.textField.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.textField != null && this.textField.method_1885() && this.textField.method_25403(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (this.textField != null && this.textField.method_1885() && this.textField.method_25401(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scroll);
    }

    private void setSliders(float[] values) {
        if (values != null && values.length == 3) {
            for (int index = 0; index < 3; index = (int)((byte)(index + 1))) {
                this.slider[index] = class_3532.method_15363((float)values[index], (float)0.0f, (float)1.0f);
            }
        }
    }

    private void setupColors() {
        this.lastSlider[0] = this.slider[0];
        this.lastSlider[1] = this.slider[1];
        this.lastSlider[2] = this.slider[2];
        switch (this.mode) {
            case RGB: {
                this.resultColor = ColorHelper.rgbToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
                break;
            }
            case HSL: {
                this.sColor = ColorHelper.hslToColor((float)this.slider[0], (float)1.0f, (float)0.5f);
                this.lvColor = ColorHelper.hslToColor((float)this.slider[0], (float)this.slider[1], (float)0.5f);
                this.resultColor = ColorHelper.hslToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
                break;
            }
            case HSV: {
                this.sColor = ColorHelper.hsvToColor((float)this.slider[0], (float)1.0f, (float)1.0f);
                this.lvColor = ColorHelper.hsvToColor((float)this.slider[0], (float)this.slider[1], (float)1.0f);
                this.resultColor = ColorHelper.hsvToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
            }
        }
        this.resultIndex = RGB16Helper.getIndexFor((int)this.resultColor);
        this.resultDye = RGB16Helper.getDyeColor((short)this.resultIndex);
    }

    private void saveAndSyncPreset() {
        if (!this.colorizer.method_7960() && this.colorizer.method_7909() instanceof ItemColorizer) {
            ((ItemColorizer)this.colorizer.method_7909()).setRGB16Preset(this.colorizer, this.savePreset, this.resultIndex, this.textField.method_1882());
        }
        NetworkHandler.sendToServer((PacketBase)new PacketColorizer(this.savePreset, this.resultIndex, this.textField.method_1882()));
    }

    public boolean method_25421() {
        return false;
    }

    private static enum Mode {
        RGB,
        HSL,
        HSV;

    }

    private static class ButtonMode
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final Mode mode;
        private final Point normal = new Point(0, 240);
        private final Point hover = new Point(32, 240);
        private final Point pressed = new Point(64, 240);

        public ButtonMode(GuiColorizer parent, int posX, int posY, Mode mode) {
            super(posX, posY, 32, 10);
            this.parent = parent;
            this.mode = mode;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_22764) {
                return;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            boolean bl = this.field_22762 = this.field_22763 && mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
            Point txPoint = this.parent.mode == this.mode ? this.pressed : (this.field_22762 ? this.hover : this.normal);
            GuiHelper.drawTexture((class_332)graphics, (double)x, (double)y, (int)txPoint.x, (int)txPoint.y, (int)this.field_22758, (int)this.field_22759, (class_2960)this.parent.guiTexture);
            String displayString = this.mode.toString().toUpperCase();
            if (!Strings.isNullOrEmpty((String)displayString)) {
                class_327 font = class_310.method_1551().field_1772;
                float left = (float)x + (float)this.field_22758 / 2.0f - (float)font.method_1727(displayString) / 2.0f;
                float top = (float)y + (float)(this.field_22759 - 8) / 2.0f;
                GuiHelper.drawString((class_332)graphics, (class_327)font, (String)displayString, (float)(left + 0.5f), (float)(top + 0.6f), (int)0x1A1A1A, (boolean)false);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25361(mouseX, mouseY)) {
                if (this.parent.mode != this.mode) {
                    this.parent.mode = this.mode;
                    switch (this.mode) {
                        case RGB: {
                            this.parent.setSliders(ColorHelper.colorToRGB((int)this.parent.resultColor));
                            break;
                        }
                        case HSL: {
                            this.parent.setSliders(ColorHelper.colorToHSL((int)this.parent.resultColor));
                            break;
                        }
                        case HSV: {
                            this.parent.setSliders(ColorHelper.colorToHSV((int)this.parent.resultColor));
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class ButtonSlider
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final Operation operation;
        private final Segment segment;

        public ButtonSlider(GuiColorizer parent, int posX, int posY, int sizeX, int sizeY, Segment segment, Operation operation) {
            super(posX, posY, sizeX, sizeY);
            this.parent = parent;
            this.operation = operation;
            this.segment = segment;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_22764 || this.operation == Operation.SELECT) {
                return;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            boolean bl = this.field_22762 = this.field_22763 && mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
            Point txPoint = this.field_22762 ? (class_310.method_1551().field_1729.method_1608() ? this.operation.pressed : this.operation.hover) : this.operation.normal;
            GuiHelper.drawTexture((class_332)graphics, (double)x, (double)y, (int)txPoint.x, (int)txPoint.y, (int)this.field_22758, (int)this.field_22759, (class_2960)this.parent.guiTexture);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25361(mouseX, mouseY)) {
                float step = 0.01f;
                if (this.operation == Operation.SUBTRACT) {
                    this.parent.slider[this.segment.ordinal()] = class_3532.method_15363((float)(this.parent.slider[this.segment.ordinal()] - step), (float)0.0f, (float)1.0f);
                } else if (this.operation == Operation.ADD) {
                    this.parent.slider[this.segment.ordinal()] = class_3532.method_15363((float)(this.parent.slider[this.segment.ordinal()] + step), (float)0.0f, (float)1.0f);
                } else {
                    double mx = mouseX - (double)this.method_46426();
                    double diff = mx - (double)((int)mx);
                    diff = diff < (double)0.4f ? 0.0 : (diff > (double)0.6f ? 1.0 : 0.5);
                    this.parent.slider[this.segment.ordinal()] = class_3532.method_15363((float)((float)(((double)((int)mx) + diff) * 2.0) / 100.0f), (float)0.0f, (float)1.0f);
                }
                return true;
            }
            return false;
        }

        static enum Operation {
            ADD(new Point(30, 230), new Point(40, 230), new Point(50, 230)),
            SUBTRACT(new Point(0, 230), new Point(10, 230), new Point(20, 230)),
            SELECT(null, null, null);

            private final Point normal;
            private final Point hover;
            private final Point pressed;

            private Operation(Point normal, Point hover, Point pressed) {
                this.normal = normal;
                this.hover = hover;
                this.pressed = pressed;
            }
        }

        static enum Segment {
            RED,
            GREEN,
            BLUE;

        }
    }

    private static class ButtonColor
    extends ButtonPreset {
        private final class_1767 dyeColor;

        public ButtonColor(GuiColorizer parent, int posX, int posY, class_1767 dyeColor) {
            super(parent, posX, posY, dyeColor.method_7789(), 5, 3, RGB16Helper.getIndexFor((class_1767)dyeColor));
            this.dyeColor = dyeColor;
        }

        public class_1767 getDyeColor() {
            return this.dyeColor;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            return super.method_25402(mouseX, mouseY, 0);
        }
    }

    private static class ButtonPreset
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final int index;
        private final int color;
        private final short rgb16;

        public ButtonPreset(GuiColorizer parent, int posX, int posY, int index) {
            this(parent, posX, posY, index, 8, 8, parent.presetIndex[index]);
        }

        protected ButtonPreset(GuiColorizer parent, int posX, int posY, int index, int width, int height, short rgb16) {
            super(posX, posY, width, height);
            this.parent = parent;
            this.index = index;
            this.rgb16 = rgb16;
            this.color = RGB16Helper.getColor((short)rgb16);
        }

        public int getIndex() {
            return this.index;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_22764) {
                return;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            this.field_22762 = this.field_22763 && mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
            GuiHelper.drawRect((class_332)graphics, (double)x, (double)y, (double)(x + this.field_22758), (double)(y + this.field_22759), (int)this.color);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25361(mouseX, mouseY)) {
                if (button == 0) {
                    this.parent.resultIndex = this.rgb16;
                    this.parent.resultColor = this.color;
                    switch (this.parent.mode) {
                        case RGB: {
                            this.parent.setSliders(ColorHelper.colorToRGB((int)this.color));
                            break;
                        }
                        case HSL: {
                            this.parent.setSliders(ColorHelper.colorToHSL((int)this.color));
                            break;
                        }
                        case HSV: {
                            this.parent.setSliders(ColorHelper.colorToHSV((int)this.color));
                        }
                    }
                } else if (button == 1) {
                    this.parent.savePreset = (byte)this.index;
                    this.parent.method_25426();
                }
                return true;
            }
            return false;
        }
    }

    private static class ButtonPresetMenu
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final int index;
        private final Point normal = new Point(60, 230);
        private final Point hover = new Point(70, 230);
        private final Point pressed = new Point(80, 230);

        ButtonPresetMenu(GuiColorizer parent, int x, int y, int index) {
            super(x, y, 10, 10);
            this.parent = parent;
            this.index = index;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_22764) {
                return;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            boolean bl = this.field_22762 = this.field_22763 && mouseX >= x && mouseY >= y && mouseX < x + this.field_22758 && mouseY < y + this.field_22759;
            Point txPoint = this.field_22762 ? (class_310.method_1551().field_1729.method_1608() ? this.pressed : this.hover) : this.normal;
            GuiHelper.drawTexture((class_332)graphics, (double)x, (double)y, (int)txPoint.x, (int)txPoint.y, (int)this.field_22758, (int)this.field_22759, (class_2960)this.parent.guiTexture);
            GuiHelper.drawTexture((class_332)graphics, (double)x, (double)y, (int)(10 * this.index), (int)220, (int)this.field_22758, (int)this.field_22759, (class_2960)this.parent.guiTexture);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25361(mouseX, mouseY)) {
                if (this.index == 1 || this.index == 2) {
                    if (this.index == 1) {
                        this.parent.saveAndSyncPreset();
                    }
                    this.parent.savePreset = (byte)-1;
                    this.parent.method_25426();
                } else if (this.index == 3) {
                    this.parent.textField.method_1852(this.parent.textField.method_1882() + "\u00a7");
                }
                return true;
            }
            return false;
        }
    }
}

