/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.model;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import shetiphian.core.client.model.IPartData;
import shetiphian.terraqueous.client.model.PartData;

@Environment(value=EnvType.CLIENT)
public class Parts {
    static final List<class_2960> TEXTURES = Parts.getTextures();
    static final List<IPartData> WALL_MODELS = Parts.getWallModels();
    static final List<IPartData> ROOF_MODELS = Parts.getRoofModels();
    static final List<IPartData> GATE_MODELS = Parts.getGateModels();
    static final String TEXTURE_BASE = "terraqueous:block/pergola";
    private static final String TEXTURE_VINE = "terraqueous:block/plants/vine";
    private static final String TEXTURE_LEAF = "terraqueous:block/plants/vine_foliage";
    private static final String TEXTURE_KELP = "terraqueous:block/plants/kelp_vine";
    private static final String TEXTURE_MCVINES = "minecraft:block/vine";
    static final String TEXTURE_GRAPES = "terraqueous:block/plants/vine_fruit_grapes";
    static final String TEXTURE_LIFEFRUIT = "terraqueous:block/plants/vine_fruit_life";
    static final String TEXTURE_DEATHFRUIT = "terraqueous:block/plants/vine_fruit_death";

    private static List<class_2960> getTextures() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        list.add(new class_2960(TEXTURE_BASE));
        list.add(new class_2960(TEXTURE_VINE));
        list.add(new class_2960(TEXTURE_LEAF));
        list.add(new class_2960(TEXTURE_KELP));
        list.add(new class_2960(TEXTURE_GRAPES));
        list.add(new class_2960(TEXTURE_LIFEFRUIT));
        list.add(new class_2960(TEXTURE_DEATHFRUIT));
        return list;
    }

    private static List<IPartData> getWallModels() {
        String[] parts;
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        list.add(new PartData("wall/hanging_fruit_n"));
        list.add(new PartData("wall/hanging_fruit_s"));
        for (String part : parts = new String[]{"part_n", "part_nb", "part_nm", "part_nt", "part_s", "part_sb", "part_sm", "part_st"}) {
            list.add(new PartData("wall/" + part));
            list.add(new PartData("wall/vines_" + part, TEXTURE_VINE));
            list.add(new PartData("wall/vines_" + part + "_", TEXTURE_LEAF));
            list.add(new PartData("wall/vines_" + part + "_kelp", TEXTURE_KELP));
            list.add(new PartData("wall/vines_" + part + "_simple", TEXTURE_MCVINES));
        }
        for (String part : parts = new String[]{"part_p", "part_pb", "part_pt"}) {
            list.add(new PartData("wall/" + part).noRotation());
            list.add(new PartData("wall/vines_" + part, TEXTURE_VINE).noRotation());
            list.add(new PartData("wall/vines_" + part + "_", TEXTURE_LEAF).noRotation());
            list.add(new PartData("wall/vines_" + part + "_kelp", TEXTURE_KELP).noRotation());
            list.add(new PartData("wall/vines_" + part + "_simple", TEXTURE_MCVINES).noRotation());
        }
        return list;
    }

    private static List<IPartData> getRoofModels() {
        String[] parts;
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        list.add(new PartData("roof/hanging_fruit_high").noRotation());
        list.add(new PartData("roof/hanging_fruit_low").noRotation());
        for (String part : parts = new String[]{"part_bars", "part_beam_ew_dual", "part_beam_ew_single", "part_beam_ns_dual", "part_cap_e_dual", "part_cap_e_single", "part_cap_n_dual", "part_cap_s_dual", "part_cap_w_dual", "part_cap_w_single", "part_plate", "part_post_l"}) {
            list.add(new PartData("roof/" + part).noRotation());
            if (part.startsWith("part_cap")) continue;
            list.add(new PartData("roof/vines_" + part, TEXTURE_VINE).noRotation());
            list.add(new PartData("roof/vines_" + part + "_", TEXTURE_LEAF).noRotation());
            list.add(new PartData("roof/vines_" + part + "_kelp", TEXTURE_KELP).noRotation());
            list.add(new PartData("roof/vines_" + part + "_simple", TEXTURE_MCVINES).noRotation());
        }
        return list;
    }

    private static List<IPartData> getGateModels() {
        String[] parts;
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        for (String part : parts = new String[]{"part_doors_closed", "part_posts", "part_top_bar"}) {
            list.add(new PartData("gate/" + part));
            list.add(new PartData("gate/vines_" + part, TEXTURE_VINE));
            list.add(new PartData("gate/vines_" + part + "_", TEXTURE_LEAF));
            list.add(new PartData("gate/vines_" + part + "_kelp", TEXTURE_KELP));
            list.add(new PartData("gate/vines_" + part + "_simple", TEXTURE_MCVINES));
        }
        list.add(new PartData("gate/part_doors_open").fullRotation());
        list.add(new PartData("gate/vines_part_doors_open", TEXTURE_VINE).fullRotation());
        list.add(new PartData("gate/vines_part_doors_open_", TEXTURE_LEAF).fullRotation());
        list.add(new PartData("gate/vines_part_doors_open_kelp", TEXTURE_KELP).fullRotation());
        list.add(new PartData("gate/vines_part_doors_open_simple", TEXTURE_MCVINES).fullRotation());
        return list;
    }
}

