/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7753;
import net.minecraft.class_7754;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;
import shetiphian.terraqueous.common.entity.EntityBoat;
import shetiphian.terraqueous.common.entity.EntityChestBoat;
import shetiphian.terraqueous.common.entity.EnumBoatVariant;

@Environment(value=EnvType.CLIENT)
public class RenderBoat
extends class_897<class_1690> {
    private final Map<EnumBoatVariant, Pair<class_2960, class_4595<class_1690>>> texturesAndModels = (Map)Stream.of(EnumBoatVariant.values()).collect(ImmutableMap.toImmutableMap(variant -> variant, variant -> Pair.of((Object)new class_2960("%s:textures/entity/%s/%s.png".formatted("terraqueous", isChestBoat ? "chest_boat" : "boat", variant.getName())), this.getModel(context, (EnumBoatVariant)((Object)variant), isChestBoat))));

    public RenderBoat(class_5617.class_5618 context, boolean isChestBoat) {
        super(context);
    }

    private class_4595<class_1690> getModel(class_5617.class_5618 context, EnumBoatVariant variant, boolean isChestBoat) {
        class_630 modelpart = context.method_32167(RenderBoat.createBoatModelName(variant, isChestBoat));
        if (variant.isRaft()) {
            return isChestBoat ? new class_7753(modelpart) : new class_7754(modelpart);
        }
        return isChestBoat ? new class_7752(modelpart) : new class_554(modelpart);
    }

    public static class_5601 createBoatModelName(EnumBoatVariant variant, boolean hasChest) {
        return new class_5601(new class_2960("terraqueous", (hasChest ? "chest_boat/" : "boat/") + variant.getName()), "main");
    }

    public void render(class_1690 boat, float yaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        Pair<class_2960, class_4595<class_1690>> pair = this.getModelWithLocation(boat);
        if (pair != null) {
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.375f, 0.0f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
            float wobbleTicks = (float)boat.method_7533() - partialTicks;
            float wobbleStrength = boat.method_7554() - partialTicks;
            if (wobbleStrength < 0.0f) {
                wobbleStrength = 0.0f;
            }
            if (wobbleTicks > 0.0f) {
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)wobbleTicks) * wobbleTicks * wobbleStrength / 10.0f * (float)boat.method_7543()));
            }
            if (!class_3532.method_15347((float)boat.method_7547(partialTicks), (float)0.0f)) {
                matrixStack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
            }
            class_4595 model = (class_4595)pair.getSecond();
            matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            model.method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            class_4588 vertexConsumer = buffer.getBuffer(model.method_23500((class_2960)pair.getFirst()));
            model.method_2828(matrixStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            if (!boat.method_5869() && model instanceof class_7755) {
                class_7755 waterModel = (class_7755)model;
                waterModel.method_22954().method_22698(matrixStack, buffer.getBuffer(class_1921.method_23589()), packedLight, class_4608.field_21444);
            }
            matrixStack.method_22909();
        }
        super.method_3936((class_1297)boat, yaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public class_2960 getTexture(class_1690 boat) {
        return (class_2960)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<class_2960, class_4595<class_1690>> getModelWithLocation(class_1690 boat) {
        if (boat instanceof EntityBoat) {
            EntityBoat entityBoat = (EntityBoat)boat;
            return this.texturesAndModels.get((Object)entityBoat.getBoatVariant());
        }
        if (boat instanceof EntityChestBoat) {
            EntityChestBoat entityBoat = (EntityChestBoat)boat;
            return this.texturesAndModels.get((Object)entityBoat.getBoatVariant());
        }
        return null;
    }
}

