/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import shetiphian.terraqueous.client.model.ModelEnderBook;
import shetiphian.terraqueous.common.tileentity.TileEntityEnderTable;

@Environment(value=EnvType.CLIENT)
public class RenderEnderTable
implements class_827<TileEntityEnderTable> {
    private static final class_2960 TEXTURE_BOOK = new class_2960("terraqueous", "textures/entity/enderbook.png");
    private static final class_2960 ANIMATION_FILE = new class_2960("terraqueous", "textures/entity/enderbook_animation.json");
    private static final Gson GSON = new GsonBuilder().create();
    private static ModelEnderBook[] MODELS;
    private static byte[] ANIMATION_FRAMES;
    private static int ANIMATION_TIME;

    public void render(TileEntityEnderTable table, float partialTicks, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        float f1;
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.75, 0.5);
        float f = (float)table.field_11961 + partialTicks;
        matrixStack.method_22904(0.0, (double)(0.1f + class_3532.method_15374((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = table.field_11964 - table.field_11963; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = table.field_11963 + f1 * partialTicks;
        matrixStack.method_22907(class_7833.field_40716.rotation(-f2));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(80.0f));
        float f3 = class_3532.method_16439((float)partialTicks, (float)table.field_11960, (float)table.field_11958);
        float f4 = class_3532.method_22450((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = class_3532.method_22450((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = class_3532.method_16439((float)partialTicks, (float)table.field_11965, (float)table.field_11966);
        ModelEnderBook enderBook = RenderEnderTable.getModelBook();
        enderBook.setBookState(f, class_3532.method_15363((float)f4, (float)0.0f, (float)1.0f), class_3532.method_15363((float)f5, (float)0.0f, (float)1.0f), f6);
        class_4588 vertexConsumer = buffer.getBuffer(enderBook.method_23500(TEXTURE_BOOK));
        enderBook.render(matrixStack, vertexConsumer, combinedLight, combinedOverlay);
        matrixStack.method_22909();
    }

    public static ModelEnderBook getModelBook() {
        long time;
        int index;
        if (ANIMATION_FRAMES == null) {
            RenderEnderTable.load_animation();
        }
        byte frame = (index = (int)((time = System.currentTimeMillis() / 200L) % (long)ANIMATION_TIME)) >= ANIMATION_FRAMES.length ? (byte)0 : ANIMATION_FRAMES[index];
        return MODELS[frame];
    }

    public static void onResourceManagerReload() {
        RenderEnderTable.load_animation();
    }

    private static void load_animation() {
        ANIMATION_FRAMES = null;
        int frameCount = 1;
        int pauseTime = 0;
        try (BufferedReader reader = class_310.method_1551().method_1478().openAsReader(ANIMATION_FILE);){
            Map json = (Map)GSON.fromJson((Reader)reader, Map.class);
            Object object = json.get("total_frames");
            if (object instanceof Double) {
                frameCount = ((Double)object).intValue();
            }
            if ((object = json.get("pause_time")) instanceof Double) {
                pauseTime = ((Double)object).intValue();
            }
            if ((object = json.get("frames")) instanceof ArrayList) {
                ArrayList array = (ArrayList)object;
                ANIMATION_FRAMES = new byte[array.size()];
                int index = 0;
                for (Object element : array) {
                    if (!(element instanceof Double)) continue;
                    RenderEnderTable.ANIMATION_FRAMES[index] = (byte)class_3532.method_15350((double)((Double)element), (double)0.0, (double)(frameCount - 1));
                    ++index;
                }
            }
        }
        catch (Exception ignored) {
            ANIMATION_FRAMES = null;
            frameCount = 1;
            pauseTime = 0;
        }
        if (ANIMATION_FRAMES == null) {
            ANIMATION_FRAMES = new byte[1];
        }
        ANIMATION_TIME = ANIMATION_FRAMES.length + pauseTime;
        MODELS = new ModelEnderBook[frameCount];
        for (int index = 0; index < frameCount; ++index) {
            RenderEnderTable.MODELS[index] = new ModelEnderBook(index, frameCount);
        }
    }
}

