/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.item.ItemBlockFlowers;
import shetiphian.terraqueous.common.misc.IInteractionHandler;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.worldgen.BiomeHelper;

public class BlockFlowers
extends class_2356
implements IBonemealable {
    public static final class_2758 SIZE = class_2758.method_11867((String)"size", (int)0, (int)1);
    private IInteractionHandler handler = null;

    public BlockFlowers(IInteractionHandler handler) {
        this(class_1294.field_5911, 4);
        this.handler = handler;
    }

    public BlockFlowers(class_1291 effect, int effectDuration) {
        super(effect, effectDuration, class_4970.class_2251.method_9630((class_4970)class_2246.field_10182).method_9640());
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(0)));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SIZE});
    }

    public static int maxSize() {
        return 1;
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return true;
    }

    protected boolean method_9695(class_2680 state, class_1922 world, class_2338 pos) {
        return TagHelper.isBlockInTag((class_2680)state, (class_6862)class_3481.field_29822) || state.method_26204() == class_2246.field_10219 || state.method_26204() == Roster.Blocks.PLANTER;
    }

    public boolean canGrow(class_1937 world, class_2338 pos, class_2680 state, boolean isClient) {
        return (Integer)state.method_11654((class_2769)SIZE) < BlockFlowers.maxSize() || Function.getBlockDown((class_1922)world, (class_2338)pos) != Roster.Blocks.PLANTER;
    }

    public boolean canUseBonemeal(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return this.canGrow(world, pos, state, world.method_8608()) && (double)random.method_43057() < 0.45;
    }

    public void grow(class_1937 world, class_5819 rand, class_2338 pos, class_2680 state) {
        if (!world.method_8608()) {
            if ((Integer)state.method_11654((class_2769)SIZE) < BlockFlowers.maxSize()) {
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)SIZE) + 1))), (boolean)true);
            } else if (Function.getBlockDown((class_1922)world, (class_2338)pos) != Roster.Blocks.PLANTER) {
                this.spreadFlower(world, rand, pos, state);
            }
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.method_8608() && world.method_8530()) {
            if (this.method_9558(state, (class_4538)world, pos)) {
                if ((Integer)state.method_11654((class_2769)SIZE) < BlockFlowers.maxSize()) {
                    if (PlantFunctions.canGrow((class_1937)world, pos, PlantAPI.Plant.FLOWER)) {
                        this.grow((class_1937)world, random, pos, state);
                    }
                } else if (Function.getBlockDown((class_1922)world, (class_2338)pos) != Roster.Blocks.PLANTER && PlantFunctions.canSpread((class_1937)world, pos, PlantAPI.Plant.FLOWER)) {
                    this.grow((class_1937)world, random, pos, state);
                }
            } else {
                world.method_8650(pos, true);
            }
        }
    }

    private void spreadFlower(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        byte maxAttempts = PlantFunctions.getMaxPlacementAttempts((class_1922)world, pos, PlantAPI.Plant.FLOWER);
        byte[] spreadRadius = PlantFunctions.getSpreadRadius((class_1922)world, pos, PlantAPI.Plant.FLOWER);
        for (byte attempt = 0; attempt < maxAttempts; attempt = (byte)(attempt + 1)) {
            class_2338 sPos = pos.method_10069(this.getOffset(spreadRadius[0], random), this.getOffset(spreadRadius[1], random), this.getOffset(spreadRadius[0], random));
            class_2680 sState = world.method_8320(sPos);
            if (sState.method_26215() && this.method_9558(sState, (class_4538)world, sPos) && this.canSpreadHere(world, sPos)) {
                Function.setBlock((class_1945)world, (class_2338)sPos, (class_2680)((class_2680)state.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(0))), (boolean)true);
                return;
            }
            pos = sPos;
        }
    }

    private int getOffset(int spreadRadius, class_5819 random) {
        return random.method_43048(spreadRadius) - random.method_43048(spreadRadius);
    }

    private boolean canSpreadHere(class_1937 world, class_2338 pos) {
        if (Function.getBlockDown((class_1922)world, (class_2338)pos) == Roster.Blocks.PLANTER) {
            return false;
        }
        int touching = 0;
        int total = 0;
        int air = 0;
        for (int sX = -2; sX <= 2; sX = (int)((byte)(sX + 1))) {
            for (int sZ = -2; sZ <= 2; sZ = (int)((byte)(sZ + 1))) {
                if (sX == 0 && sZ == 0) continue;
                class_2338 sPos = pos.method_10069(sX, 0, sZ);
                if (world.method_22347(sPos)) {
                    air = (byte)(air + 1);
                    continue;
                }
                if (world.method_8320(sPos).method_26204() != this) continue;
                total = (byte)(total + 1);
                if (sZ == 0 && (sX == -1 || sX == 1)) {
                    touching = (byte)(touching + 1);
                }
                if (sX != 0 || sZ != -1 && sZ != 1) continue;
                touching = (byte)(touching + 1);
            }
        }
        return touching < 2 && total < 2 && air > 12;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (Function.getBlockDown((class_1922)world, (class_2338)pos) == Roster.Blocks.PLANTER) {
            return true;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        if (BiomeHelper.isFreezing(biome) || biome.method_48162(pos) == class_1959.class_1963.field_9383) {
            return false;
        }
        return Function.getBlockDown((class_1922)world, (class_2338)pos) != class_2246.field_10362 && super.method_9558(state, world, pos);
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ItemBlockFlowers.create(new class_1799((class_1935)this), (Integer)state.method_11654((class_2769)SIZE));
    }

    public class_1291 method_10188() {
        class_1291 effect = this.handler != null ? this.handler.getStewEffect((class_2248)this) : null;
        return effect != null ? effect : super.method_10188();
    }

    public int method_10187() {
        int duration = this.handler != null ? this.handler.getStewEffectDuration((class_2248)this) : -1;
        return duration > -1 ? duration : super.method_10187();
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (this.handler != null && !this.handler.onEntityCollision(state, world, pos, entity)) {
            super.method_9548(state, world, pos, entity);
        }
    }
}

