/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_10;
import net.minecraft.class_1163;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.block.BlockPergolaGate;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.item.ItemBlockVine;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public abstract class BlockPergola
extends class_2248
implements class_2343,
IBonemealable,
IColored,
IRGB16_Block,
class_3737,
BlockPickInteractionAware {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<EnumCover> COVERING = class_2754.method_11850((String)"covering", EnumCover.class);
    protected static final class_265 SUPPORT_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public BlockPergola() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15976).method_22488().method_50012(class_3619.field_15975).method_9629(2.0f, 10.0f).method_9640().method_9626(class_2498.field_11547).method_26235((state, world, pos, type) -> false));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(COVERING, (Comparable)((Object)EnumCover.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            TerraqueousClient.colorize(this);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581());
        });
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{COVERING, WATERLOGGED});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityRGB16(Roster.Tiles.RGB16, pos, state, class_1767.field_7952);
    }

    private TileEntityRGB16 getTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityRGB16 ? (TileEntityRGB16)tile : null;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 stack) {
        EnumCover covering = (EnumCover)((Object)state.method_11654(COVERING));
        if (covering != EnumCover.NONE) {
            class_2248 vine;
            covering.dropFruit(player, (class_1936)world, pos);
            if (ToolHelper.isShears((class_1799)stack) && (vine = covering.getVine()) != null) {
                Function.dropItem((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)vine));
            }
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)EnumCover.NONE))), (boolean)true);
            return;
        }
        super.method_9585((class_1936)world, pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldItem;
        EnumCover cover = (EnumCover)((Object)state.method_11654(COVERING));
        if (cover.hasFruit()) {
            cover.dropFruit(player, (class_1936)world, pos);
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)cover.getWithoutFruit()))), (boolean)true);
            return class_1269.field_5812;
        }
        if ((cover == EnumCover.NONE || player.method_31549().field_7477) && !(heldItem = player.method_5998(hand)).method_7960()) {
            EnumCover covering = EnumCover.NONE;
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                if (heldItem.method_7909() instanceof class_1747 && ((class_1747)heldItem.method_7909()).method_7711() == class_2246.field_9993) {
                    covering = EnumCover.KELP;
                }
            } else if (heldItem.method_7909() instanceof ItemBlockVine) {
                boolean withFruit = ItemBlockVine.hasFruit(heldItem);
                covering = switch (((ItemBlockVine)heldItem.method_7909()).getPlantType()) {
                    case PlantAPI.Plant.GRAPEVINE -> {
                        if (withFruit) {
                            yield EnumCover.GRAPEVINE_FRUIT;
                        }
                        yield EnumCover.GRAPEVINE;
                    }
                    case PlantAPI.Plant.LIFEVINE -> {
                        if (withFruit) {
                            yield EnumCover.LIFEVINE_FRUIT;
                        }
                        yield EnumCover.LIFEVINE;
                    }
                    case PlantAPI.Plant.DEATHVINE -> {
                        if (withFruit) {
                            yield EnumCover.DEATHVINE_FRUIT;
                        }
                        yield EnumCover.DEATHVINE;
                    }
                    default -> covering;
                };
            } else if (heldItem.method_7909() instanceof class_1747 && ((class_1747)heldItem.method_7909()).method_7711() == class_2246.field_10597) {
                covering = EnumCover.VINE;
            }
            if (covering != EnumCover.NONE && covering != cover) {
                world.method_8396(null, pos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)covering))), (boolean)true);
                if (!player.method_31549().field_7477) {
                    heldItem.method_7934(1);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        return state.method_11654(COVERING) != EnumCover.NONE ? 0.2f : super.method_9594(state, player, world, pos);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!this.canGrow((class_1937)world, pos, state, false)) {
            return;
        }
        this.grow((class_1937)world, random, pos, state);
    }

    public boolean canUseBonemeal(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return this.canGrow(world, pos, state, false) && random.method_43057() < 0.45f;
    }

    public boolean canGrow(class_1937 world, class_2338 pos, class_2680 state, boolean isClient) {
        boolean waterlogged = (Boolean)state.method_11654((class_2769)WATERLOGGED);
        EnumCover cover = (EnumCover)((Object)state.method_11654(COVERING));
        if (cover == EnumCover.NONE) {
            return waterlogged;
        }
        if (waterlogged && cover != EnumCover.KELP || !waterlogged && cover == EnumCover.KELP) {
            if (cover.hasFruit() && !isClient) {
                cover.dropFruit(null, (class_1936)world, pos);
            }
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)EnumCover.NONE))), (boolean)true);
            return false;
        }
        if (!cover.hasFruit() && !(this instanceof BlockPergolaGate)) {
            return true;
        }
        for (class_2350 facing : class_2350.values()) {
            if (this.isBlockOvergrown(world, pos.method_10093(facing))) continue;
            return true;
        }
        return false;
    }

    private boolean isBlockOvergrown(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof BlockPergola && state.method_11654(COVERING) != EnumCover.NONE;
    }

    public void grow(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        EnumCover cover = (EnumCover)((Object)state.method_11654(COVERING));
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            if (world.field_9229.method_43048(4) == 0) {
                if (cover == EnumCover.NONE) {
                    Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)EnumCover.KELP))), (boolean)true);
                } else if (cover == EnumCover.KELP) {
                    if (world.field_9229.method_43056() && world.method_8320(pos.method_10084()).method_26204() == class_2246.field_10382) {
                        Function.setBlock((class_1945)world, (class_2338)pos.method_10084(), (class_2680)class_2246.field_9993.method_9564(), (boolean)true);
                    } else {
                        this.doSpread(world, this.getSpread(world, pos), EnumCover.KELP);
                    }
                }
            }
        } else if (cover != EnumCover.NONE) {
            boolean canSpread;
            EnumCover newCover;
            PlantAPI.Plant plantType = cover.getPlantType();
            if (!cover.hasFruit() && !(state.method_26204() instanceof BlockPergolaGate) && plantType != null && (newCover = cover.getWithFruit()) != cover && random.method_43056() && PlantFunctions.canGrowFruit(world, pos, plantType)) {
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)newCover))), (boolean)true);
                return;
            }
            boolean bl = plantType != null ? PlantFunctions.canSpread(world, pos, plantType) : (canSpread = world.field_9229.method_43048(4) == 0);
            if (canSpread) {
                this.doSpread(world, this.getSpread(world, pos), cover.getWithoutFruit());
            }
        }
    }

    private class_2338 getSpread(class_1937 world, class_2338 pos) {
        ArrayList<class_2350> list = new ArrayList<class_2350>();
        list.add(class_2350.field_11036);
        list.add(class_2350.field_11033);
        list.add(class_2350.field_11043);
        list.add(class_2350.field_11034);
        list.add(class_2350.field_11035);
        list.add(class_2350.field_11039);
        int attempts = list.size();
        for (int attempt = 0; attempt < attempts; attempt = (int)((byte)(attempt + 1))) {
            int index = Function.random.nextInt(attempts - attempt);
            class_2350 facing = (class_2350)list.get(index);
            list.remove(index);
            class_2338 sPos = pos.method_10093(facing);
            class_2680 state = world.method_8320(sPos);
            if (!(state.method_26204() instanceof BlockPergola) || this.isBlockOvergrown(world, sPos)) continue;
            return sPos;
        }
        return null;
    }

    private void doSpread(class_1937 world, class_2338 pos, EnumCover cover) {
        if (pos == null || cover == null) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof BlockPergola) || state.method_26204() instanceof BlockPergolaGate && (cover.hasFruit() || !((BlockPergolaGate)state.method_26204()).shouldOvergrow(state, world, pos))) {
            return;
        }
        Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(COVERING, (Comparable)((Object)cover))), (boolean)true);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        TileEntityRGB16 tile = this.getTile((class_1922)world, pos);
        if (tile != null && stack.method_7909() instanceof ItemBlockRGB) {
            tile.setRGB16(((ItemBlockRGB)stack.method_7909()).getRGB16(stack), placer instanceof class_1657 ? (class_1657)placer : null);
        }
    }

    public boolean recolorBlock(class_2680 state, class_1936 world, class_2338 pos, class_1657 player, class_1268 hand, class_2350 side, class_243 hitVec, String dyeName) {
        class_2586 tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = world.method_8321(pos)) instanceof TileEntityRGB16) {
            if (!world.method_8608()) {
                if (player == null) {
                    ((TileEntityRGB16)tile).getRGB16(null).setValues(dyeName);
                } else {
                    ((TileEntityRGB16)tile).getRGB16(player).recolor(player, dyeName);
                }
                Function.syncTile((class_2586)tile);
            }
            if (player != null) {
                player.method_6104(hand);
            }
            return true;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (data.world != null && data.pos != null) {
            if (index == 0) {
                class_2586 tile = data.world.method_8321(data.pos);
                if (tile instanceof TileEntityRGB16) {
                    RGB16 rgb16 = ((TileEntityRGB16)tile).getRGB16(null);
                    return rgb16 != null ? rgb16.getColor() : 0xFFFFFF;
                }
            } else if (data.state != null && index == 6) {
                PlantAPI.Plant plantType = ((EnumCover)((Object)data.state.method_11654(COVERING))).getPlantType();
                if (plantType != null) {
                    return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(plantType));
                }
                return class_1163.method_4966((class_1920)data.world, (class_2338)data.pos);
            }
        }
        return 0xFFFFFF;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        RGB16 rgb16;
        class_1799 stack = new class_1799((class_1935)this);
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            RGB16StackHelper.setRGB16((class_1799)stack, (RGB16)rgb16);
        }
        return stack;
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 world, class_2338 pos, class_1657 player, class_239 result) {
        class_2248 block;
        if (player != null && player.method_5715() && (block = ((EnumCover)((Object)state.method_11654(COVERING))).getVine()) != null) {
            return new class_1799((class_1935)block);
        }
        return this.method_9574(world, pos, state);
    }

    public static enum EnumCover implements class_3542
    {
        NONE("none", null, false),
        VINE("vine", null, false),
        KELP("kelp", null, false),
        GRAPEVINE("grapevine", PlantAPI.Plant.GRAPEVINE, false),
        GRAPEVINE_FRUIT("grapevine_fruit", PlantAPI.Plant.GRAPEVINE, true),
        LIFEVINE("lifevine", PlantAPI.Plant.LIFEVINE, false),
        LIFEVINE_FRUIT("lifevine_fruit", PlantAPI.Plant.LIFEVINE, true),
        DEATHVINE("deathvine", PlantAPI.Plant.DEATHVINE, false),
        DEATHVINE_FRUIT("deathvine_fruit", PlantAPI.Plant.DEATHVINE, true);

        private final String name;
        private final PlantAPI.Plant plant;
        private final boolean hasFruit;

        private EnumCover(String name, PlantAPI.Plant plant, boolean hasFruit) {
            this.name = name;
            this.plant = plant;
            this.hasFruit = hasFruit;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public PlantAPI.Plant getPlantType() {
            return this.plant;
        }

        public boolean hasFruit() {
            return this.hasFruit;
        }

        public void dropFruit(class_1657 player, class_1936 world, class_2338 pos) {
            if (this.hasFruit) {
                Object fruit;
                switch (this.plant) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case FLOWER: 
                    case GRASS: {
                        Object object = null;
                        break;
                    }
                    case PINEAPPLE: {
                        Object object = Roster.Items.PINEAPPLE;
                        break;
                    }
                    case CACTUS: {
                        Object object = Roster.Items.PRICKLYPEAR;
                        break;
                    }
                    case GRAPEVINE: {
                        Object object = Roster.Items.GRAPES;
                        break;
                    }
                    case LIFEVINE: {
                        Object object = Roster.Items.LIFEFRUIT;
                        break;
                    }
                    case DEATHVINE: {
                        Object object = fruit = Roster.Items.DEATHFRUIT;
                    }
                }
                if (fruit != null) {
                    if (player != null) {
                        Function.giveItem((class_1657)player, (class_1799)new class_1799((class_1935)fruit));
                    } else if (world instanceof class_1937) {
                        Function.dropItem((class_1937)((class_1937)world), (class_2338)pos, (class_1799)new class_1799((class_1935)fruit));
                    }
                }
            }
        }

        public EnumCover getWithFruit() {
            return switch (this) {
                case GRAPEVINE, GRAPEVINE_FRUIT -> GRAPEVINE_FRUIT;
                case LIFEVINE, LIFEVINE_FRUIT -> LIFEVINE_FRUIT;
                case DEATHVINE, DEATHVINE_FRUIT -> DEATHVINE_FRUIT;
                default -> this;
            };
        }

        public EnumCover getWithoutFruit() {
            return switch (this) {
                case GRAPEVINE, GRAPEVINE_FRUIT -> GRAPEVINE;
                case LIFEVINE, LIFEVINE_FRUIT -> LIFEVINE;
                case DEATHVINE, DEATHVINE_FRUIT -> DEATHVINE;
                default -> this;
            };
        }

        public class_2248 getVine() {
            return switch (this) {
                case VINE -> class_2246.field_10597;
                case KELP -> class_2246.field_9993;
                default -> {
                    if (this.plant == null) {
                        yield null;
                    }
                    switch (this.plant) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case FLOWER: 
                        case GRASS: 
                        case PINEAPPLE: 
                        case CACTUS: {
                            yield null;
                        }
                        case GRAPEVINE: {
                            yield Roster.Blocks.GRAPEVINE;
                        }
                        case LIFEVINE: {
                            yield Roster.Blocks.LIFEVINE;
                        }
                        case DEATHVINE: 
                    }
                    yield Roster.Blocks.DEATHVINE;
                }
            };
        }
    }

    public static enum EnumStyle implements class_3542
    {
        NONE("none"),
        NORMAL("normal"),
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private EnumStyle(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

