/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1163;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_8567;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.IPlantable;
import shetiphian.core.common.ISoil;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.misc.Tags;
import shetiphian.terraqueous.common.tileentity.TileEntityPlanter;

public class BlockPlanter
extends class_2248
implements class_2343,
IColored,
IRGB16_Block,
ISoil,
BlockPickInteractionAware {
    public static final class_2754<SoilType> SOIL = class_2754.method_11850((String)"soil", SoilType.class);
    public static final class_2746 NORTH = class_2746.method_11825((String)"north");
    public static final class_2746 NORTH_EAST = class_2746.method_11825((String)"northeast");
    public static final class_2746 EAST = class_2746.method_11825((String)"east");
    public static final class_2746 SOUTH_EAST = class_2746.method_11825((String)"southeast");
    public static final class_2746 SOUTH = class_2746.method_11825((String)"south");
    public static final class_2746 SOUTH_WEST = class_2746.method_11825((String)"southwest");
    public static final class_2746 WEST = class_2746.method_11825((String)"west");
    public static final class_2746 NORTH_WEST = class_2746.method_11825((String)"northwest");
    public static final Map<class_2680, class_265> SHAPES = new HashMap<class_2680, class_265>();

    public BlockPlanter() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15976).method_22488().method_50012(class_3619.field_15975).method_9640().method_9632(2.0f).method_9626(class_2498.field_11544).method_29292().method_9631(BlockPlanter::getLightValue));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(SOIL, (Comparable)((Object)SoilType.NONE))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH_EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH_EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH_WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH_WEST, (Comparable)Boolean.valueOf(false)));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> TerraqueousClient.colorize(this));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SOIL, NORTH, NORTH_EAST, EAST, SOUTH_EAST, SOUTH, SOUTH_WEST, WEST, NORTH_WEST});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityPlanter(pos, state);
    }

    private TileEntityPlanter getTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityPlanter ? (TileEntityPlanter)tile : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(SOIL) == SoilType.NONE || ((SoilType)((Object)state.method_11654(SOIL))).isFluid()) {
            if (!SHAPES.containsKey(state)) {
                class_265 shape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
                if (!((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
                    shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)0.0, (double)1.5, (double)0.0, (double)16.0, (double)16.0, (double)1.5));
                }
                if (!((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
                    shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)0.0, (double)1.5, (double)14.5, (double)16.0, (double)16.0, (double)16.0));
                }
                if (!((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
                    shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)14.5, (double)1.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                }
                if (!((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
                    shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)0.0, (double)1.5, (double)0.0, (double)1.5, (double)16.0, (double)16.0));
                }
                SHAPES.put(state, shape);
            }
            if (SHAPES.containsKey(state)) {
                return SHAPES.get(state);
            }
        }
        return super.method_9530(state, world, pos, context);
    }

    public class_2680 method_9605(class_1750 context) {
        return this.getConnections(this.method_9564(), (class_1936)context.method_8045(), context.method_8037());
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        class_2680 updated = this.getConnections(state, (class_1936)world, pos);
        if (state != updated) {
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)updated, (boolean)true);
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        TileEntityPlanter tile = this.getTile((class_1922)world, pos);
        if (tile != null && stack.method_7909() instanceof ItemBlockRGB) {
            tile.setRGB16(((ItemBlockRGB)stack.method_7909()).getRGB16(stack), placer instanceof class_1657 ? (class_1657)placer : null);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 currentPos, class_2338 facingPos) {
        return this.getConnections(state, world, currentPos);
    }

    private class_2680 getConnections(class_2680 state, class_1936 world, class_2338 pos) {
        class_2680 result = state;
        class_2338 north = pos.method_10095();
        class_2338 south = pos.method_10072();
        result = (class_2680)result.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, world, north)));
        result = (class_2680)result.method_11657((class_2769)NORTH_EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, north.method_10078())));
        result = (class_2680)result.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos.method_10078())));
        result = (class_2680)result.method_11657((class_2769)SOUTH_EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, south.method_10078())));
        result = (class_2680)result.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, world, south)));
        result = (class_2680)result.method_11657((class_2769)SOUTH_WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, south.method_10067())));
        result = (class_2680)result.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos.method_10067())));
        result = (class_2680)result.method_11657((class_2769)NORTH_WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, north.method_10067())));
        return result;
    }

    private boolean canConnect(class_2680 state, class_1936 world, class_2338 pos) {
        SoilType soil = (SoilType)((Object)state.method_11654(SOIL));
        if (soil == SoilType.TOOLS) {
            return false;
        }
        class_2680 oState = world.method_8320(pos);
        if (oState.method_26204() == this) {
            SoilType oSoil = (SoilType)((Object)oState.method_11654(SOIL));
            return oSoil != SoilType.TOOLS && (!soil.isFluid() && !oSoil.isFluid() || soil == oSoil);
        }
        return false;
    }

    public static int getLightValue(class_2680 state) {
        return state.method_11654(SOIL) == SoilType.LAVA ? class_3612.field_15908.method_15785().method_15759().method_26213() : 0;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.field_9236) {
            class_2338 up = pos.method_10084();
            world.method_8320(up).method_26199(world, up, random);
        }
    }

    public boolean canSustainPlant(class_2680 state, class_1922 world, class_2338 pos, class_2350 facing, IPlantable plantable) {
        if (facing == class_2350.field_11036) {
            return ((SoilType)((Object)state.method_11654(BlockPlanter.SOIL))).supportedPlantTypes.contains(plantable.getPlantType(world, pos.method_10093(facing)));
        }
        return false;
    }

    public boolean isFertile(class_2680 state, class_1922 world, class_2338 pos) {
        return state.method_11654(SOIL) == SoilType.FARMLAND;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        TileEntityPlanter tile = this.getTile((class_1922)world, pos);
        if (tile == null || player == null) {
            return class_1269.field_5814;
        }
        class_1799 heldStack = player.method_5998(hand);
        SoilType soilType = (SoilType)((Object)state.method_11654(SOIL));
        if (heldStack.method_7960()) {
            if (soilType != SoilType.NONE && !soilType.isFluid()) {
                if (!player.method_31549().field_7477) {
                    Function.giveItem((class_1657)player, (class_1799)tile.getSoilBlock());
                }
                tile.setSoilBlock(class_1799.field_8037);
                world.method_8652(pos, (class_2680)state.method_11657(SOIL, (Comparable)((Object)SoilType.NONE)), 3);
                soilType.playSound(world, pos, player, false);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (soilType == SoilType.DIRT && ToolHelper.isHoe((class_1799)heldStack)) {
            world.method_8652(pos, (class_2680)state.method_11657(SOIL, (Comparable)((Object)SoilType.FARMLAND)), 3);
            soilType.playSound(world, pos, player, false);
            return class_1269.field_5812;
        }
        class_1792 class_17922 = heldStack.method_7909();
        if (class_17922 instanceof BucketItemAccessor) {
            BucketItemAccessor bucket = (BucketItemAccessor)class_17922;
            if (soilType.isFluid()) {
                if (bucket.fabric_getFluid() == class_3612.field_15906) {
                    if (!player.method_31549().field_7477) {
                        heldStack.method_7934(1);
                        Function.giveItem((class_1657)player, (class_1799)new class_1799((class_1935)soilType.fluid.method_15774()));
                    }
                    int otherSources = 0;
                    if (soilType == SoilType.WATER && Terraqueous.CONFIG.COMMON.TWEAKS.planter_infinite_water) {
                        for (class_2350 direction : class_2350.class_2353.field_11062) {
                            class_2680 oState = world.method_8320(pos.method_10093(direction));
                            if (!(oState.method_26204() instanceof BlockPlanter) || oState.method_11654(SOIL) != SoilType.WATER) continue;
                            ++otherSources;
                        }
                    }
                    if (otherSources < 2) {
                        tile.setSoilFluid(class_3612.field_15906);
                        world.method_8652(pos, (class_2680)state.method_11657(SOIL, (Comparable)((Object)SoilType.NONE)), 3);
                    }
                    soilType.playSound(world, pos, player, false);
                    return class_1269.field_5812;
                }
            } else {
                class_3611 fluid = bucket.fabric_getFluid();
                if (fluid == class_3612.field_15908 || fluid == class_3612.field_15910) {
                    if (!player.method_31549().field_7477) {
                        heldStack.method_7934(1);
                        Function.giveItem((class_1657)player, (class_1799)class_1755.method_7732((class_1799)heldStack, (class_1657)player));
                    }
                    tile.setSoilFluid(fluid);
                    SoilType newSoilType = fluid == class_3612.field_15908 ? SoilType.LAVA : SoilType.WATER;
                    world.method_8652(pos, (class_2680)state.method_11657(SOIL, (Comparable)((Object)newSoilType)), 3);
                    newSoilType.playSound(world, pos, player, true);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        }
        boolean isSpade = ToolHelper.isShovel((class_1799)heldStack);
        if (heldStack.method_7909() instanceof class_1747 && !(((class_1747)heldStack.method_7909()).method_7711() instanceof IPlantable) || isSpade) {
            SoilType newSoilType = SoilType.NONE;
            if (isSpade) {
                newSoilType = SoilType.TOOLS;
            } else {
                class_2248 block = ((class_1747)heldStack.method_7909()).method_7711();
                if (TagHelper.isBlockInTag((class_2248)block, (class_6862)class_3481.field_29822)) {
                    newSoilType = SoilType.DIRT;
                } else if (TagHelper.isBlockInTag((class_2248)block, Tags.Blocks.FARMLAND)) {
                    newSoilType = SoilType.FARMLAND;
                } else if (TagHelper.isBlockInTag((class_2248)block, Tags.Blocks.SAND)) {
                    newSoilType = SoilType.SAND;
                } else if (TagHelper.isBlockInTag((class_2248)block, Tags.Blocks.GRAVEL)) {
                    newSoilType = SoilType.GRAVEL;
                } else if (TagHelper.isBlockInTag((class_2248)block, Tags.Blocks.SAND_SOUL)) {
                    newSoilType = SoilType.SOULSAND;
                } else if (TagHelper.isBlockInTag((class_2248)block, Tags.Blocks.END_STONE)) {
                    newSoilType = SoilType.ENDSTONE;
                }
            }
            if (newSoilType != SoilType.NONE) {
                if (player.method_31549().field_7477) {
                    tile.setSoilBlock(heldStack.method_7972().method_7971(1));
                } else {
                    class_1799 itemStack = tile.getSoilBlock();
                    if (!itemStack.method_7960()) {
                        Function.giveItem((class_1657)player, (class_1799)itemStack);
                    }
                    tile.setSoilBlock(heldStack.method_7972().method_7971(1));
                    heldStack.method_7934(1);
                }
                world.method_8652(pos, (class_2680)state.method_11657(SOIL, (Comparable)((Object)newSoilType)), 3);
                newSoilType.playSound(world, pos, player, true);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public boolean recolorBlock(class_2680 state, class_1936 world, class_2338 pos, class_1657 player, class_1268 hand, class_2350 side, class_243 hitVec, String dyeName) {
        TileEntityPlanter tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((class_1922)world, pos)) != null) {
            if (!world.method_8608()) {
                if (player == null) {
                    tile.getRGB16(null).setValues(dyeName);
                } else {
                    tile.getRGB16(player).recolor(player, dyeName);
                }
                Function.syncTile((class_2586)tile);
            }
            if (player != null) {
                player.method_6104(hand);
            }
            return true;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (data.world != null && data.pos != null) {
            if (index == 0) {
                TileEntityPlanter tile = this.getTile((class_1922)data.world, data.pos);
                if (tile != null) {
                    return tile.getRGB16(null).getColor();
                }
            } else if (index == 1 && data.state != null && data.state.method_11654(SOIL) == SoilType.WATER) {
                return class_1163.method_4961((class_1920)data.world, (class_2338)data.pos);
            }
        }
        return 0xFFFFFF;
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        if (((SoilType)((Object)state.method_11654(SOIL))).isFluid()) {
            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((SoilType)((Object)state.method_11654(BlockPlanter.SOIL))).fluid.method_15785().method_15759(), (boolean)true);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_1799 soilStack;
        List drops = super.method_9560(state, builder);
        class_2586 builderTile = (class_2586)builder.method_51876(class_181.field_1228);
        if (builderTile instanceof TileEntityPlanter && !(soilStack = ((TileEntityPlanter)builderTile).getPickBlock(false)).method_7960()) {
            drops.add(soilStack);
        }
        return drops;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = new class_1799((class_1935)this);
        TileEntityPlanter tile = this.getTile(world, pos);
        if (tile != null) {
            RGB16StackHelper.setRGB16((class_1799)stack, (RGB16)tile.getRGB16(null));
        }
        return stack;
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 world, class_2338 pos, class_1657 player, class_239 result) {
        class_1799 stack;
        TileEntityPlanter tile;
        if (player != null && player.method_5715() && (tile = this.getTile(world, pos)) != null && !(stack = tile.getPickBlock(true)).method_7960()) {
            return stack;
        }
        return this.method_9574(world, pos, state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)NORTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)NORTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_EAST)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)NORTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)NORTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_EAST)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)NORTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_EAST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)SOUTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)NORTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_WEST)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_WEST)))).method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)NORTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_EAST)))).method_11657((class_2769)SOUTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_EAST)));
            case class_2415.field_11301 -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH_EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_WEST)))).method_11657((class_2769)NORTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH_EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)SOUTH_WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH_EAST)));
            default -> super.method_9569(state, mirror);
        };
    }

    public static enum SoilType implements class_3542
    {
        NONE("none", class_2246.field_10124, new IPlantable.Type[]{null}),
        TOOLS("tools", class_2246.field_10124, new IPlantable.Type[]{null}),
        DIRT("dirt", class_2246.field_10566, IPlantable.Type.PLAINS, IPlantable.Type.BEACH, IPlantable.Type.CAVE),
        FARMLAND("farmland", class_2246.field_10362, IPlantable.Type.CROP),
        SAND("sand", class_2246.field_10102, IPlantable.Type.DESERT, IPlantable.Type.BEACH, IPlantable.Type.CAVE),
        GRAVEL("gravel", class_2246.field_10255, IPlantable.Type.DESERT, IPlantable.Type.BEACH, IPlantable.Type.CAVE),
        SOULSAND("soulsand", class_2246.field_10114, IPlantable.Type.NETHER),
        ENDSTONE("endstone", class_2246.field_10471, IPlantable.Type.END),
        WATER("water", class_3612.field_15910, IPlantable.Type.WATER),
        LAVA("lava", class_3612.field_15908, IPlantable.Type.LAVA);

        private final String name;
        private final List<IPlantable.Type> supportedPlantTypes;
        private final class_2248 block;
        private final class_3611 fluid;

        private SoilType(String name, Object object, IPlantable.Type ... plant) {
            this.name = name;
            this.supportedPlantTypes = plant == null ? Collections.emptyList() : (plant.length == 1 ? Collections.singletonList(plant[0]) : Arrays.asList(plant));
            if (object instanceof class_2248) {
                this.block = (class_2248)object;
                this.fluid = null;
            } else if (object instanceof class_3611) {
                this.block = null;
                this.fluid = (class_3611)object;
            } else {
                this.block = null;
                this.fluid = null;
            }
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean isFluid() {
            return this == WATER || this == LAVA;
        }

        public void playSound(class_1937 world, class_2338 pos, class_1657 player, boolean place) {
            if (this != NONE) {
                class_3414 soundEvent = null;
                if (this == TOOLS) {
                    soundEvent = class_3417.field_15191;
                } else if (this.isFluid() && this.fluid != null) {
                    soundEvent = this == LAVA ? (place ? class_3417.field_15202 : class_3417.field_15010) : (place ? class_3417.field_15126 : class_3417.field_14834);
                } else if (!this.isFluid() && this.block != null) {
                    class_3414 class_34142 = soundEvent = place ? this.block.method_9564().method_26231().method_10598() : this.block.method_9564().method_26231().method_10595();
                }
                if (soundEvent != null) {
                    world.method_8396(player, pos, soundEvent, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                }
            }
        }

        public class_1799 getItem() {
            if (this == NONE) {
                return class_1799.field_8037;
            }
            if (this == TOOLS) {
                return new class_1799((class_1935)class_1802.field_8776);
            }
            if (this.isFluid()) {
                return new class_1799((class_1935)this.fluid.method_15774());
            }
            return new class_1799((class_1935)this.block.method_8389());
        }
    }
}

