/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2526;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.worldgen.BiomeHelper;

public class BlockTallGrass
extends class_2526
implements IColored {
    public BlockTallGrass() {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10214).method_9640().method_16228(class_2246.field_10479));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            TerraqueousClient.colorize(this);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581());
        });
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_8608() || !world.method_8530()) {
            return;
        }
        if (PlantFunctions.canSpread((class_1937)world, pos, PlantAPI.Plant.GRASS) && Function.getBlockDown((class_1922)world, (class_2338)pos) != Roster.Blocks.PLANTER) {
            this.spreadGrass((class_1937)world, pos, state, random);
        } else if (PlantFunctions.canGrow((class_1937)world, pos, PlantAPI.Plant.GRASS)) {
            super.method_9652(world, random, pos, state);
        }
    }

    private void spreadGrass(class_1937 world, class_2338 pos, class_2680 state, class_5819 random) {
        byte maxAttempts = PlantFunctions.getMaxPlacementAttempts((class_1922)world, pos, PlantAPI.Plant.GRASS);
        byte[] spreadRadius = PlantFunctions.getSpreadRadius((class_1922)world, pos, PlantAPI.Plant.GRASS);
        for (byte attempt = 0; attempt < maxAttempts; attempt = (byte)(attempt + 1)) {
            class_2338 sPos = pos.method_10069(this.getOffset(spreadRadius[0], random), this.getOffset(spreadRadius[1], random), this.getOffset(spreadRadius[0], random));
            class_2680 sState = world.method_8320(sPos);
            if (sState.method_26215() && this.method_9558(sState, (class_4538)world, sPos) && this.canSpreadHere(world, sPos)) {
                Function.setBlock((class_1945)world, (class_2338)sPos, (class_2680)state, (boolean)true);
                return;
            }
            pos = sPos;
        }
    }

    private int getOffset(int spreadRadius, class_5819 random) {
        return random.method_43048(spreadRadius) - random.method_43048(spreadRadius);
    }

    private boolean canSpreadHere(class_1937 world, class_2338 pos) {
        if (Function.getBlockDown((class_1922)world, (class_2338)pos) == Roster.Blocks.PLANTER) {
            return false;
        }
        int touching = 0;
        int total = 0;
        int air = 0;
        for (int sX = -1; sX < 2; ++sX) {
            for (int sZ = -1; sZ < 2; ++sZ) {
                if (sX == 0 && sZ == 0) continue;
                class_2338 sPos = pos.method_10069(sX, 0, sZ);
                if (world.method_8320(sPos).method_26204() == this) {
                    total = (byte)(total + 1);
                    if (sX == 0 || sZ == 0) {
                        touching = (byte)(touching + 1);
                    }
                }
                if (!world.method_22347(sPos)) continue;
                air = (byte)(air + 1);
            }
        }
        return touching < 2 && total < 2 && air > 4;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (Function.getBlockDown((class_1922)world, (class_2338)pos) == Roster.Blocks.PLANTER) {
            return true;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        if (BiomeHelper.isFreezing(biome) || biome.method_48162(pos) == class_1959.class_1963.field_9383) {
            return false;
        }
        return Function.getBlockDown((class_1922)world, (class_2338)pos) != class_2246.field_10362 && super.method_9558(state, world, pos);
    }

    protected boolean method_9695(class_2680 state, class_1922 world, class_2338 pos) {
        return TagHelper.isBlockInTag((class_2680)state, (class_6862)class_3481.field_29822) || state.method_26204() == class_2246.field_10219 || state.method_26204() == Roster.Blocks.PLANTER;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)class_1792.method_7867((class_2248)class_2246.field_10214));
    }

    @Environment(value=EnvType.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        return class_310.method_1551().method_1505().method_1697(class_2246.field_10214.method_9564(), data.world, data.pos, index);
    }
}

