/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import shetiphian.core.common.TagHelper;

public abstract class BlockWall
extends class_2248
implements class_3737 {
    public static final class_2754<PostHeight> POST_HEIGHT = class_2754.method_11850((String)"post", PostHeight.class);
    public static final class_2754<class_4778> WALL_HEIGHT_EAST = class_2741.field_22174;
    public static final class_2754<class_4778> WALL_HEIGHT_NORTH = class_2741.field_22175;
    public static final class_2754<class_4778> WALL_HEIGHT_SOUTH = class_2741.field_22176;
    public static final class_2754<class_4778> WALL_HEIGHT_WEST = class_2741.field_22177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final Map<class_2680, class_265> stateToShapeMap;
    private final Map<class_2680, class_265> stateToCollisionShapeMap;
    private static final class_265 CENTER_POLE_SHAPE = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);

    public BlockWall(class_4970.class_2251 settings, float postWidth, float postHeightLow, float postHeightTall, float extensionWidth, float extMinY, float extMaxYLow, float extMaxYTall) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(POST_HEIGHT, (Comparable)((Object)PostHeight.NORMAL))).method_11657(WALL_HEIGHT_NORTH, (Comparable)class_4778.field_22178)).method_11657(WALL_HEIGHT_EAST, (Comparable)class_4778.field_22178)).method_11657(WALL_HEIGHT_SOUTH, (Comparable)class_4778.field_22178)).method_11657(WALL_HEIGHT_WEST, (Comparable)class_4778.field_22178)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.stateToShapeMap = this.makeShapes(postWidth, postHeightLow, postHeightTall, extensionWidth, extMinY, extMaxYLow, extMaxYTall);
        float heightLow = Math.max(postHeightLow, extMaxYLow) * 1.5f;
        float heightTall = Math.max(postHeightTall, extMaxYTall) * 1.5f;
        this.stateToCollisionShapeMap = this.makeShapes(postWidth, heightLow, heightTall, extensionWidth, extMinY, heightLow, heightTall);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POST_HEIGHT, WALL_HEIGHT_NORTH, WALL_HEIGHT_EAST, WALL_HEIGHT_WEST, WALL_HEIGHT_SOUTH, WATERLOGGED});
    }

    protected Map<class_2680, class_265> makeShapes(float postWidth, float postHeightLow, float postHeightTall, float extWidth, float extMinY, float extMaxYLow, float extMaxYTall) {
        float postMinXZ = 8.0f - postWidth;
        float postMaxXZ = 8.0f + postWidth;
        float extMinXZ = 8.0f - extWidth;
        float extMaxXZ = 8.0f + extWidth;
        class_265 shapePostLow = class_2248.method_9541((double)postMinXZ, (double)0.0, (double)postMinXZ, (double)postMaxXZ, (double)postHeightLow, (double)postMaxXZ);
        class_265 shapePostTall = class_2248.method_9541((double)postMinXZ, (double)0.0, (double)postMinXZ, (double)postMaxXZ, (double)postHeightTall, (double)postMaxXZ);
        class_265 shapeNorthLow = class_2248.method_9541((double)extMinXZ, (double)extMinY, (double)0.0, (double)extMaxXZ, (double)extMaxYLow, (double)extMaxXZ);
        class_265 shapeSouthLow = class_2248.method_9541((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYLow, (double)16.0);
        class_265 shapeWestLow = class_2248.method_9541((double)0.0, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYLow, (double)extMaxXZ);
        class_265 shapeEastLow = class_2248.method_9541((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)16.0, (double)extMaxYLow, (double)extMaxXZ);
        class_265 shapeNorthTall = class_2248.method_9541((double)extMinXZ, (double)extMinY, (double)0.0, (double)extMaxXZ, (double)extMaxYTall, (double)extMaxXZ);
        class_265 shapeSouthTall = class_2248.method_9541((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYTall, (double)16.0);
        class_265 shapeWestTall = class_2248.method_9541((double)0.0, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYTall, (double)extMaxXZ);
        class_265 shapeEastTall = class_2248.method_9541((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)16.0, (double)extMaxYTall, (double)extMaxXZ);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PostHeight postHeight : POST_HEIGHT.method_11898()) {
            for (class_4778 eastHeight : WALL_HEIGHT_EAST.method_11898()) {
                for (class_4778 northHeight : WALL_HEIGHT_NORTH.method_11898()) {
                    for (class_4778 westHeight : WALL_HEIGHT_WEST.method_11898()) {
                        for (class_4778 southHeight : WALL_HEIGHT_SOUTH.method_11898()) {
                            class_265 baseShape = class_259.method_1073();
                            baseShape = class_259.method_1084((class_265)baseShape, (class_265)(postHeight == PostHeight.NORMAL ? shapePostLow : shapePostTall));
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, eastHeight, shapeEastLow, shapeEastTall);
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, westHeight, shapeWestLow, shapeWestTall);
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, northHeight, shapeNorthLow, shapeNorthTall);
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, southHeight, shapeSouthLow, shapeSouthTall);
                            class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(POST_HEIGHT, (Comparable)((Object)postHeight))).method_11657(WALL_HEIGHT_EAST, (Comparable)eastHeight)).method_11657(WALL_HEIGHT_WEST, (Comparable)westHeight)).method_11657(WALL_HEIGHT_NORTH, (Comparable)northHeight)).method_11657(WALL_HEIGHT_SOUTH, (Comparable)southHeight);
                            builder.put((Object)((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)baseShape);
                            builder.put((Object)((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)baseShape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private static class_265 getHeightAlteredShape(class_265 baseShape, class_4778 height, class_265 lowShape, class_265 tallShape) {
        if (height == class_4778.field_22180) {
            return class_259.method_1084((class_265)baseShape, (class_265)tallShape);
        }
        return height == class_4778.field_22179 ? class_259.method_1084((class_265)baseShape, (class_265)lowShape) : baseShape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.stateToShapeMap.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return this.stateToCollisionShapeMap.get(state);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    protected boolean shouldConnect(class_2680 state, boolean isSideSolid, class_2350 direction) {
        class_2248 block = state.method_26204();
        boolean flag = block instanceof class_2349 && class_2349.method_16703((class_2680)state, (class_2350)direction);
        return TagHelper.isBlockInTag((class_2680)state, (class_6862)class_3481.field_15504) || !BlockWall.method_9581((class_2680)state) && isSideSolid || block instanceof class_2389 || flag;
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_3610 fluidState = world.method_8316(pos);
        class_2338 nPos = pos.method_10095();
        class_2338 ePos = pos.method_10078();
        class_2338 sPos = pos.method_10072();
        class_2338 wPos = pos.method_10067();
        class_2338 uPos = pos.method_10084();
        class_2680 nState = world.method_8320(nPos);
        class_2680 eState = world.method_8320(ePos);
        class_2680 sState = world.method_8320(sPos);
        class_2680 wState = world.method_8320(wPos);
        class_2680 uState = world.method_8320(uPos);
        boolean nConnect = this.shouldConnect(nState, nState.method_26206((class_1922)world, nPos, class_2350.field_11035), class_2350.field_11035);
        boolean eConnect = this.shouldConnect(eState, eState.method_26206((class_1922)world, ePos, class_2350.field_11039), class_2350.field_11039);
        boolean sConnect = this.shouldConnect(sState, sState.method_26206((class_1922)world, sPos, class_2350.field_11043), class_2350.field_11043);
        boolean wConnect = this.shouldConnect(wState, wState.method_26206((class_1922)world, wPos, class_2350.field_11034), class_2350.field_11034);
        class_2680 myState = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        return this.getConnectedState((class_1936)world, myState, uPos, uState, nConnect, eConnect, sConnect, wConnect);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction == class_2350.field_11033) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        return direction == class_2350.field_11036 ? this.topUpdate(world, state, neighborPos, neighborState) : this.sideUpdate(world, pos, state, neighborPos, neighborState, direction);
    }

    private static boolean hasHeightForProperty(class_2680 state, class_2754<class_4778> heightProperty) {
        return state.method_11654(heightProperty) != class_4778.field_22178;
    }

    private class_2680 topUpdate(class_1936 world, class_2680 myState, class_2338 uPos, class_2680 uState) {
        boolean nConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_NORTH);
        boolean eConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_EAST);
        boolean sConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_SOUTH);
        boolean wConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_WEST);
        return this.getConnectedState(world, myState, uPos, uState, nConnect, eConnect, sConnect, wConnect);
    }

    private class_2680 sideUpdate(class_1936 world, class_2338 pos, class_2680 myState, class_2338 facingPos, class_2680 facingState, class_2350 face) {
        class_2350 direction = face.method_10153();
        boolean nConnect = face == class_2350.field_11043 ? this.shouldConnect(facingState, facingState.method_26206((class_1922)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_NORTH);
        boolean eConnect = face == class_2350.field_11034 ? this.shouldConnect(facingState, facingState.method_26206((class_1922)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_EAST);
        boolean sConnect = face == class_2350.field_11035 ? this.shouldConnect(facingState, facingState.method_26206((class_1922)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_SOUTH);
        boolean wConnect = face == class_2350.field_11039 ? this.shouldConnect(facingState, facingState.method_26206((class_1922)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_WEST);
        class_2338 uPos = pos.method_10084();
        class_2680 uState = world.method_8320(uPos);
        return this.getConnectedState(world, myState, uPos, uState, nConnect, eConnect, sConnect, wConnect);
    }

    private class_2680 getConnectedState(class_1936 world, class_2680 myState, class_2338 uPos, class_2680 uState, boolean nConnect, boolean eConnect, boolean sConnect, boolean wConnect) {
        PostHeight pHeight;
        class_4778 wHeight;
        class_4778 nHeight = nConnect ? class_4778.field_22179 : class_4778.field_22178;
        class_4778 eHeight = eConnect ? class_4778.field_22179 : class_4778.field_22178;
        class_4778 sHeight = sConnect ? class_4778.field_22179 : class_4778.field_22178;
        class_4778 class_47782 = wHeight = wConnect ? class_4778.field_22179 : class_4778.field_22178;
        if (uState.method_26204() == this) {
            nHeight = nConnect && uState.method_11654(WALL_HEIGHT_NORTH) != class_4778.field_22178 ? class_4778.field_22180 : nHeight;
            eHeight = eConnect && uState.method_11654(WALL_HEIGHT_EAST) != class_4778.field_22178 ? class_4778.field_22180 : eHeight;
            sHeight = sConnect && uState.method_11654(WALL_HEIGHT_SOUTH) != class_4778.field_22178 ? class_4778.field_22180 : sHeight;
            wHeight = wConnect && uState.method_11654(WALL_HEIGHT_WEST) != class_4778.field_22178 ? class_4778.field_22180 : wHeight;
            pHeight = PostHeight.TALL;
        } else {
            class_265 voxelshape = uState.method_26220((class_1922)world, uPos).method_20538(class_2350.field_11033);
            pHeight = TagHelper.isBlockInTag((class_2680)uState, (class_6862)class_3481.field_22276) || !class_259.method_1074((class_265)CENTER_POLE_SHAPE, (class_265)voxelshape, (class_247)class_247.field_16886) ? PostHeight.EXT : PostHeight.NORMAL;
        }
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)myState.method_11657(POST_HEIGHT, (Comparable)((Object)pHeight))).method_11657(WALL_HEIGHT_NORTH, (Comparable)nHeight)).method_11657(WALL_HEIGHT_EAST, (Comparable)eHeight)).method_11657(WALL_HEIGHT_SOUTH, (Comparable)sHeight)).method_11657(WALL_HEIGHT_WEST, (Comparable)wHeight);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(WALL_HEIGHT_NORTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_SOUTH)))).method_11657(WALL_HEIGHT_EAST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_WEST)))).method_11657(WALL_HEIGHT_SOUTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_NORTH)))).method_11657(WALL_HEIGHT_WEST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_EAST)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(WALL_HEIGHT_NORTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_EAST)))).method_11657(WALL_HEIGHT_EAST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_SOUTH)))).method_11657(WALL_HEIGHT_SOUTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_WEST)))).method_11657(WALL_HEIGHT_WEST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_NORTH)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(WALL_HEIGHT_NORTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_WEST)))).method_11657(WALL_HEIGHT_EAST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_NORTH)))).method_11657(WALL_HEIGHT_SOUTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_EAST)))).method_11657(WALL_HEIGHT_WEST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_SOUTH)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657(WALL_HEIGHT_NORTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_SOUTH)))).method_11657(WALL_HEIGHT_SOUTH, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_NORTH)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657(WALL_HEIGHT_EAST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_WEST)))).method_11657(WALL_HEIGHT_WEST, (Comparable)((class_4778)state.method_11654(WALL_HEIGHT_EAST)));
            default -> super.method_9569(state, mirror);
        };
    }

    public static enum PostHeight implements class_3542
    {
        NORMAL("normal"),
        TALL("tall"),
        EXT("ext");

        private final String name;

        private PostHeight(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

