/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity.ai;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_7923;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.misc.ConfiguredItemListUtil;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

public class TaskFlowerPotUpdate
extends class_4097<class_1646> {
    private static class_6005<class_1792> PLANTS = null;
    private class_2338 posFlowerPot;
    private long taskCooldown;
    private int idleTime;

    public TaskFlowerPotUpdate() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18439, (Object)class_4141.field_18456, (Object)class_4140.field_18446, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean shouldRun(class_3218 world, class_1646 villager) {
        class_2338 pos;
        class_2586 tileEntity;
        class_5321 dimensionKey = world.method_27983();
        class_2338 villagerPosition = villager.method_24515();
        ArrayList list = Lists.newArrayList();
        int range = 8;
        for (int x = -range; x <= range; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 pos2 = villagerPosition.method_10069(x, y, z);
                    class_2248 block = world.method_8320(pos2).method_26204();
                    if (!(block instanceof BlockFlowerPot)) continue;
                    list.add(class_4208.method_19443((class_5321)dimensionKey, (class_2338)pos2));
                }
            }
        }
        if (!list.isEmpty() && (tileEntity = world.method_8321(pos = ((class_4208)list.get(world.field_9229.method_43048(list.size()))).method_19446())) instanceof TileEntityFlowerPot && this.canUpdateFlowerPot((TileEntityFlowerPot)tileEntity, world.method_8510())) {
            this.posFlowerPot = pos;
            return true;
        }
        return false;
    }

    protected void run(class_3218 world, class_1646 villager, long gameTime) {
        if (gameTime > this.taskCooldown && this.posFlowerPot != null) {
            villager.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.posFlowerPot));
            villager.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142((class_4115)new class_4099(this.posFlowerPot), 0.5f, 1));
        }
    }

    protected void finishRunning(class_3218 world, class_1646 villager, long gameTime) {
        villager.method_18868().method_18875(class_4140.field_18446);
        villager.method_18868().method_18875(class_4140.field_18445);
        this.idleTime = 0;
        this.taskCooldown = gameTime + 40L;
    }

    private boolean canUpdateFlowerPot(TileEntityFlowerPot flowerPot, long gameTime) {
        return flowerPot.getPlantStack().method_7960() || flowerPot.getVillagerPlantTimer() > 0L && flowerPot.getVillagerPlantTimer() < gameTime;
    }

    protected void keepRunning(class_3218 world, class_1646 villager, long gameTime) {
        if (this.posFlowerPot == null || this.posFlowerPot.method_19769((class_2374)villager.method_19538(), 1.73)) {
            if (this.posFlowerPot != null && gameTime > this.taskCooldown) {
                class_1792 plant;
                TileEntityFlowerPot flowerPot;
                villager.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.posFlowerPot));
                class_2586 tileEntity = world.method_8321(this.posFlowerPot);
                if (tileEntity instanceof TileEntityFlowerPot && this.canUpdateFlowerPot(flowerPot = (TileEntityFlowerPot)tileEntity, gameTime) && (plant = this.getPlant(world.field_9229)) != null) {
                    flowerPot.setPlantStack(new class_1799((class_1935)plant));
                    flowerPot.setVillagerPlantTimer(gameTime + 40L);
                    Function.syncTile((class_2586)flowerPot);
                    world.method_8396(null, this.posFlowerPot, class_3417.field_14653, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                    this.posFlowerPot = null;
                }
            }
            ++this.idleTime;
        }
    }

    protected boolean shouldKeepRunning(class_3218 world, class_1646 villager, long gameTime) {
        return this.idleTime < 200;
    }

    private class_1792 getPlant(class_5819 random) {
        if (PLANTS == null || Values.rebuildGardnerList) {
            class_6005.class_6006 builder = class_6005.method_34971();
            Map<String, String> items = ConfiguredItemListUtil.generateItemList("village gardner", Terraqueous.CONFIG.COMMON.TWEAKS.VILLAGER.gardner_whitelist, Terraqueous.CONFIG.COMMON.TWEAKS.VILLAGER.gardner_blacklist);
            for (Map.Entry<String, String> entry : items.entrySet()) {
                try {
                    class_7923.field_41178.method_17966(new class_2960(entry.getKey())).ifPresent(item -> {
                        String value = (String)entry.getValue();
                        int weight = 1;
                        try {
                            weight = value.contains("-") ? Integer.parseInt(value.split("-")[0]) : Integer.parseInt(value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        builder.method_34975(item, weight);
                    });
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error adding item '" + entry.getKey() + "' to village gardner planting list; " + error);
                }
            }
            class_7923.field_41178.method_17966(new class_2960("minecraft:emerald")).ifPresent(emerald -> builder.method_34975(emerald, 1));
            PLANTS = builder.method_34974();
            Values.rebuildGardnerList = false;
        }
        return PLANTS.method_34973(random).orElse(null);
    }
}

