/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.StringUtil;
import shetiphian.core.common.item.IToolMode;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.common.block.BlockClouds;

public class ItemCloudStaff
extends class_1831
implements ITabFiller,
IToolMode,
FabricItem {
    private static final int BUCKET_VOLUME = 1000;
    private static final int maxCharge = 1024000;

    public ItemCloudStaff(class_1792.class_1793 settings) {
        super((class_1832)class_1834.field_8929, settings.method_7896(Roster.Items.CLOUD_STAFF));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> TerraqueousClient.addItemPredicate((class_1792)this, "mode", (stack, world, entity, seed) -> ItemCloudStaff.getEnumMode(stack).getValue()));
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        class_1799 stack = ItemCloudStaff.newTool(EnumMode.LIGHT, false);
        entries.method_45420(stack.method_7972());
        ItemCloudStaff.setFluidVolume(stack, 1024000);
        entries.method_45420(stack);
    }

    public static class_1799 newTool(EnumMode mode, boolean base_fill) {
        class_1799 stack = ItemCloudStaff.setType(new class_1799((class_1935)Roster.Items.CLOUD_STAFF), mode);
        if (base_fill) {
            ItemCloudStaff.setFluidVolume(stack, (int)(mode.getMultiplier() * 1000.0 * 8.0));
        }
        return stack;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        return CloudAPI.isCloud(state) ? this.method_8022().method_8027() : 1.0f;
    }

    @NotNull
    private static class_2487 getTag(@NotNull class_1799 stack) {
        class_2487 nbtTag = stack.method_7948();
        if (!nbtTag.method_10545("mode")) {
            nbtTag.method_10582("mode", EnumMode.LIGHT.toString());
        }
        return nbtTag;
    }

    public static EnumMode getEnumMode(class_1799 stack) {
        return EnumMode.byName(ItemCloudStaff.getTag(stack).method_10558("mode"));
    }

    private static class_1799 setType(class_1799 stack, EnumMode type) {
        ItemCloudStaff.getTag(stack).method_10582("mode", type.toString());
        return stack;
    }

    public boolean changeMode(class_1657 player, class_1799 stack, boolean reverse) {
        if (!stack.method_7960() && stack.method_7909() instanceof ItemCloudStaff) {
            ItemCloudStaff.setType(stack, ItemCloudStaff.getEnumMode(stack).next(reverse));
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1268 hand;
        class_1799 heldItem;
        class_1269 toolResult = class_1269.field_5811;
        class_1657 player = context.method_8036();
        if (player != null && !(heldItem = player.method_5998(hand = context.method_20287())).method_7960()) {
            class_2338 pos;
            class_2680 state;
            class_3965 raytraceresult;
            class_1937 world = context.method_8045();
            class_2350 facing = context.method_8038();
            int fluidVolume = ItemCloudStaff.getFluidVolume(heldItem);
            if (!player.method_5715() && fluidVolume + 1000 <= 1024000 && (raytraceresult = ItemCloudStaff.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345)) != null && raytraceresult.method_17783() == class_239.class_240.field_1332 && player.method_7343(raytraceresult.method_17777(), facing, heldItem) && (state = world.method_8320(pos = raytraceresult.method_17777())).method_26204() instanceof class_2263 && world.method_8316(pos).method_15772() == class_3612.field_15910 && ((class_2263)state.method_26204()).method_9700((class_1936)world, pos, state) != class_1799.field_8037) {
                player.method_5783(class_3417.field_15126, 1.0f, 1.0f);
                ItemCloudStaff.setFluidVolume(heldItem, fluidVolume + 1000);
                toolResult = class_1269.field_5812;
            }
            if (toolResult == class_1269.field_5811 && (player.method_31549().field_7477 || ItemCloudStaff.getBlockCount(heldItem) >= 1.0)) {
                EnumMode mode = ItemCloudStaff.getEnumMode(heldItem);
                class_2680 state2 = null;
                if (mode == EnumMode.VAPOR) {
                    state2 = Roster.Blocks.WATER_VAPOR.method_9564();
                } else {
                    CloudAPI.CloudType cloudType;
                    switch (mode) {
                        case LIGHT: {
                            CloudAPI.CloudType cloudType2 = CloudAPI.CloudType.LIGHT;
                            break;
                        }
                        case DENSE: {
                            CloudAPI.CloudType cloudType2 = CloudAPI.CloudType.DENSE;
                            break;
                        }
                        case STORM: {
                            CloudAPI.CloudType cloudType2 = CloudAPI.CloudType.STORM;
                            break;
                        }
                        default: {
                            CloudAPI.CloudType cloudType2 = cloudType = null;
                        }
                    }
                    if (cloudType != null) {
                        switch (cloudType) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case LIGHT: {
                                class_2680 class_26802 = Roster.Blocks.LIGHT_CLOUD.method_9564();
                                break;
                            }
                            case DENSE: {
                                class_2680 class_26802 = Roster.Blocks.DENSE_CLOUD.method_9564();
                                break;
                            }
                            case STORM: {
                                class_2680 class_26802 = state2 = Roster.Blocks.STORM_CLOUD.method_9564();
                            }
                        }
                    }
                }
                if (state2 != null && fluidVolume != 0) {
                    class_2338 pos2 = context.method_8037();
                    boolean placed = false;
                    if (pos2.method_10264() < 0 && pos2.method_10263() == 0 && pos2.method_10260() == 0) {
                        pos2 = this.getAirPos(player);
                        player.method_6104(hand);
                    } else {
                        pos2 = pos2.method_10093(facing);
                    }
                    if (world.method_22347(pos2) && player.method_7343(pos2, facing, heldItem)) {
                        world.method_8396(player, pos2, state2.method_26231().method_10598(), class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                        placed = Function.setBlock((class_1945)world, (class_2338)pos2, (class_2680)state2, (boolean)true);
                    }
                    if (placed) {
                        if (!player.method_31549().field_7477) {
                            ItemCloudStaff.setFluidVolume(heldItem, fluidVolume -= (int)(1000.0 * mode.getMultiplier()));
                        }
                        toolResult = class_1269.field_5812;
                    }
                }
            }
        }
        return toolResult;
    }

    private class_2338 getAirPos(class_1657 player) {
        int posX = 0;
        int posZ = 0;
        int camY = -class_3532.method_15357((double)((double)(player.method_36455() * 6.0f / 180.0f) + 0.5));
        int camX = class_3532.method_15357((double)((double)(player.method_36454() * 12.0f / 360.0f) + 0.5)) % 12;
        if (camY == 3 || camY == -3) {
            posX = 0;
            posZ = 0;
            camY = camY == 3 ? 2 : -2;
        } else {
            camX = camX < 0 ? (camX += 12) : camX;
            switch (camX) {
                case 11: {
                    ++posX;
                    posZ += 2;
                    break;
                }
                case 0: {
                    posX += 0;
                    posZ += 2;
                    break;
                }
                case 1: {
                    --posX;
                    posZ += 2;
                    break;
                }
                case 2: {
                    posX -= 2;
                    ++posZ;
                    break;
                }
                case 3: {
                    posX -= 2;
                    posZ += 0;
                    break;
                }
                case 4: {
                    posX -= 2;
                    --posZ;
                    break;
                }
                case 5: {
                    --posX;
                    posZ -= 2;
                    break;
                }
                case 6: {
                    posX += 0;
                    posZ -= 2;
                    break;
                }
                case 7: {
                    ++posX;
                    posZ -= 2;
                    break;
                }
                case 8: {
                    posX += 2;
                    --posZ;
                    break;
                }
                case 9: {
                    posX += 2;
                    posZ += 0;
                    break;
                }
                case 10: {
                    posX += 2;
                    ++posZ;
                }
            }
            if (camY == -2 || camY == 2) {
                int n = camX >= 2 && camX <= 4 ? posX + 1 : (posX = camX >= 8 && camX <= 10 ? posX - 1 : posX);
                posZ = camX >= 5 && camX <= 7 ? posZ + 1 : (camX <= 1 || camX == 11 ? posZ - 1 : posZ);
            }
        }
        int[] blockXZ = Function.getBlockXZ((double)player.method_23317(), (double)player.method_23321());
        return new class_2338(blockXZ[0] + posX, (int)player.method_23318() + camY + 1, blockXZ[1] + posZ);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 entity) {
        if (!stack.method_7960()) {
            int amount = 0;
            if (state.method_26204() instanceof BlockClouds) {
                amount = (int)Math.pow(4.0, ((BlockClouds)state.method_26204()).getCloud().ordinal()) * 1000;
            } else if (state.method_26204() == Roster.Blocks.WATER_VAPOR) {
                amount = 250;
            }
            if (amount > 0) {
                int fluidVolume = ItemCloudStaff.getFluidVolume(stack);
                fluidVolume = fluidVolume == 0 ? amount : (fluidVolume + amount <= 1024000 ? (fluidVolume += amount) : 0);
                if (fluidVolume != 0) {
                    if (!(entity instanceof class_1657) || !((class_1657)entity).method_31549().field_7477) {
                        ItemCloudStaff.setFluidVolume(stack, fluidVolume);
                    }
                    world.method_8650(pos, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)this.getDurabilityPercentage(stack) * 13.0f);
    }

    public double getDurabilityPercentage(class_1799 stack) {
        int fluidVolume = ItemCloudStaff.getFluidVolume(stack);
        return 1.0 - (double)fluidVolume / 1024000.0;
    }

    public int method_31571(class_1799 stack) {
        return 2122170;
    }

    public class_1799 getRecipeRemainder(class_1799 stack) {
        if (!stack.method_7960()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            int fluidVolume = ItemCloudStaff.getFluidVolume(stack);
            if (fluidVolume != 0) {
                ItemCloudStaff.setFluidVolume(stack, Math.max(fluidVolume -= (int)(mode.getMultiplier() * 1000.0 * 8.0), 0));
            }
        }
        return stack.method_7972();
    }

    private static int getFluidVolume(@NotNull class_1799 stack) {
        class_2487 nbtTag = ItemCloudStaff.getTag(stack);
        if (!nbtTag.method_10545("fluid_volume")) {
            return 0;
        }
        return nbtTag.method_10550("fluid_volume");
    }

    private static void setFluidVolume(@NotNull class_1799 stack, int fluidVolume) {
        class_2487 nbtTag = ItemCloudStaff.getTag(stack);
        if (fluidVolume < 1) {
            nbtTag.method_10551("fluid_volume");
        } else {
            nbtTag.method_10569("fluid_volume", fluidVolume);
        }
    }

    public static double getBlockCount(class_1799 stack) {
        double placeable = 0.0;
        if (!stack.method_7960()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            int fluidVolume = ItemCloudStaff.getFluidVolume(stack);
            double amount = fluidVolume == 0 ? 0.0 : (double)fluidVolume / 1000.0;
            placeable = amount / mode.getMultiplier();
            placeable = (double)((int)(placeable * 100.0)) / 100.0;
        }
        return placeable;
    }

    public static class_1799 extractBlocks(class_1799 stack, int maxCount, boolean execute) {
        if (!stack.method_7960() && maxCount > 0) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            int fluidVolume = ItemCloudStaff.getFluidVolume(stack);
            double amount = fluidVolume == 0 ? 0.0 : (double)fluidVolume / 1000.0;
            double placeable = amount / mode.getMultiplier();
            if ((placeable = (double)((int)(placeable * 100.0)) / 100.0) >= 1.0) {
                int count = Math.min((int)placeable, maxCount);
                if (execute) {
                    ItemCloudStaff.setFluidVolume(stack, fluidVolume -= (int)((double)count * mode.getMultiplier() * 1000.0));
                }
                return switch (mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case EnumMode.VAPOR -> new class_1799((class_1935)Roster.Items.WATER_VAPOR, count);
                    case EnumMode.LIGHT -> new class_1799((class_1935)Roster.Items.LIGHT_CLOUD, count);
                    case EnumMode.DENSE -> new class_1799((class_1935)Roster.Items.DENSE_CLOUD, count);
                    case EnumMode.STORM -> new class_1799((class_1935)Roster.Items.STORM_CLOUD, count);
                };
            }
        }
        return class_1799.field_8037;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 advanced) {
        if (!stack.method_7960()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            StringUtil.multiLineTooltip((String)class_1074.method_4662((String)"info.terraqueous.cloudstaff.placing", (Object[])new Object[]{class_1074.method_4662((String)mode.getTooltip(), (Object[])new Object[0]), ItemCloudStaff.getBlockCount(stack)}), tooltip);
            ADD_CHANGE_INSTRUCTIONS.accept(tooltip, StringUtil.translateAndComputeStyle((String)"info.terraqueous.mode_change.cloudstaff"));
        }
    }

    public static enum EnumMode {
        VAPOR(0, 0.25, "block.terraqueous.vapor_block"),
        LIGHT(1, 1.0, "block.terraqueous.light_cloud"),
        DENSE(2, 4.0, "block.terraqueous.dense_cloud"),
        STORM(3, 16.0, "block.terraqueous.storm_cloud");

        private final byte value;
        private final double multiplier;
        private final String tooltip;

        private EnumMode(int value, double multiplier, String tooltip) {
            this.value = (byte)value;
            this.multiplier = multiplier;
            this.tooltip = tooltip;
        }

        public byte getValue() {
            return this.value;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        private EnumMode next(boolean reverse) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case VAPOR -> {
                    if (reverse) {
                        yield STORM;
                    }
                    yield LIGHT;
                }
                case LIGHT -> {
                    if (reverse) {
                        yield VAPOR;
                    }
                    yield DENSE;
                }
                case DENSE -> {
                    if (reverse) {
                        yield LIGHT;
                    }
                    yield STORM;
                }
                case STORM -> reverse ? DENSE : VAPOR;
            };
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static EnumMode byName(String name) {
            if (!Strings.isNullOrEmpty((String)name)) {
                for (EnumMode mode : EnumMode.values()) {
                    if (!mode.toString().equals(name)) continue;
                    return mode;
                }
            }
            return VAPOR;
        }
    }
}

