/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2449;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_5703;
import net.minecraft.class_6862;
import net.minecraft.class_7126;
import net.minecraft.class_7268;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.StringUtil;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.item.IToolMode;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.common.item.HarvestList;
import shetiphian.terraqueous.common.item.IStackAwareDamage;
import shetiphian.terraqueous.common.misc.Tags;
import shetiphian.terraqueous.mixins.TA_OreBlock_Accessor;

public class ItemMultiTool
extends ItemToolWithDamageSource
implements ITabFiller,
IToolMode,
IStackAwareDamage {
    private static final Cache<class_1657, HarvestList> HARVEST_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public ItemMultiTool(class_1792.class_1793 settings) {
        super(3.0f, -1.0f, (class_1832)class_1834.field_8930, Roster.DamageSources.MULTITOOL, settings);
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> TerraqueousClient.addItemPredicate((class_1792)this, "mode", (stack, world, entity, seed) -> ItemMultiTool.getEnumType(stack).getValue()));
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        for (EnumType type : EnumType.values()) {
            entries.method_45420(ItemMultiTool.newTool(type));
        }
    }

    public static class_1799 newTool(EnumType type) {
        class_1799 stack = new class_1799((class_1935)Roster.Items.MULTITOOL);
        class_2487 nbt = stack.method_7948();
        nbt.method_10582("tool", type.toString());
        if (type == EnumType.BROKEN) {
            stack.method_7974(stack.method_7936());
        }
        return stack;
    }

    public static EnumType getEnumType(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("tool")) {
            nbt.method_10582("tool", EnumType.PICKAXE.toString());
        }
        return EnumType.byName(nbt.method_10558("tool"));
    }

    private class_1799 setType(class_1799 stack, EnumType type) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10582("tool", type.toString());
        return stack;
    }

    public boolean changeMode(class_1657 player, class_1799 stack, boolean reverse) {
        EnumType type;
        if (stack != null && stack.method_7909() instanceof ItemMultiTool && (type = ItemMultiTool.getEnumType(stack)) != EnumType.BROKEN) {
            this.setType(stack, type.next(reverse));
            return true;
        }
        return false;
    }

    public String method_7866(class_1799 stack) {
        return super.method_7876() + "." + ItemMultiTool.getEnumType(stack).toString();
    }

    private class_1792 getToolTypeItem(class_1799 stack) {
        return switch (ItemMultiTool.getEnumType(stack)) {
            case EnumType.AXE -> class_1802.field_8556;
            case EnumType.HOE -> class_1802.field_8527;
            case EnumType.PICKAXE -> class_1802.field_8377;
            case EnumType.SHOVEL -> class_1802.field_8250;
            case EnumType.WEAPON -> class_1802.field_8802;
            default -> class_1802.field_8600;
        };
    }

    private class_1799 getToolTypeStack(class_1799 stack) {
        return new class_1799((class_1935)this.getToolTypeItem(stack));
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        return this.getToolTypeItem(stack).method_7856(state);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        class_1799 tool = this.getToolTypeStack(stack);
        return tool.method_7909().method_7865(tool, state) * 1.5f;
    }

    public int method_7837() {
        return class_1834.field_8923.method_8026();
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return !repair.method_7960() && TagHelper.isItemInTag((class_1799)repair, (TagHelper.Check)TagHelper.Check.ANY, (Object[])new Object[]{Tags.Items.INGOTS_IRON, Tags.Items.GEMS_BURNIUM, Tags.Items.GEMS_ENDIMIUM});
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        return this.getToolTypeStack(stack).method_7926(slot);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1268 hand;
        class_1799 heldItem;
        class_1269 toolResult = class_1269.field_5811;
        class_1657 player = context.method_8036();
        if (player != null && !(heldItem = player.method_5998(hand = context.method_20287())).method_7960()) {
            class_1799 tool = this.getToolTypeStack(heldItem);
            class_2350 direction = context.method_8038();
            class_2338 pos = context.method_8037().method_10093(context.method_8038().method_10153());
            if (player.method_5715() || ItemMultiTool.getEnumType(heldItem) == EnumType.AXE) {
                toolResult = tool.method_7909().method_7884((class_1838)new UseContext(context.method_8045(), player, hand, tool, Function.fakeMOP((class_2338)pos, (class_2350)direction)));
            } else {
                class_2338.class_2339 sPos = new class_2338.class_2339();
                for (int row = -1; row < 2; row = (int)((byte)(row + 1))) {
                    for (int col = -1; col < 2; col = (int)((byte)(col + 1))) {
                        if (row == 0 && col == 0) {
                            sPos.method_10103(pos.method_10263(), pos.method_10264(), pos.method_10260());
                        } else {
                            switch (direction) {
                                case field_11033: 
                                case field_11036: {
                                    sPos.method_10103(pos.method_10263() + row, pos.method_10264(), pos.method_10260() + col);
                                    break;
                                }
                                case field_11043: 
                                case field_11035: {
                                    sPos.method_10103(pos.method_10263() + row, pos.method_10264() + col, pos.method_10260());
                                    break;
                                }
                                case field_11034: 
                                case field_11039: {
                                    sPos.method_10103(pos.method_10263(), pos.method_10264() + row, pos.method_10260() + col);
                                }
                            }
                        }
                        class_1269 resultType = tool.method_7909().method_7884((class_1838)new UseContext(context.method_8045(), player, hand, tool, Function.fakeMOP((class_2338)sPos, (class_2350)direction)));
                        if (!resultType.method_23665()) continue;
                        toolResult = class_1269.field_5812;
                    }
                }
            }
        }
        return toolResult;
    }

    public float getBreakSpeed(class_1799 stack, class_1657 player, class_2680 state, float original, class_2338 pos) {
        class_1937 world = player.method_37908();
        EnumType type = ItemMultiTool.getEnumType(stack);
        if (type == EnumType.PICKAXE || type == EnumType.SHOVEL) {
            if (player.method_5715() || !this.isToolEffective(world, pos, world.method_8320(pos), stack, player)) {
                return original;
            }
            List<class_2338> blockPosList = this.getBlocksToHarvest(stack, player, pos, false);
            if (blockPosList.isEmpty()) {
                return original;
            }
            float baseHardness = state.method_26214((class_1922)world, pos);
            float blockSpeed = original;
            float blockHardness = baseHardness;
            for (class_2338 sPos : blockPosList) {
                class_2680 sState = world.method_8320(sPos);
                blockSpeed += player.method_7351(sState);
                blockHardness += sState.method_26214((class_1922)world, sPos);
            }
            return blockSpeed / blockHardness * baseHardness / ((float)blockPosList.size() * 0.75f);
        }
        return original;
    }

    private List<class_2338> getBlocksToHarvest(class_1799 stack, class_1657 player, class_2338 pos, boolean posMine) {
        EnumType toolType = ItemMultiTool.getEnumType(stack);
        HarvestList cached = (HarvestList)HARVEST_CACHE.getIfPresent((Object)player);
        if (posMine && cached != null && cached.matches(toolType.name(), pos, null)) {
            return cached.results();
        }
        class_1937 world = player.method_37908();
        class_2350 facing = ItemMultiTool.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348).method_17780();
        if (!posMine && cached != null && cached.matches(toolType.name(), pos, facing)) {
            return cached.results();
        }
        ArrayList<class_2338> blockPosList = new ArrayList<class_2338>();
        class_2338.class_2339 sPos = new class_2338.class_2339(pos.method_10263(), pos.method_10264(), pos.method_10260());
        if (toolType == EnumType.AXE) {
            ArrayList<Long> processed = new ArrayList<Long>();
            ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
            queue.add(pos);
            while (!queue.isEmpty() && blockPosList.size() <= 512) {
                class_2338 qPos = (class_2338)queue.peekFirst();
                for (int x = -1; x < 2; x = (int)((byte)(x + 1))) {
                    for (int z = -1; z < 2; z = (int)((byte)(z + 1))) {
                        for (int y = -1; y < 2; y = (int)((byte)(y + 1))) {
                            if (x == 0 && y == 0 && z == 0) continue;
                            sPos.method_10103(qPos.method_10263() + x, qPos.method_10264() + y, qPos.method_10260() + z);
                            Long sl = sPos.method_10063();
                            if (processed.contains(sl)) continue;
                            processed.add(sl);
                            if (!player.method_7343((class_2338)sPos, class_2350.field_11036, stack) || world.method_22347((class_2338)sPos) || !TagHelper.isBlockInTag((class_2680)world.method_8320((class_2338)sPos), (class_6862)class_3481.field_15475)) continue;
                            blockPosList.add(sPos.method_10062());
                            queue.add(sPos.method_10062());
                        }
                    }
                }
                queue.removeFirst();
            }
        } else {
            for (int row = -1; row < 2; row = (int)((byte)(row + 1))) {
                block10: for (int col = -1; col < 2; col = (int)((byte)(col + 1))) {
                    if (row == 0 && col == 0) continue;
                    switch (facing) {
                        case field_11033: 
                        case field_11036: {
                            sPos.method_10103(pos.method_10263() + row, pos.method_10264(), pos.method_10260() + col);
                            break;
                        }
                        case field_11043: 
                        case field_11035: {
                            sPos.method_10103(pos.method_10263() + row, pos.method_10264() + col, pos.method_10260());
                            break;
                        }
                        case field_11034: 
                        case field_11039: {
                            sPos.method_10103(pos.method_10263(), pos.method_10264() + row, pos.method_10260() + col);
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                    if (!player.method_7343((class_2338)sPos, facing, stack) || world.method_22347((class_2338)sPos) || !this.isToolEffective(world, (class_2338)sPos, player.method_37908().method_8320((class_2338)sPos), stack, player)) continue;
                    blockPosList.add(sPos.method_10062());
                }
            }
        }
        HARVEST_CACHE.put((Object)player, (Object)new HarvestList(toolType.name(), pos, facing, blockPosList));
        return blockPosList;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 entity) {
        EnumType type = ItemMultiTool.getEnumType(stack);
        if (type == EnumType.BROKEN) {
            return false;
        }
        float baseHardness = state.method_26214((class_1922)world, pos);
        if ((double)baseHardness > 0.0) {
            stack.method_7956(1, entity, livingEntity -> livingEntity.method_20235(class_1304.field_6173));
        }
        if (ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
            stack.method_7939(1);
            IStackAwareDamage.super.setDamage(stack, this.getMaxDamage(stack) - 1);
        }
        if (type != EnumType.PICKAXE && type != EnumType.SHOVEL && type != EnumType.AXE || world.method_8608() || !(entity instanceof class_3222)) {
            return true;
        }
        class_3222 player = (class_3222)entity;
        if (player.method_5715() || !this.isToolEffective(world, pos, state, stack, (class_1657)player)) {
            return true;
        }
        List<class_2338> blockPosList = this.getBlocksToHarvest(stack, (class_1657)player, pos, true);
        if (!blockPosList.isEmpty()) {
            int counter = 1;
            for (class_2338 sPos : blockPosList) {
                if (ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
                    stack.method_7939(1);
                    IStackAwareDamage.super.setDamage(stack, this.getMaxDamage(stack) - 1);
                    break;
                }
                class_2680 sState = world.method_8320(sPos);
                if (sState.method_26214((class_1922)world, sPos) < 0.0f) continue;
                int exp = 0;
                if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)player.method_6047()) != 0) {
                    class_2248 sBlock = sState.method_26204();
                    if (sBlock instanceof TA_OreBlock_Accessor) {
                        TA_OreBlock_Accessor ore = (TA_OreBlock_Accessor)sBlock;
                        exp += ore.getExperienceDropped().method_35008(world.field_9229);
                    } else if (sBlock instanceof class_2449) {
                        exp += 1 + world.field_9229.method_43048(5);
                    } else if (sBlock instanceof class_2496) {
                        exp += 15 + world.field_9229.method_43048(15) + world.field_9229.method_43048(15);
                    } else if (sBlock instanceof class_7126) {
                        exp += 20;
                    } else if (sBlock instanceof class_5703) {
                        exp += 5;
                    } else if (sBlock instanceof class_7268) {
                        exp += 5;
                    }
                    exp += (int)((double)(exp * world.field_9229.method_43048(Math.max(1, class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)player.method_6047())))) * 0.5);
                }
                if ((double)sState.method_26214((class_1922)world, sPos) > 0.0 && ++counter % 3 == 0) {
                    stack.method_7956(1, entity, livingEntity -> livingEntity.method_20235(class_1304.field_6173));
                }
                class_2586 sTile = world.method_8321(sPos);
                if (player.method_31549().field_7477) {
                    this.removeBlock(world, sPos, (class_1657)player, false);
                    continue;
                }
                boolean harvest = player.method_7305(sState);
                boolean removed = this.removeBlock(world, sPos, (class_1657)player, harvest);
                if (removed && harvest) {
                    sState.method_26204().method_9556(world, (class_1657)player, sPos, sState, sTile, stack.method_7972());
                }
                if (!removed || exp <= 0 || !(world instanceof class_3218) || !world.method_8450().method_8355(class_1928.field_19392)) continue;
                class_1303.method_31493((class_3218)((class_3218)world), (class_243)class_243.method_24953((class_2382)sPos), (int)exp);
            }
        }
        return true;
    }

    private boolean removeBlock(class_1937 world, class_2338 pos, class_1657 player, boolean canHarvest) {
        class_2680 state = world.method_8320(pos);
        state.method_26204().method_9576(world, pos, state, player);
        boolean removed = world.method_8650(pos, false);
        if (removed) {
            state.method_26204().method_9585((class_1936)world, pos, state);
        }
        return removed;
    }

    private boolean isToolEffective(class_1937 world, class_2338 pos, class_2680 state, class_1799 stack, class_1657 player) {
        return state.method_26214((class_1922)world, pos) >= 0.0f && this.getToolTypeItem(stack).method_7856(state);
    }

    @Override
    public void setDamage(class_1799 stack, int damage) {
        if (damage < this.getDamage(stack) && ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
            this.setType(stack, EnumType.PICKAXE);
        }
        if (this.method_7841() - damage < 1) {
            damage = this.method_7841() - 1;
            this.setType(stack, EnumType.BROKEN);
        }
        IStackAwareDamage.super.setDamage(stack, damage);
    }

    protected float getBonusDamage(class_1657 player, class_1297 victim, MyDamageSource source, float damage, float bonusDamage) {
        class_1799 stack = player.method_6047();
        return bonusDamage + (!stack.method_7960() && stack.method_7909() == this && ItemMultiTool.getEnumType(stack) == EnumType.WEAPON ? damage / 3.0f : 0.0f);
    }

    protected void postHurtEntity(class_1657 player, class_1297 victim, MyDamageSource source) {
        EnumType type;
        class_1799 stack = player.method_6047();
        if (!(stack.method_7960() || stack.method_7909() != this || (type = ItemMultiTool.getEnumType(stack)) != EnumType.WEAPON && type != EnumType.PICKAXE && type != EnumType.AXE)) {
            victim.method_5639(4);
        }
        super.postHurtEntity(player, victim, source);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 advanced) {
        if (ItemMultiTool.getEnumType(stack) != EnumType.BROKEN) {
            ADD_CHANGE_INSTRUCTIONS.accept(tooltip, StringUtil.translateAndComputeStyle((String)"info.terraqueous.mode_change.multitool"));
        }
    }

    public static enum EnumType {
        PICKAXE(0),
        SHOVEL(1),
        AXE(2),
        HOE(3),
        WEAPON(4),
        BROKEN(5);

        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        private EnumType next(boolean reverse) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PICKAXE -> {
                    if (reverse) {
                        yield WEAPON;
                    }
                    yield SHOVEL;
                }
                case SHOVEL -> {
                    if (reverse) {
                        yield PICKAXE;
                    }
                    yield AXE;
                }
                case AXE -> {
                    if (reverse) {
                        yield SHOVEL;
                    }
                    yield HOE;
                }
                case HOE -> {
                    if (reverse) {
                        yield AXE;
                    }
                    yield WEAPON;
                }
                case WEAPON -> {
                    if (reverse) {
                        yield HOE;
                    }
                    yield PICKAXE;
                }
                case BROKEN -> BROKEN;
            };
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static EnumType byName(String name) {
            if (!Strings.isNullOrEmpty((String)name)) {
                for (EnumType mode : EnumType.values()) {
                    if (!mode.toString().equals(name)) continue;
                    return mode;
                }
            }
            return PICKAXE;
        }
    }
}

