/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1420;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1452;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1477;
import net.minecraft.class_1493;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1549;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1590;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1614;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1640;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_4081;
import net.minecraft.class_4760;
import net.minecraft.class_4836;
import net.minecraft.class_5136;
import net.minecraft.class_7923;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.common.misc.IInteractionHandler;

public class BlueFlowerHandler
implements IInteractionHandler {
    public static BlueFlowerHandler INSTANCE = new BlueFlowerHandler();
    public static final Set<String> DEFAULTS = BlueFlowerHandler.getDefaults();
    private static final List<EffectEntry> EFFECTS = new ArrayList<EffectEntry>();
    private static long TRANSMUTE_DELAY;
    private final Random rand = new Random();
    private final HashMap<UUID, Short> blueFlower = new HashMap();

    private static Set<String> getDefaults() {
        HashSet<String> list = new HashSet<String>();
        list.add("effect[minecraft:speed];time[30-60];level[0-1]");
        list.add("effect[minecraft:slowness];time[10-20];level[0-1]");
        list.add("effect[minecraft:haste];time[60-120];level[0-1]");
        list.add("effect[minecraft:mining_fatigue];time[60-120];level[0-1]");
        list.add("effect[minecraft:strength];time[60-120];level[0-1]");
        list.add("effect[minecraft:jump_boost];time[60-120];level[0-1]");
        list.add("effect[minecraft:nausea];time[10];level[0]");
        list.add("effect[minecraft:regeneration];time[10-30];level[0-1]");
        list.add("effect[minecraft:resistance];time[60-120];level[0-1]");
        list.add("effect[minecraft:fire_resistance];time[150-300];level[0-1]");
        list.add("effect[minecraft:water_breathing];time[150-300];level[0-1]");
        list.add("effect[minecraft:invisibility];time[60-300];level[0-1]");
        list.add("effect[minecraft:blindness];time[30-60];level[0-1]");
        list.add("effect[minecraft:night_vision];time[60-120];level[0-1]");
        list.add("effect[minecraft:hunger];time[10-30];level[0-1]");
        list.add("effect[minecraft:weakness];time[10-20];level[0-1]");
        list.add("effect[minecraft:poison];time[5-10];level[0]");
        list.add("effect[minecraft:wither];time[3-5];level[0]");
        list.add("effect[minecraft:absorption];time[30-60];level[0-1]");
        list.add("effect[minecraft:saturation];time[15-30];level[0-1]");
        list.add("effect[minecraft:glowing];time[30-60];level[0-1]");
        list.add("effect[minecraft:levitation];time[2-3];level[0]");
        list.add("effect[minecraft:luck];time[30-60];level[0-1]");
        list.add("effect[minecraft:unluck];time[20-40];level[0-1]");
        list.add("effect[minecraft:slow_falling];time[15-30];level[0-1]");
        list.add("effect[minecraft:conduit_power];time[90-180];level[0-1]");
        list.add("effect[minecraft:dolphins_grace];time[30-60];level[0-1]");
        list.add("effect[minecraft:hero_of_the_village];time[120];level[2-4]");
        return list;
    }

    public void buildList(Set<String> list) {
        EFFECTS.clear();
        for (String entry : list) {
            int[] level;
            int[] time;
            String[] groups = new String[3];
            for (String string : entry.split(";")) {
                if (string.toLowerCase().startsWith("effect")) {
                    groups[0] = string.substring(7, string.length() - 1);
                    continue;
                }
                if (string.toLowerCase().startsWith("time")) {
                    groups[1] = string.substring(5, string.length() - 1);
                    continue;
                }
                if (!string.toLowerCase().startsWith("level")) continue;
                groups[2] = string.substring(6, string.length() - 1);
            }
            try {
                time = this.getValues(groups[1]);
                level = this.getValues(groups[2]);
            }
            catch (Exception ignored) {
                Terraqueous.LOGGER.error("Skipping invalid listTricksterBloomEffects entry: " + entry);
                continue;
            }
            EFFECTS.add(new EffectEntry((String)(groups[0].contains(":") ? groups[0] : "minecraft:" + groups[0]), time, level));
        }
    }

    private int[] getValues(String input) {
        int[] numbers = new int[2];
        String[] split = input.split("-");
        numbers[0] = Integer.parseInt(split[0]);
        numbers[1] = split.length > 1 ? Integer.parseInt(split[1]) : numbers[0];
        return numbers;
    }

    @Override
    public boolean onEntityCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.method_8608() && entity instanceof class_1657) {
            INSTANCE.blueAdd((class_1657)entity);
            return true;
        }
        return false;
    }

    @Override
    public class_1291 getStewEffect(class_2248 block) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            EffectEntry pick = this.getRandomEntry();
            if (pick == null || pick.getEffect().method_18792() == class_4081.field_18272) continue;
            return pick.getEffect();
        }
        return this.rand.nextBoolean() ? class_1294.field_5926 : (this.rand.nextBoolean() ? class_1294.field_5905 : class_1294.field_5906);
    }

    @Override
    public int getStewEffectDuration(class_2248 block) {
        return this.rand.nextInt(5) + 5;
    }

    public void blueAdd(class_1657 player) {
        UUID uuid;
        if (!(player.method_37908().method_8608() || EFFECTS.isEmpty() || this.blueFlower.containsKey(uuid = player.method_5667()))) {
            short delay = (short)((this.rand.nextInt(90) + 30) * 20);
            this.blueFlower.put(uuid, delay);
        }
    }

    private EffectEntry getRandomEntry() {
        EffectEntry pick = EFFECTS.get(this.rand.nextInt(EFFECTS.size()));
        if (pick.getEffect() != null) {
            return pick;
        }
        EFFECTS.remove(pick);
        return null;
    }

    public void blueUpdate(class_1657 player) {
        UUID uuid;
        if (!player.method_37908().method_8608() && !EFFECTS.isEmpty() && this.blueFlower.containsKey(uuid = player.method_5667())) {
            short value = this.blueFlower.get(uuid);
            if (value > 0) {
                value = (short)(value - 1);
                this.blueFlower.put(uuid, value);
                return;
            }
            this.blueFlower.remove(uuid);
            EffectEntry pick = this.getRandomEntry();
            if (pick != null) {
                player.method_6092(new class_1293(pick.getEffect(), pick.getTime(this.rand), pick.getLevel(this.rand)));
            }
        }
    }

    public void mobTransmute(class_1297 entity, boolean toHostile) {
        if (entity != null && !entity.method_37908().method_8608() && entity instanceof class_1309 && !(entity instanceof class_1657)) {
            if (TRANSMUTE_DELAY > System.currentTimeMillis()) {
                return;
            }
            TRANSMUTE_DELAY = System.currentTimeMillis() + 20L;
            class_1297 entityNew = toHostile ? this.getHostileMobTransmute(entity) : this.getNeutralMobTransmute(entity);
            if (entityNew != null) {
                entity.method_5650(class_1297.class_5529.field_26999);
                entityNew.method_37908().method_8649(entityNew);
            }
        }
    }

    private class_1297 getHostileMobTransmute(class_1297 entity) {
        if (entity.method_16914() || entity instanceof class_1321 && ((class_1321)entity).method_6181()) {
            return null;
        }
        class_1560 entityNew = null;
        if (entity instanceof class_1472) {
            entityNew = this.rand.nextInt(3) == 0 ? new class_1549(class_1299.field_6084, entity.method_37908()) : new class_1628(class_1299.field_6079, entity.method_37908());
        } else if (entity instanceof class_1463) {
            entityNew = new class_1560(class_1299.field_6091, entity.method_37908());
        } else if (entity instanceof class_3701) {
            entityNew = new class_1548(class_1299.field_6046, entity.method_37908());
        } else if (entity instanceof class_1493) {
            entityNew = this.rand.nextInt(3) == 0 ? new class_1639(class_1299.field_6076, entity.method_37908()) : new class_1613(class_1299.field_6137, entity.method_37908());
        } else if (entity instanceof class_1452) {
            if (this.rand.nextBoolean()) {
                if (this.rand.nextBoolean()) {
                    entityNew = new class_4836(class_1299.field_22281, entity.method_37908());
                    ((class_4836)entityNew).method_30240(true);
                } else {
                    entityNew = new class_1590(class_1299.field_6050, entity.method_37908());
                }
            } else if (this.rand.nextBoolean()) {
                entityNew = new class_4760(class_1299.field_21973, entity.method_37908());
                ((class_4760)entityNew).method_26948(true);
            } else {
                entityNew = new class_5136(class_1299.field_23696, entity.method_37908());
            }
        } else if (entity instanceof class_1428) {
            entityNew = new class_1642(class_1299.field_6051, entity.method_37908());
        } else if (entity instanceof class_1430) {
            entityNew = new class_1621(class_1299.field_6069, entity.method_37908());
        } else if (entity instanceof class_1477) {
            entityNew = new class_1593(class_1299.field_6078, entity.method_37908());
        } else if (entity instanceof class_1420) {
            entityNew = this.rand.nextBoolean() ? new class_1559(class_1299.field_6128, entity.method_37908()) : new class_1614(class_1299.field_6125, entity.method_37908());
        } else if (entity instanceof class_1646) {
            if (this.rand.nextInt(3) == 0) {
                entityNew = new class_1640(class_1299.field_6145, entity.method_37908());
            } else {
                entityNew = new class_1641(class_1299.field_6054, entity.method_37908());
                ((class_1641)entityNew).method_7195(((class_1646)entity).method_7231());
            }
        }
        if (entityNew != null) {
            if (((class_1308)entity).method_6109()) {
                entityNew.method_7217(entityNew instanceof class_5136 || entityNew instanceof class_1642);
            }
            entityNew.method_5641(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
        }
        return entityNew;
    }

    private class_1297 getNeutralMobTransmute(class_1297 entity) {
        if (entity.method_16914() || entity instanceof class_1321 && ((class_1321)entity).method_6181()) {
            return null;
        }
        class_1472 entityNew = null;
        if (entity instanceof class_1549 || entity instanceof class_1628) {
            entityNew = new class_1472(class_1299.field_6115, entity.method_37908());
        } else if (entity instanceof class_1560) {
            entityNew = new class_1463(class_1299.field_6140, entity.method_37908());
        } else if (entity instanceof class_1548) {
            entityNew = new class_3701(class_1299.field_6081, entity.method_37908());
        } else if (entity instanceof class_1547) {
            entityNew = new class_1493(class_1299.field_6055, entity.method_37908());
        } else if (entity instanceof class_4836 || entity instanceof class_4760 || entity instanceof class_5136 || entity instanceof class_1590) {
            entityNew = new class_1452(class_1299.field_6093, entity.method_37908());
        } else if (entity instanceof class_1641) {
            entityNew = new class_1646(class_1299.field_6077, entity.method_37908());
            ((class_1646)entityNew).method_7195(((class_1641)entity).method_7231());
        } else if (entity instanceof class_1642) {
            entityNew = new class_1428(class_1299.field_6132, entity.method_37908());
        } else if (entity instanceof class_1621) {
            if (this.rand.nextInt(3) == 0) {
                entityNew = new class_1438(class_1299.field_6143, entity.method_37908());
                if (this.rand.nextInt(3) == 0) {
                    class_2487 nbt = new class_2487();
                    entityNew.method_5652(nbt);
                    nbt.method_10582("Type", "brown");
                    entityNew.method_5749(nbt);
                }
            } else {
                entityNew = new class_1430(class_1299.field_6085, entity.method_37908());
            }
        } else if (entity instanceof class_1614 || entity instanceof class_1559) {
            entityNew = new class_1420(class_1299.field_6108, entity.method_37908());
        } else if (entity instanceof class_1640) {
            entityNew = new class_1646(class_1299.field_6077, entity.method_37908());
        }
        if (entityNew != null) {
            if (((class_1308)entity).method_6109()) {
                entityNew.method_7217(false);
            }
            entityNew.method_5641(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
        }
        return entityNew;
    }

    private static class EffectEntry {
        private final String name;
        private final short tBase;
        private final short tAdd;
        private final byte lBase;
        private final byte lAdd;
        private class_1291 effect;

        EffectEntry(String name, int[] time, int[] level) {
            this.name = name;
            this.tBase = (short)class_3532.method_15340((int)Math.min(time[0], time[1]), (int)0, (int)Short.MAX_VALUE);
            this.tAdd = (short)class_3532.method_15340((int)(Math.max(time[0] - time[1], time[1] - time[0]) + 1), (int)1, (int)Short.MAX_VALUE);
            this.lBase = (byte)class_3532.method_15340((int)Math.min(level[0], level[1]), (int)0, (int)127);
            this.lAdd = (byte)class_3532.method_15340((int)(Math.max(level[0] - level[1], level[1] - level[0]) + 1), (int)1, (int)127);
        }

        int getTime(Random rand) {
            return (this.tAdd < 2 ? this.tBase : rand.nextInt(this.tAdd) + this.tBase) * 20;
        }

        int getLevel(Random rand) {
            return this.lAdd < 2 ? this.lBase : rand.nextInt(this.lAdd) + this.lBase;
        }

        class_1291 getEffect() {
            if (this.effect == null) {
                this.effect = (class_1291)class_7923.field_41174.method_10223(new class_2960(this.name));
            }
            return this.effect;
        }
    }
}

