/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.common.block.BlockStormForge;
import shetiphian.terraqueous.common.misc.Tags;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;

public class StormForgeHelper {
    private static final StormForgeHelper INSTANCE = new StormForgeHelper();
    private static final SFBlock[] BLOCK_ARRAY = StormForgeHelper.populateArray();
    private static final byte[] mapSFBase = new byte[]{13, 18, 38, 38, 38, 38, 38, 18, 14, 17, 21, 36, 28, 29, 26, 34, 22, 19, 37, 33, 41, 41, 25, 41, 41, 33, 39, 37, 25, 41, 41, 33, 41, 41, 25, 39, 37, 32, 28, 36, 42, 34, 26, 30, 39, 37, 27, 41, 41, 35, 41, 41, 27, 39, 37, 35, 41, 41, 27, 41, 41, 35, 39, 17, 24, 36, 28, 31, 26, 34, 23, 19, 16, 20, 40, 40, 40, 40, 40, 20, 15};
    private static final byte[] mapSFRise = new byte[]{1, 2, -1, -1, -1, -1, -1, 1, 2, 4, 3, -1, -1, -1, -1, -1, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, -1, -1, 1, 2, 4, 3, -1, -1, -1, -1, -1, 4, 3};
    private static final byte[] mapSFTop = new byte[]{1, 9, -1, -1, -1, -1, -1, 10, 2, 9, 5, -1, -1, -1, -1, -1, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 8, -1, -1, -1, -1, -1, 7, 11, 4, 12, -1, -1, -1, -1, -1, 11, 3};

    public static void createStormForge(class_1937 world, class_2338 pos) {
        INSTANCE.sfScanner(world, pos, EnumMode.SCAN_BUILD, true);
    }

    public static void removeStormForge(class_1937 world, class_2338 pos) {
        INSTANCE.sfScanner(world, pos, EnumMode.REMOVE, true);
    }

    public static SFBlock getSFBlock(byte sfbId) {
        sfbId = (byte)class_3532.method_15340((int)sfbId, (int)0, (int)(BLOCK_ARRAY.length - 1));
        return BLOCK_ARRAY[sfbId];
    }

    public static SFBlock getSFBlockByIndex(int layer, int index) {
        layer = class_3532.method_15340((int)layer, (int)0, (int)7);
        index = class_3532.method_15340((int)index, (int)0, (int)80);
        byte sfbId = layer == 0 ? mapSFBase[index] : (layer > 5 ? mapSFTop[index] : mapSFRise[index]);
        if (layer == 6) {
            sfbId = sfbId > 0 && sfbId < 5 ? (byte)0 : sfbId;
        } else if (layer == 7) {
            sfbId = (byte)(sfbId == -1 || sfbId > 4 ? -1 : sfbId + 4);
        }
        return sfbId < 0 ? null : BLOCK_ARRAY[sfbId];
    }

    public static void moveFire(class_1937 world, class_2338 pos) {
        for (int sZ = -4; sZ < 5; sZ = (int)((byte)(sZ + 1))) {
            for (int sX = -4; sX < 5; sX = (int)((byte)(sX + 1))) {
                class_2248 block;
                class_2338 place = pos.method_10069(sX, -1, sZ);
                int index = (sZ + 4) * 9 + (sX + 4);
                byte sfbId = mapSFBase[index];
                place = place.method_10084();
                if ((sfbId >= 25 && sfbId <= 36 || sfbId == 41) && ((block = world.method_8320(place).method_26204()) == class_2246.field_10036 || block instanceof class_2358)) {
                    world.method_8650(place, false);
                }
                if (sfbId < 37 || sfbId > 40 || !world.method_22347(place)) continue;
                Function.setBlock((class_1945)world, (class_2338)place, (class_2680)class_2246.field_10036.method_9564(), (boolean)true);
            }
        }
    }

    public static void spawnLighting(class_3218 world, class_2338 pos, boolean effectOnly) {
        class_1538 boltEntity = (class_1538)class_1299.field_6112.method_5883((class_1937)world);
        if (boltEntity != null) {
            boltEntity.method_29495(class_243.method_24955((class_2382)pos));
            boltEntity.method_29498(effectOnly);
            world.method_8649((class_1297)boltEntity);
        }
    }

    private void sfScanner(class_1937 world, class_2338 alterPos, EnumMode mode, boolean doStrike) {
        for (int sY = -1; sY < 7; sY = (int)((byte)(sY + 1))) {
            for (int sZ = -4; sZ < 5; sZ = (int)((byte)(sZ + 1))) {
                block7: for (int sX = -4; sX < 5; sX = (int)((byte)(sX + 1))) {
                    class_2338 blockPos = new class_2338(alterPos.method_10263() + sX, alterPos.method_10264() + sY, alterPos.method_10260() + sZ);
                    if (blockPos.equals((Object)alterPos)) continue;
                    int index = (sZ + 4) * 9 + (sX + 4);
                    byte sfbId = sY == -1 ? mapSFBase[index] : (sY > 4 ? mapSFTop[index] : mapSFRise[index]);
                    if (sY == 5) {
                        sfbId = sfbId > 0 && sfbId < 5 ? (byte)0 : sfbId;
                    } else if (sY == 6) {
                        sfbId = (byte)(sfbId == -1 || sfbId > 4 ? -1 : sfbId + 4);
                    }
                    if (sfbId < 0 || sfbId > BLOCK_ARRAY.length) continue;
                    switch (mode) {
                        case SCAN: 
                        case SCAN_BUILD: {
                            if (BLOCK_ARRAY[sfbId].isCorrectBlock(world.method_8320(blockPos).method_26204())) continue block7;
                            return;
                        }
                        case BUILD: {
                            SFBlock sfb = BLOCK_ARRAY[sfbId];
                            class_2680 sfbs = sfb.getForgeBlock();
                            Function.setBlock((class_1945)world, (class_2338)blockPos, (class_2680)((class_2680)sfbs.method_11657((class_2769)BlockStormForge.FACING, (Comparable)sfb.getFacing())), (boolean)false);
                            class_2586 tile = world.method_8321(blockPos);
                            if (tile instanceof TileEntitySFStatic) {
                                ((TileEntitySFStatic)tile).setAlterPos(alterPos);
                                ((TileEntitySFStatic)tile).setID(sfbId);
                            }
                            if (!doStrike || sX != -3 && sX != 3 || sZ != -3 && sZ != 3 || !(world instanceof class_3218)) continue block7;
                            StormForgeHelper.spawnLighting((class_3218)world, blockPos, false);
                            continue block7;
                        }
                        case REMOVE: {
                            class_2680 sfsb = BLOCK_ARRAY[sfbId].getSourceBlock();
                            Function.setBlock((class_1945)world, (class_2338)blockPos, (class_2680)sfsb, (boolean)false);
                        }
                    }
                }
            }
        }
        if (mode == EnumMode.SCAN_BUILD) {
            this.sfScanner(world, alterPos, EnumMode.BUILD, doStrike);
        }
        if (mode == EnumMode.BUILD) {
            class_2680 sfb = (class_2680)((class_2680)Roster.Blocks.STORMFORGE.method_9564().method_11657(BlockStormForge.PART, (Comparable)((Object)BlockStormForge.StormForgeBlock.ALTER))).method_11657((class_2769)BlockStormForge.FACING, (Comparable)class_2350.class_2353.field_11062.method_10183(class_5819.method_43047()));
            Function.setBlock((class_1945)world, (class_2338)alterPos, (class_2680)sfb, (boolean)false);
            if (doStrike && world instanceof class_3218) {
                StormForgeHelper.spawnLighting((class_3218)world, alterPos, false);
            }
        }
    }

    public static boolean repairStormForge(class_1937 world, class_2338 pos) {
        class_2338 alter;
        class_2680 state;
        if (world.method_22347(pos)) {
            pos = pos.method_10074();
        }
        if ((state = world.method_8320(pos)).method_26204() != Roster.Blocks.STORMFORGE) {
            return false;
        }
        if (state.method_11654(BlockStormForge.PART) == BlockStormForge.StormForgeBlock.ALTER) {
            INSTANCE.sfScanner(world, pos, EnumMode.BUILD, false);
            return true;
        }
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TileEntitySFStatic && (alter = ((TileEntitySFStatic)tile).getAlterPos()) != null) {
            INSTANCE.sfScanner(world, alter, EnumMode.BUILD, false);
            return true;
        }
        return false;
    }

    private static SFBlock[] populateArray() {
        class_2248 BURNIUM = Roster.Blocks.BURNIUM_BLOCK;
        class_2248 ENDIMIUM = Roster.Blocks.ENDIMIUM_BLOCK;
        SFBlock[] array = new SFBlock[]{new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_SMOOTH, null), new SFBlock(Tags.Blocks.MONOLITH_BASE, class_2246.field_10044, BlockStormForge.StormForgeBlock.MONOLITH, class_2350.field_11043), new SFBlock(Tags.Blocks.MONOLITH_BASE, class_2246.field_10044, BlockStormForge.StormForgeBlock.MONOLITH, class_2350.field_11034), new SFBlock(Tags.Blocks.MONOLITH_BASE, class_2246.field_10044, BlockStormForge.StormForgeBlock.MONOLITH, class_2350.field_11035), new SFBlock(Tags.Blocks.MONOLITH_BASE, class_2246.field_10044, BlockStormForge.StormForgeBlock.MONOLITH, class_2350.field_11039), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, class_2350.field_11043), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, class_2350.field_11034), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, class_2350.field_11035), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, class_2350.field_11039), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, class_2350.field_11043), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, class_2350.field_11034), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, class_2350.field_11035), new SFBlock(Tags.Blocks.MONOLITH_CAP, class_2246.field_10153, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, class_2350.field_11039), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, class_2350.field_11043), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, class_2350.field_11034), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, class_2350.field_11035), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, class_2350.field_11039), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, class_2350.field_11043), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, class_2350.field_11034), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, class_2350.field_11035), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, class_2350.field_11039), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, class_2350.field_11043), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, class_2350.field_11034), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, class_2350.field_11035), new SFBlock(Tags.Blocks.ENDIMIUM, ENDIMIUM, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, class_2350.field_11039), new SFBlock(Tags.Blocks.REDSTONE, class_2246.field_10002, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11043), new SFBlock(Tags.Blocks.REDSTONE, class_2246.field_10002, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11034), new SFBlock(Tags.Blocks.REDSTONE, class_2246.field_10002, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11035), new SFBlock(Tags.Blocks.REDSTONE, class_2246.field_10002, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11039), new SFBlock(Tags.Blocks.LAPIS, class_2246.field_10441, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, class_2350.field_11043), new SFBlock(Tags.Blocks.LAPIS, class_2246.field_10441, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, class_2350.field_11034), new SFBlock(Tags.Blocks.LAPIS, class_2246.field_10441, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, class_2350.field_11035), new SFBlock(Tags.Blocks.LAPIS, class_2246.field_10441, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, class_2350.field_11039), new SFBlock(Tags.Blocks.IRON, class_2246.field_10085, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11043), new SFBlock(Tags.Blocks.IRON, class_2246.field_10085, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11034), new SFBlock(Tags.Blocks.IRON, class_2246.field_10085, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11035), new SFBlock(Tags.Blocks.IRON, class_2246.field_10085, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, class_2350.field_11039), new SFBlock(Tags.Blocks.BURNIUM, BURNIUM, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, class_2350.field_11043), new SFBlock(Tags.Blocks.BURNIUM, BURNIUM, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, class_2350.field_11034), new SFBlock(Tags.Blocks.BURNIUM, BURNIUM, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, class_2350.field_11035), new SFBlock(Tags.Blocks.BURNIUM, BURNIUM, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, class_2350.field_11039), new SFBlock(Tags.Blocks.GOLD, class_2246.field_10205, BlockStormForge.StormForgeBlock.PLATFORM_RUNE, null), new SFBlock(Tags.Blocks.ALTER_BASE, ENDIMIUM, true, BlockStormForge.StormForgeBlock.PLATFORM_ALTER_AQUADUCT, null)};
        return array;
    }

    private static enum EnumMode {
        SCAN,
        SCAN_BUILD,
        BUILD,
        REMOVE;

    }

    public static class SFBlock {
        private final class_2248 sourceBlock;
        private final class_2680 forgeBlock;
        private final class_2350 blockFacing;
        private final class_6862<class_2248> tag;

        SFBlock(class_6862<class_2248> tag, class_2248 sourceBlock, BlockStormForge.StormForgeBlock placeType, class_2350 facing) {
            this(tag, sourceBlock, false, placeType, facing);
        }

        SFBlock(class_6862<class_2248> tag, class_2248 sourceBlock, boolean randomize, BlockStormForge.StormForgeBlock placeType, class_2350 facing) {
            Collection blocks;
            this.tag = tag;
            this.sourceBlock = randomize ? ((blocks = TagHelper.getBlocks(tag)).isEmpty() ? sourceBlock : (class_2248)blocks.iterator().next()) : sourceBlock;
            this.forgeBlock = (class_2680)Roster.Blocks.STORMFORGE.method_9564().method_11657(BlockStormForge.PART, (Comparable)((Object)placeType));
            this.blockFacing = facing;
        }

        public class_1799 getSourceStack() {
            return new class_1799((class_1935)this.sourceBlock);
        }

        public class_2680 getSourceBlock() {
            return this.sourceBlock.method_9564();
        }

        public class_2680 getForgeBlock() {
            return this.geBlockWithRotation(this.forgeBlock, null);
        }

        public class_2680 getForgeBlockWithRotation(class_2350 facing) {
            return this.geBlockWithRotation(this.forgeBlock, facing);
        }

        private class_2680 geBlockWithRotation(class_2680 state, class_2350 rotation) {
            if (rotation == null) {
                rotation = this.getFacing();
            }
            return (class_2680)state.method_11657((class_2769)BlockStormForge.FACING, (Comparable)rotation);
        }

        public class_2350 getFacing() {
            return this.blockFacing != null ? this.blockFacing : class_2350.class_2353.field_11062.method_10183(class_5819.method_43047());
        }

        public boolean isCorrectBlock(class_2248 block) {
            return block == this.sourceBlock || TagHelper.isBlockInTag((class_2248)block, this.tag);
        }
    }
}

