/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.misc.Tags;

public class TileEntityFlowerPot
extends TileEntityRGB16
implements IRGB16_Tile {
    private class_1799 plantStack = class_1799.field_8037;
    private class_2350 plantFacing = class_2350.field_11035;
    private RenderStyle renderStyle = null;
    private long villagerPlantTimer = 0L;

    public TileEntityFlowerPot(class_2338 pos, class_2680 state) {
        super(Roster.Tiles.FLOWERPOT, pos, state, BlockFlowerPot.BASE_COLOR);
    }

    public void buildNBT(class_2487 nbtTag) {
        super.buildNBT(nbtTag);
        if (!this.plantStack.method_7960()) {
            nbtTag.method_10566("plant", (class_2520)this.plantStack.method_7953(new class_2487()));
            nbtTag.method_10582("facing", this.plantFacing.method_15434());
            if (this.villagerPlantTimer > 0L) {
                nbtTag.method_10544("villager", this.villagerPlantTimer);
            }
        }
    }

    public void processNBT(class_2487 nbtTag) {
        super.processNBT(nbtTag);
        if (nbtTag.method_10545("plant")) {
            this.setPlantStack(class_1799.method_7915((class_2487)nbtTag.method_10562("plant")));
            this.plantFacing = class_2350.method_10168((String)nbtTag.method_10558("facing"));
            if (nbtTag.method_10545("villager")) {
                this.villagerPlantTimer = nbtTag.method_10537("villager");
            }
        } else {
            this.plantStack = class_1799.field_8037;
        }
    }

    @NotNull
    public class_1799 getPlantStack() {
        return this.plantStack;
    }

    public void setPlantStack(@NotNull class_1799 stack) {
        if (stack.method_7960() || stack.method_7909() instanceof class_1747 || TagHelper.isItemInTag((class_1799)stack, Tags.Items.GEMS_EMERALD)) {
            this.plantStack = stack;
            this.villagerPlantTimer = 0L;
            DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::setRenderStyle);
        }
    }

    public void setVillagerPlantTimer(long gameTime) {
        this.villagerPlantTimer = gameTime;
    }

    public long getVillagerPlantTimer() {
        return this.villagerPlantTimer;
    }

    public class_2350 getPlantFacing() {
        return this.plantFacing;
    }

    public void setPlantFacing(class_2350 facing) {
        this.plantFacing = facing.method_10161() < 0 ? class_2350.field_11035 : facing;
    }

    @Environment(value=EnvType.CLIENT)
    public RenderStyle getRenderStyle() {
        if (this.renderStyle == null) {
            this.setRenderStyle();
        }
        return this.renderStyle;
    }

    @Environment(value=EnvType.CLIENT)
    private void setRenderStyle() {
        String name;
        if (this.plantStack == null || this.plantStack.method_7960()) {
            this.renderStyle = RenderStyle.NONE;
            return;
        }
        if (TagHelper.isItemInTag((class_1799)this.plantStack, Tags.Items.GEMS_EMERALD)) {
            this.renderStyle = RenderStyle.BULB;
            return;
        }
        class_2960 resourceName = class_7923.field_41178.method_10221((Object)this.plantStack.method_7909());
        if (resourceName != class_7923.field_41178.method_10137() && Values.flowerpotOverrides.containsKey(name = resourceName.method_12836() + ":" + resourceName.method_12832())) {
            this.renderStyle = RenderStyle.getStyle(Values.flowerpotOverrides.get(name));
            return;
        }
        this.renderStyle = RenderStyle.DEFAULT;
    }

    public static enum RenderStyle {
        CROSS_SINGLE,
        CROSS_MULTI,
        BLOCK,
        PANE,
        TALL,
        BULB,
        DEFAULT,
        NONE;


        static RenderStyle getStyle(byte style) {
            return RenderStyle.values()[class_3532.method_15340((int)style, (int)0, (int)RenderStyle.values().length)];
        }
    }
}

