/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.IStormForgeRepairHandler;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;
import shetiphian.terraqueous.common.inventory.InventoryStormForge;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntitySFController
extends TileEntityAutoCrafting {
    public short delayTime;
    private boolean isWorking;
    public float renderRotation;

    public TileEntitySFController(class_2338 pos, class_2680 state) {
        super(Roster.Tiles.STORMFORGE_ALTER, pos, state);
        this.inventory = new InventoryStormForge((class_2586)this);
    }

    @Override
    protected void buildNBT(class_2487 nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.method_10575("delayTime", this.delayTime);
        nbtTag.method_10556("isWorking", this.isWorking);
    }

    @Override
    protected void processNBT(class_2487 nbtTag) {
        super.processNBT(nbtTag);
        this.delayTime = nbtTag.method_10568("delayTime");
        this.isWorking = nbtTag.method_10577("isWorking");
    }

    protected void processNBT_SaveOnly(class_2487 nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!nbtTag.method_10545("items") && nbtTag.method_10545("processing")) {
            this.inventory.method_5447(6, class_1799.method_7915((class_2487)nbtTag.method_10562("processing")));
        }
    }

    protected void buildNBT_SyncOnly(class_2487 nbtTag) {
        super.buildNBT_SyncOnly(nbtTag);
        nbtTag.method_10566("processing", (class_2520)this.inventory.method_5438(6).method_7953(new class_2487()));
    }

    protected void processNBT_SyncOnly(class_2487 nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        if (nbtTag.method_10545("processing")) {
            this.inventory.method_5447(6, class_1799.method_7915((class_2487)nbtTag.method_10562("processing")));
        }
    }

    @Override
    public void tick() {
        class_1799 processStack;
        class_2248 block;
        int lightningChance;
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_2338 pos = this.field_11867;
        boolean canBlockSeeSky = this.field_11863.method_22348(pos.method_10084());
        boolean wasStruck = false;
        boolean instantComplete = false;
        if (canBlockSeeSky && this.field_11863.method_8546() && this.field_11863.field_9229.method_43048(lightningChance = (int)(200.0f - this.field_11863.method_8478(1.0f) * 100.0f)) == 0) {
            wasStruck = true;
            if (this.field_11863 instanceof class_3218) {
                StormForgeHelper.spawnLighting((class_3218)this.field_11863, pos, false);
            }
            if (this.field_11863.field_9229.method_43048(lightningChance * 2) == 0) {
                instantComplete = true;
            }
            StormForgeHelper.moveFire(this.field_11863, this.field_11867);
        }
        if ((block = this.field_11863.method_8320(pos.method_10084()).method_26204()) == class_2246.field_10036 || block instanceof class_2358) {
            this.field_11863.method_8650(pos.method_10084(), false);
        }
        if ((processStack = this.inventory.method_5438(6)).method_7960()) {
            this.getNextItem(true);
        } else {
            boolean moveToOutput;
            boolean bl = moveToOutput = !this.isWorking;
            if (this.isWorking) {
                if (this.isSFStack(6)) {
                    this.delayTime = (short)(this.delayTime + 1);
                    IStormForgeStackHandler handler = this.getStackHandler(processStack);
                    if (handler != null) {
                        this.inventory.method_5447(6, handler.processStack(processStack, this.delayTime, wasStruck, this.field_11863, pos));
                        moveToOutput = handler.isFinished(processStack, this.delayTime, wasStruck, this.field_11863, pos);
                    } else {
                        moveToOutput = true;
                    }
                    if (moveToOutput) {
                        this.delayTime = 0;
                    }
                } else {
                    Triple<class_1799, Float, Integer> smelting;
                    boolean processed = false;
                    for (IStormForgeRechargeHandler iStormForgeRechargeHandler : StormForgeRegistry.getRechargeHandlers()) {
                        if (!iStormForgeRechargeHandler.handleStack(processStack)) continue;
                        processed = true;
                        boolean used = iStormForgeRechargeHandler.charge(processStack, this.getPower(iStormForgeRechargeHandler.multiplier(), wasStruck, !canBlockSeeSky), instantComplete);
                        moveToOutput = !used || iStormForgeRechargeHandler.isFull(processStack);
                        break;
                    }
                    if (!canBlockSeeSky && this.field_11863.field_9229.method_43048(10) < 4) {
                        return;
                    }
                    this.delayTime = (short)(this.delayTime + this.getValue(1, wasStruck, false));
                    if (!processed) {
                        for (IStormForgeRepairHandler iStormForgeRepairHandler : StormForgeRegistry.getRepairHandlers()) {
                            if (!iStormForgeRepairHandler.handleStack(processStack)) continue;
                            processed = true;
                            if (iStormForgeRepairHandler.isRepaired(processStack)) {
                                this.delayTime = 0;
                                moveToOutput = true;
                                break;
                            }
                            if (this.delayTime < Terraqueous.CONFIG.COMMON.STORMFORGE.ticks_per_repair_point && !instantComplete) break;
                            this.delayTime = 0;
                            iStormForgeRepairHandler.repair(processStack, instantComplete);
                            if (wasStruck && !instantComplete) {
                                iStormForgeRepairHandler.repair(processStack, false);
                            }
                            moveToOutput = iStormForgeRepairHandler.isRepaired(processStack);
                            break;
                        }
                    }
                    if (!processed && !((class_1799)(smelting = this.getSmelted(this.inventory.method_5438(6))).getLeft()).method_7960()) {
                        processed = true;
                        if (this.delayTime >= (int)((double)((Integer)smelting.getRight()).intValue() * Terraqueous.CONFIG.COMMON.STORMFORGE.smelt_time_multiplier) || instantComplete) {
                            this.delayTime = 0;
                            class_1799 class_17992 = (class_1799)smelting.getLeft();
                            if (!class_17992.method_7960()) {
                                this.addExperience(((Float)smelting.getMiddle()).floatValue());
                                this.inventory.method_5447(6, class_17992.method_7972());
                            }
                        }
                    }
                    if (!processed) {
                        moveToOutput = true;
                    }
                }
            }
            if (moveToOutput) {
                this.isWorking = false;
                processStack = this.inventory.method_5438(6);
                byte outputSlot = this.getOutputSlot(processStack, true);
                if (outputSlot > -1) {
                    class_1799 outputSlotStack = this.inventory.method_5438((int)outputSlot);
                    if (!outputSlotStack.method_7960()) {
                        outputSlotStack.method_7933(!processStack.method_7960() ? processStack.method_7947() : 1);
                    } else {
                        this.inventory.method_5447((int)outputSlot, processStack);
                    }
                    this.inventory.method_5447(6, class_1799.field_8037);
                    this.getNextItem(false);
                    Function.syncTile((class_2586)this);
                }
            }
        }
    }

    private void getNextItem(boolean syncOnMove) {
        for (int slot = 0; slot < 6; slot = (int)((byte)(slot + 1))) {
            class_1799 stackInSlot = this.inventory.method_5438(slot);
            if (stackInSlot.method_7960() || this.getOutputSlot(stackInSlot, false) <= -1) continue;
            this.inventory.method_5447(6, stackInSlot.method_7971(1));
            this.isWorking = true;
            if (stackInSlot.method_7960()) {
                this.inventory.method_5447(slot, class_1799.field_8037);
            }
            this.delayTime = 0;
            if (syncOnMove) {
                Function.syncTile((class_2586)this);
            }
            return;
        }
    }

    private double getPower(double multiplier, boolean wasStruck, boolean doReduction) {
        int base = this.getValue(Terraqueous.CONFIG.COMMON.STORMFORGE.power_per_tick_base, wasStruck, doReduction);
        return (double)base * multiplier;
    }

    private int getValue(int base, boolean wasStruck, boolean doReduction) {
        float value = base;
        if (this.field_11863 != null) {
            value += 0.5f * (float)base * this.field_11863.method_8430(1.0f) + 0.75f * (float)base * this.field_11863.method_8478(1.0f) * 3.0f;
        }
        return class_3532.method_15386((float)(value *= (wasStruck ? 2.0f : 1.0f) * (doReduction ? 0.25f : 1.0f)));
    }

    private byte getOutputSlot(class_1799 item, boolean currentItem) {
        Triple<class_1799, Float, Integer> smelting;
        if (item == null) {
            return -1;
        }
        if (!currentItem && !((class_1799)(smelting = this.getSmelted(this.inventory.method_5438(6))).getLeft()).method_7960()) {
            item = ((class_1799)smelting.getLeft()).method_7972();
        }
        boolean useFreeSlot = !item.method_7946();
        for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
            for (byte slot = 7; slot < 13; slot = (byte)(slot + 1)) {
                int result;
                class_1799 stackInSlot;
                if (!(useFreeSlot ? this.inventory.method_5438((int)slot).method_7960() : !(stackInSlot = this.inventory.method_5438((int)slot)).method_7960() && class_1799.method_7984((class_1799)stackInSlot, (class_1799)item) && (result = stackInSlot.method_7947() + item.method_7947()) <= this.inventory.method_5444() && result <= item.method_7914())) continue;
                return slot;
            }
            useFreeSlot = true;
        }
        return -1;
    }

    private IStormForgeStackHandler getStackHandler(class_1799 stack) {
        IStormForgeStackHandler handler = null;
        if (!stack.method_7960()) {
            if (stack.method_7909() instanceof IStormForgeStackHandler) {
                handler = (IStormForgeStackHandler)stack.method_7909();
            }
            if (handler == null) {
                for (IStormForgeStackHandler stackhandler : StormForgeRegistry.getStackHandlers()) {
                    if (!stackhandler.handleStack(stack)) continue;
                    return stackhandler;
                }
            }
        }
        return handler;
    }

    private boolean isSFStack(int slotId) {
        IStormForgeStackHandler handler;
        class_1799 stackInSlot = this.inventory.method_5438(slotId);
        if (!stackInSlot.method_7960() && (handler = this.getStackHandler(stackInSlot)) != null) {
            return handler.handleStack(stackInSlot);
        }
        return false;
    }

    private boolean isChargeable(int slotId) {
        class_1799 stackInSlot = this.inventory.method_5438(slotId);
        if (!stackInSlot.method_7960()) {
            for (IStormForgeRechargeHandler handler : StormForgeRegistry.getRechargeHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepairable(int slotId) {
        class_1799 stackInSlot = this.inventory.method_5438(slotId);
        if (!stackInSlot.method_7960()) {
            for (IStormForgeRepairHandler handler : StormForgeRegistry.getRepairHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public class_1799 getCenterItem() {
        class_1799 stackInSlot = this.inventory.method_5438(6);
        return !stackInSlot.method_7960() && this.isWorking ? stackInSlot.method_7972() : class_1799.field_8037;
    }

    @Environment(value=EnvType.CLIENT)
    public short getProcessType(byte slotId) {
        if (!this.inventory.method_5438((int)slotId).method_7960()) {
            if (slotId == 6 && !this.isWorking) {
                return -1;
            }
            if (this.isSFStack(slotId)) {
                return 4;
            }
            if (this.isChargeable(slotId)) {
                return 1;
            }
            if (this.isRepairable(slotId)) {
                return 2;
            }
            if (this.isSmeltable(this.inventory.method_5438((int)slotId))) {
                return 3;
            }
            return 0;
        }
        return -1;
    }

    @Environment(value=EnvType.CLIENT)
    public int getProgressScaled(int graphicWidth) {
        int base = this.delayTime * graphicWidth;
        if (this.isSFStack(6)) {
            class_1799 stackInSlot = this.inventory.method_5438(6);
            IStormForgeStackHandler handler = this.getStackHandler(stackInSlot);
            int ticks = handler != null ? handler.ticksToComplete(stackInSlot) : -1;
            return ticks > 0 ? base / ticks : -1;
        }
        if (this.isChargeable(6)) {
            return -1;
        }
        if (this.isRepairable(6)) {
            return base / Terraqueous.CONFIG.COMMON.STORMFORGE.ticks_per_repair_point;
        }
        Triple<class_1799, Float, Integer> smelting = this.getSmelted(this.inventory.method_5438(6));
        if (!((class_1799)smelting.getLeft()).method_7960()) {
            return (int)((double)base / ((double)((Integer)smelting.getRight()).intValue() * Terraqueous.CONFIG.COMMON.STORMFORGE.smelt_time_multiplier));
        }
        return -1;
    }
}

