/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;
import shetiphian.terraqueous.common.worldgen.WorldGenKeys;
import shetiphian.terraqueous.common.worldgen.WorldGenRegistry;

public class WorldGenerator {
    public static boolean canGenerate(class_1936 world, class_2338 pos, Set<String> blacklist) {
        return !WorldGenerator.isBlacklisted(world, blacklist) && pos.method_10264() >= 0 && pos.method_10264() <= WorldGenerator.getMaxWorldHeight(world);
    }

    public static int getMaxWorldHeight(class_1936 world) {
        return WorldGenerator.getDimension(world).comp_653();
    }

    public static boolean isBlacklisted(class_1936 world, Set<String> generatorList) {
        class_2960 registryName = WorldGenerator.getDimension(world).comp_655();
        return WorldGenerator.isBlacklisted(registryName, Terraqueous.CONFIG.COMMON.GENERATOR.DIM_BLACKLIST.global) || WorldGenerator.isBlacklisted(registryName, generatorList);
    }

    protected static boolean isBlacklisted(class_2960 registryName, Set<String> generatorList) {
        if (registryName != null) {
            String key = registryName.toString();
            for (String entry : generatorList) {
                if (!Pattern.compile(entry).matcher(key).find()) continue;
                return true;
            }
        }
        return false;
    }

    public static class_2874 getDimension(class_1936 world) {
        return world.method_8597();
    }

    private static boolean placeInBiome(class_5321<class_1959> biome, Set<String> generatorList) {
        class_2960 registryName = biome.method_29177();
        return !WorldGenerator.isBlacklisted(registryName, Terraqueous.CONFIG.COMMON.GENERATOR.BIOME_BLACKLIST.global) && !WorldGenerator.isBlacklisted(registryName, generatorList);
    }

    public static void initialize() {
        WorldGenRegistry.initialize();
        Configuration.CommonFile.Menu_Generator config = Terraqueous.CONFIG.COMMON.GENERATOR;
        if (config.generate_clouds) {
            WorldGenerator.addFeature(class_2893.class_2895.field_13176, WorldGenKeys.PLACED_FEATURE.CLOUDS, context -> WorldGenerator.placeInBiome((class_5321<class_1959>)context.getBiomeKey(), config.BIOME_BLACKLIST.clouds));
        }
        if (config.generate_doodads) {
            GenDoodads.addFeatures(context -> WorldGenerator.placeInBiome((class_5321<class_1959>)context.getBiomeKey(), config.BIOME_BLACKLIST.doodads));
        }
        if (config.generate_flowers) {
            GenFlowers.addFeatures(context -> WorldGenerator.placeInBiome((class_5321<class_1959>)context.getBiomeKey(), config.BIOME_BLACKLIST.flowers));
        }
        if (config.generate_plants) {
            GenPlants.addFeatures(context -> WorldGenerator.placeInBiome((class_5321<class_1959>)context.getBiomeKey(), config.BIOME_BLACKLIST.plants));
        }
        if (config.generate_trees) {
            GenTrees.addFeatures(context -> WorldGenerator.placeInBiome((class_5321<class_1959>)context.getBiomeKey(), config.BIOME_BLACKLIST.trees));
        }
    }

    protected static void addDecoration(class_5321<class_6796> featureRegistryKey, Predicate<BiomeSelectionContext> biomeContext) {
        WorldGenerator.addFeature(class_2893.class_2895.field_13178, featureRegistryKey, biomeContext);
    }

    protected static void addFeature(class_2893.class_2895 step, class_5321<class_6796> featureRegistryKey, Predicate<BiomeSelectionContext> biomeContext) {
        BiomeModifications.addFeature(biomeContext, (class_2893.class_2895)step, featureRegistryKey);
    }
}

