/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3122;
import net.minecraft.class_3124;
import net.minecraft.class_3532;
import net.minecraft.class_3825;
import net.minecraft.class_3827;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.worldgen.ConfigurationClouds;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public class FeatureClouds
extends class_3031<ConfigurationClouds> {
    private static final List<CloudEntry> CLOUD_ENTRIES = new ArrayList<CloudEntry>();
    private static final FeatureRedirect REDIRECT = new FeatureRedirect();
    private static final class_3827<AirTest> AIR_TEST_TYPE = class_3827.method_16821((String)"terraqueous:air_check", AirTest.CODEC);

    public FeatureClouds() {
        super(ConfigurationClouds.CODEC);
    }

    private void buildWeightedList(ConfigurationClouds config) {
        int counter = 0;
        if (Terraqueous.CONFIG.COMMON.GENERATOR.CLOUDS.generate_light) {
            CLOUD_ENTRIES.add(new CloudEntry(CloudAPI.CloudType.LIGHT, config.weightLight));
            ++counter;
        }
        if (Terraqueous.CONFIG.COMMON.GENERATOR.CLOUDS.generate_dense) {
            CLOUD_ENTRIES.add(new CloudEntry(CloudAPI.CloudType.DENSE, config.weightDense));
            ++counter;
        }
        if (Terraqueous.CONFIG.COMMON.GENERATOR.CLOUDS.generate_storm) {
            CLOUD_ENTRIES.add(new CloudEntry(CloudAPI.CloudType.STORM, config.weightStorm));
            ++counter;
        }
        if (counter > 0) {
            CLOUD_ENTRIES.add(new CloudEntry(null, config.weightNone));
        }
    }

    public boolean method_13151(class_5821<ConfigurationClouds> context) {
        ConfigurationClouds config = (ConfigurationClouds)context.method_33656();
        class_5281 world = context.method_33652();
        class_2338 position = context.method_33655();
        class_5819 random = context.method_33654();
        if (CLOUD_ENTRIES.isEmpty()) {
            this.buildWeightedList(config);
        }
        if (CLOUD_ENTRIES.isEmpty() || !WorldGenerator.canGenerate((class_1936)world, position, Terraqueous.CONFIG.COMMON.GENERATOR.DIM_BLACKLIST.clouds)) {
            return false;
        }
        CloudEntry cloudEntry = class_6011.method_34986((class_5819)random, CLOUD_ENTRIES).orElse(null);
        if (cloudEntry == null) {
            return false;
        }
        CloudAPI.CloudType cloudType = cloudEntry.cloudType;
        if (cloudType == null) {
            return false;
        }
        class_2248 block = null;
        int numberOfBlocks = 0;
        switch (cloudType) {
            case LIGHT: {
                block = Roster.Blocks.LIGHT_CLOUD;
                numberOfBlocks = this.getCount(random, config.lightMin, config.lightMax);
                break;
            }
            case DENSE: {
                block = Roster.Blocks.DENSE_CLOUD;
                numberOfBlocks = this.getCount(random, config.denseMin, config.denseMax);
                break;
            }
            case STORM: {
                block = Roster.Blocks.STORM_CLOUD;
                numberOfBlocks = this.getCount(random, config.stormMin, config.stormMax);
            }
        }
        if (numberOfBlocks > 0 && block instanceof BlockClouds) {
            int passes = Math.max(1, numberOfBlocks / 64);
            int amount = numberOfBlocks / passes;
            class_3124 oreFeatureConfig = new class_3124((class_3825)new AirTest(), (class_2680)block.method_9564().method_11657((class_2769)CloudAPI.KICKABLE, (Comparable)Boolean.valueOf(true)), amount);
            boolean result = false;
            for (int pass = 0; pass < passes; ++pass) {
                float rndPi = random.method_43057() * (float)Math.PI;
                float eighth = (float)amount / 8.0f;
                int i = class_3532.method_15386((float)(((float)amount / 16.0f * 2.0f + 1.0f) / 2.0f));
                double x1 = (double)position.method_10263() + Math.sin(rndPi) * (double)eighth;
                double x2 = (double)position.method_10263() - Math.sin(rndPi) * (double)eighth;
                double z1 = (double)position.method_10260() + Math.cos(rndPi) * (double)eighth;
                double z2 = (double)position.method_10260() - Math.cos(rndPi) * (double)eighth;
                double y1 = position.method_10264() - 6 + random.method_43048(7);
                double y2 = y1 + 1.0;
                int pX = position.method_10263() - class_3532.method_15386((float)eighth) - i;
                int pY = position.method_10264() - 2 - i;
                int pZ = position.method_10260() - class_3532.method_15386((float)eighth) - i;
                int j1 = 2 * (class_3532.method_15386((float)eighth) + i);
                int k1 = 2 * (2 + i);
                for (int sX = pX; sX <= pX + j1; ++sX) {
                    for (int xZ = pZ; xZ <= pZ + j1; ++xZ) {
                        if (!REDIRECT.method_13629(world, random, oreFeatureConfig, x1, x2, z1, z2, y1, y2, pX, pY, pZ, j1, k1)) continue;
                        result = true;
                    }
                }
            }
            return result;
        }
        return false;
    }

    private int getCount(class_5819 random, int min, int max) {
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return min + random.method_43048(1 + max - min);
    }

    public static class CloudEntry
    extends class_6008.class_6009 {
        public final CloudAPI.CloudType cloudType;

        public CloudEntry(CloudAPI.CloudType cloudType, int weight) {
            super(Math.max(1, weight));
            this.cloudType = cloudType;
        }
    }

    public static class AirTest
    extends class_3825 {
        public static final Codec<AirTest> CODEC;
        public static final AirTest INSTANCE;

        private AirTest() {
        }

        public boolean method_16768(class_2680 state, class_5819 random) {
            return true;
        }

        protected class_3827<?> method_16766() {
            return AIR_TEST_TYPE;
        }

        static {
            INSTANCE = new AirTest();
            CODEC = Codec.unit(() -> INSTANCE);
        }
    }

    private static class FeatureRedirect
    extends class_3122 {
        public FeatureRedirect() {
            super(class_3124.field_24896);
        }

        protected boolean method_13629(class_5281 world, class_5819 random, class_3124 config, double x1, double x2, double z1, double z2, double y1, double y2, int pX, int pY, int pZ, int v1, int v2) {
            return super.method_13629(world, random, config, x1, x2, z1, z2, y1, y2, pX, pY, pZ, v1, v2);
        }
    }
}

