/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_5819;
import net.minecraft.class_5867;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMiniCoconutTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class FeatureCoconutTree
extends FeatureTreeBase {
    private static final byte[] mapFoliage = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 1, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 5, 5, 5, 1, 5, 5, 5, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 5, 5, 0, 0, 5, 5, 5, 5, 0, 0, 0, 0, 5, 4, 5, 0, 0, 0, 0, 5, 5, 5, 5, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public FeatureCoconutTree() {
        this(false);
    }

    public FeatureCoconutTree(boolean doBlockNotifyOnPlace) {
        super(doBlockNotifyOnPlace, PlantAPI.Tree.COCONUT);
        this.MINI_TREE = new FeatureMiniCoconutTree(doBlockNotifyOnPlace);
    }

    @Override
    protected void setup(PlantAPI.Tree tree) {
        this.LOG = Roster.Blocks.COCONUT_LOG.method_9564();
        this.WOOD = Roster.Blocks.COCONUT_WOOD.method_9564();
        this.LEAVES = Roster.Blocks.COCONUT_LEAVES.method_9564();
    }

    @Override
    protected int getTreeWidth() {
        return 7;
    }

    @Override
    protected int getFoliageHeight() {
        return 4;
    }

    @Override
    protected int getTrunkHeight(class_5819 random) {
        return 0;
    }

    @Override
    protected byte getMapValue(int index) {
        return mapFoliage[index];
    }

    @Override
    protected class_2680 getBlockState(int mapValue, class_5819 random) {
        return switch (mapValue) {
            case 1 -> this.LOG;
            case 4 -> this.WOOD;
            case 5 -> this.LEAVES;
            default -> class_2246.field_10124.method_9564();
        };
    }

    @Override
    protected boolean placeTree(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_5819 random, class_2338 position, class_3341 boundingBox) {
        int index;
        int sZ;
        int chZ;
        int sX;
        int chX;
        int sY;
        int sY2;
        int segment;
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        int treeWidth = this.getTreeWidth();
        int foliageHeight = this.getFoliageHeight();
        int[] trunkSegment = new int[]{random.method_43048(3) + 3, random.method_43048(3) + 2, random.method_43048(2) + 1, random.method_43048(2) + 1};
        int trunkHeight = trunkSegment[0] + trunkSegment[1] + trunkSegment[2] + trunkSegment[3] + 3;
        if (position.method_10264() < 1 || position.method_10264() + 1 + trunkHeight + foliageHeight > WorldGenerator.getMaxWorldHeight(world)) {
            return false;
        }
        if (!FeatureCoconutTree.isSoil(world, position.method_10074(), this.getSapling())) {
            return false;
        }
        class_2338 foliagePos = position.method_10079(direction, 3);
        class_2338.class_2339 mPos = new class_2338.class_2339();
        mPos.method_10101((class_2382)position);
        int chY = position.method_10264();
        for (segment = 0; segment < 4; segment = (int)((byte)(segment + 1))) {
            for (sY2 = 0; sY2 < trunkSegment[segment]; sY2 = (int)((byte)(sY2 + 1))) {
                mPos.method_33098(chY);
                if (!FeatureCoconutTree.canBeReplacedByLogs(world, (class_2338)mPos)) {
                    return false;
                }
                ++chY;
            }
            if (segment >= 3) continue;
            mPos.method_33098(chY);
            if (!FeatureCoconutTree.canBeReplacedByLogs(world, (class_2338)mPos)) {
                return false;
            }
            mPos.method_10098(direction);
            if (!FeatureCoconutTree.canBeReplacedByLogs(world, (class_2338)mPos)) {
                return false;
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = foliagePos.method_10263() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = foliagePos.method_10260() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    if (this.getMapValue(index) > 0) {
                        mPos.method_10103(chX, chY, chZ);
                        if (!FeatureCoconutTree.canBeReplacedByLogs(world, (class_2338)mPos)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        mPos.method_10101((class_2382)position);
        chY = position.method_10264();
        for (segment = 0; segment < 4; segment = (int)((byte)(segment + 1))) {
            for (sY2 = 0; sY2 < trunkSegment[segment]; sY2 = (int)((byte)(sY2 + 1))) {
                mPos.method_33098(chY);
                if (FeatureCoconutTree.isAirOrLeaves(world, (class_2338)mPos)) {
                    this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(1, random), boundingBox);
                }
                ++chY;
            }
            if (segment >= 3) continue;
            mPos.method_33098(chY);
            if (FeatureCoconutTree.isAirOrLeaves(world, (class_2338)mPos)) {
                this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(4, random), boundingBox);
            }
            mPos.method_10098(direction);
            if (FeatureCoconutTree.isAirOrLeaves(world, (class_2338)mPos)) {
                this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(4, random), boundingBox);
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = foliagePos.method_10263() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = foliagePos.method_10260() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.method_10103(chX, chY, chZ);
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    byte mapValue = this.getMapValue(index);
                    if (mapValue > 0 && FeatureCoconutTree.isAirOrLeaves(world, (class_2338)mPos)) {
                        this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(mapValue, random), boundingBox);
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        return true;
    }
}

