/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2826;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5867;
import net.minecraft.class_6862;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.common.block.BlockDoodad;
import shetiphian.terraqueous.common.block.EnumOreBase;
import shetiphian.terraqueous.common.misc.Tags;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public abstract class FeatureDoodad
extends class_3031<class_3111> {
    public FeatureDoodad() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 world = context.method_33652();
        class_2338 position = context.method_33655();
        class_5819 random = context.method_33654();
        if (!WorldGenerator.canGenerate((class_1936)world, position, Terraqueous.CONFIG.COMMON.GENERATOR.DIM_BLACKLIST.doodads)) {
            return false;
        }
        return this.generate(world, position, random);
    }

    protected abstract boolean generate(class_5281 var1, class_2338 var2, class_5819 var3);

    protected boolean isTopSolid(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_51366() && class_2248.method_16361((class_1922)world, (class_2338)pos);
    }

    protected boolean isReplaceable(class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_45474();
    }

    protected void setBlockState(class_1936 world, class_2338 pos, class_2680 state) {
        class_3611 fluid;
        class_2248 block = state.method_26204();
        if (block instanceof BlockDoodad && (fluid = world.method_8316(pos).method_15772()) != class_3612.field_15906) {
            if (fluid == ((BlockDoodad)block).getFluid()) {
                state = (class_2680)state.method_11657((class_2769)BlockDoodad.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            } else {
                return;
            }
        }
        super.method_13153((class_1945)world, pos, state);
    }

    public static abstract class Crystal
    extends FeatureDoodad {
        protected boolean canSpawnOn(class_2680 state, Map<Object, class_2680> map) {
            return this.getStateFor(state, map) != null;
        }

        protected class_2680 getStateFor(class_2680 state, Map<Object, class_2680> map) {
            for (Object object : map.keySet()) {
                class_2248 block;
                if (object instanceof class_6862) {
                    class_6862 tagKey = (class_6862)object;
                    try {
                        if (!TagHelper.isBlockInTag((class_2680)state, (class_6862)tagKey)) continue;
                        return map.get(object);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!(object instanceof class_2248) || (block = (class_2248)object) != state.method_26204()) continue;
                return map.get(object);
            }
            return null;
        }

        protected void placeCrystal(class_1936 world, class_2338 pos, class_2680 crystal, boolean isExtra, class_5819 random, Map<Object, class_2680> map) {
            if (isExtra) {
                if (!this.isReplaceable(world, pos) || !this.isTopSolid(world, pos.method_10074())) {
                    return;
                }
                if (!(random.method_43056() && this.isReplaceable(world, pos) && this.isTopSolid(world, pos.method_10074()))) {
                    return;
                }
            }
            this.setBlockState(world, pos, crystal);
            pos = pos.method_10074();
            class_2680 ore = this.getStateFor(world.method_8320(pos), map);
            if (ore != null) {
                this.setBlockState(world, pos, ore);
            }
        }

        protected void generateOre(class_1936 world, class_2338 pos, class_5819 random, Map<Object, class_2680> map) {
            try (class_5867 bulkSectionAccess = new class_5867(world);){
                this.generateOre(bulkSectionAccess, pos, random, map);
            }
        }

        protected void generateOre(class_5867 bulkAccess, class_2338 pos, class_5819 random, Map<Object, class_2680> map) {
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            pos = pos.method_10074();
            int yMin = pos.method_10264() - (random.method_43048(4) + 1);
            int yMax = pos.method_10264() + (random.method_43048(4) + 1);
            for (int yCurrent = yMin; yCurrent <= yMax; ++yCurrent) {
                int parts = random.method_43048(6) + 1;
                for (int part = 0; part < parts; ++part) {
                    int xOffset = random.method_43048(5) - 3;
                    int zOffset = random.method_43048(5) - 3;
                    int xMin = pos.method_10263() - (random.method_43048(1) + 1) + xOffset;
                    int xMax = pos.method_10263() + (random.method_43048(1) + 1) + xOffset;
                    int zMin = pos.method_10260() - (random.method_43048(1) + 1) + zOffset;
                    int zMax = pos.method_10260() + (random.method_43048(1) + 1) + zOffset;
                    for (int xCurrent = xMin; xCurrent <= xMax; ++xCurrent) {
                        for (int zCurrent = zMin; zCurrent <= zMax; ++zCurrent) {
                            int rZ;
                            int rY;
                            int rX;
                            class_2680 ore;
                            mutablePos.method_10103(xCurrent, yCurrent, zCurrent);
                            class_2826 levelChunkSection = bulkAccess.method_33944((class_2338)mutablePos);
                            if (levelChunkSection == null || (ore = this.getStateFor(levelChunkSection.method_12254(rX = class_4076.method_18684((int)xCurrent), rY = class_4076.method_18684((int)yCurrent), rZ = class_4076.method_18684((int)zCurrent)), map)) == null) continue;
                            levelChunkSection.method_12256(rX, rY, rZ, ore, false);
                        }
                    }
                }
            }
        }

        public static class Endimium
        extends Crystal {
            private static final class_2680 CRYSTAL = Roster.Blocks.DOODAD_ENDIMIUM.method_9564();
            private static final class_2680 ENDIMIUM = Roster.Blocks.ENDIMIUM_ORE.method_9564();
            private static final Map<Object, class_2680> REPLACEMENTS = Map.of(Tags.Blocks.END_STONE, ENDIMIUM);

            @Override
            protected boolean generate(class_5281 world, class_2338 position, class_5819 random) {
                if (!this.isTopSolid((class_1936)world, position.method_10074())) {
                    return false;
                }
                if (random.method_43056()) {
                    return false;
                }
                if (this.canSpawnOn(world.method_8320(position.method_10074()), REPLACEMENTS)) {
                    this.placeCrystal((class_1936)world, position, CRYSTAL, false, random, REPLACEMENTS);
                    this.generateOre((class_1936)world, position, random, REPLACEMENTS);
                }
                return true;
            }
        }

        public static class Burnium
        extends Crystal {
            private static final class_2680 CRYSTAL = Roster.Blocks.DOODAD_BURNIUM.method_9564();
            private static final Map<Object, class_2680> REPLACEMENTS = Map.of(Tags.Blocks.NETHERRACK, Roster.Blocks.BURNIUM_ORE.method_9564(), class_2246.field_22120, Roster.Blocks.BURNIUM_ORE.method_9564(), class_2246.field_22113, Roster.Blocks.BURNIUM_ORE.method_9564(), class_2246.field_22091, (class_2680)Roster.Blocks.BURNIUM_ORE.method_9564().method_11657(EnumOreBase.NETHER_BASE, (Comparable)((Object)EnumOreBase.BASALT)), class_2246.field_23869, (class_2680)Roster.Blocks.BURNIUM_ORE.method_9564().method_11657(EnumOreBase.NETHER_BASE, (Comparable)((Object)EnumOreBase.BLACKSTONE)));

            @Override
            protected boolean generate(class_5281 world, class_2338 position, class_5819 random) {
                boolean placed = false;
                class_2338 sPos = new class_2338(position.method_10263(), world.method_31607() + 1, position.method_10260());
                while (sPos.method_10264() < world.method_31600()) {
                    if (random.method_43056() && random.method_43056() && this.isReplaceable((class_1936)world, sPos) && this.isTopSolid((class_1936)world, sPos.method_10074()) && this.canSpawnOn(world.method_8320(sPos.method_10074()), REPLACEMENTS)) {
                        this.placeCrystal((class_1936)world, sPos, CRYSTAL, false, random, REPLACEMENTS);
                        this.placeCrystal((class_1936)world, sPos.method_10067(), CRYSTAL, true, random, REPLACEMENTS);
                        this.placeCrystal((class_1936)world, sPos.method_10078(), CRYSTAL, true, random, REPLACEMENTS);
                        this.placeCrystal((class_1936)world, sPos.method_10095(), CRYSTAL, true, random, REPLACEMENTS);
                        this.placeCrystal((class_1936)world, sPos.method_10072(), CRYSTAL, true, random, REPLACEMENTS);
                        this.generateOre((class_1936)world, sPos, random, REPLACEMENTS);
                        placed = true;
                    }
                    sPos = sPos.method_10084();
                }
                return placed;
            }
        }
    }

    public static class Bone
    extends FeatureDoodad {
        @Override
        protected boolean generate(class_5281 world, class_2338 position, class_5819 random) {
            if (!this.isTopSolid((class_1936)world, position.method_10074())) {
                return false;
            }
            this.setBlockState((class_1936)world, position, Roster.Blocks.DOODAD_BONE.method_9564());
            return false;
        }
    }

    public static class Stone
    extends FeatureDoodad {
        @Override
        protected boolean generate(class_5281 world, class_2338 position, class_5819 random) {
            boolean placed = false;
            class_2338 sPos = new class_2338(position.method_10263(), world.method_31607() + 1, position.method_10260());
            while (sPos.method_10264() < world.method_31600()) {
                if (sPos.method_10264() < position.method_10264() - 8) {
                    for (int attempt = 0; attempt < 3; ++attempt) {
                        int offsetX = class_3532.method_15340((int)(random.method_43048(8) - random.method_43048(8)), (int)0, (int)16);
                        int offsetZ = class_3532.method_15340((int)(random.method_43048(8) - random.method_43048(8)), (int)0, (int)16);
                        placed = this.placeStone((class_1936)world, sPos.method_10069(offsetX, 0, offsetZ), random);
                    }
                } else {
                    placed = this.placeStone((class_1936)world, sPos, random);
                }
                sPos = sPos.method_10084();
            }
            return placed;
        }

        private boolean placeStone(class_1936 world, class_2338 pos, class_5819 random) {
            if (random.method_43056() && this.isReplaceable(world, pos) && this.isTopSolid(world, pos.method_10074())) {
                class_2680 state = world.method_8320(pos.method_10074());
                if (TagHelper.isBlockInTag((class_2680)state, (TagHelper.Check)TagHelper.Check.ANY, (Object[])new Object[]{Tags.Blocks.SAND_RED, Tags.Blocks.SANDSTONE_RED}) || TagHelper.isBlockInTag((class_2680)state, (class_6862)class_3481.field_36265) && random.method_43048(3) != 0) {
                    this.setBlockState(world, pos, Roster.Blocks.DOODAD_REDSANDSTONE.method_9564());
                    return true;
                }
                if (TagHelper.isBlockInTag((class_2680)state, (TagHelper.Check)TagHelper.Check.ANY, (Object[])new Object[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SANDSTONE_COLORLESS})) {
                    this.setBlockState(world, pos, Roster.Blocks.DOODAD_SANDSTONE.method_9564());
                    return true;
                }
                this.setBlockState(world, pos, Roster.Blocks.DOODAD_STONE.method_9564());
                return true;
            }
            return false;
        }
    }

    public static class Stick
    extends FeatureDoodad {
        @Override
        protected boolean generate(class_5281 world, class_2338 position, class_5819 random) {
            if (!this.isTopSolid((class_1936)world, position.method_10074())) {
                return false;
            }
            this.setBlockState((class_1936)world, position, Roster.Blocks.DOODAD_BRANCH.method_9564());
            return false;
        }
    }
}

