/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_5819;
import net.minecraft.class_5867;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.Tags;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class FeatureMiniTreeBase
extends FeatureTreeBase {
    private static final byte[] mapMiniTree = new byte[]{0, 0, 0, 0, 1, 0, 0, 0, 0, 6, 6, 6, 6, 4, 6, 6, 6, 6, 0, 6, 0, 6, 5, 6, 0, 6, 0};

    public FeatureMiniTreeBase(boolean doBlockNotifyOnPlace, PlantAPI.Tree tree) {
        super(doBlockNotifyOnPlace, tree);
    }

    @Override
    protected int getTreeWidth() {
        return 3;
    }

    protected int getTreeHeight() {
        return 3;
    }

    @Override
    protected final int getFoliageHeight() {
        return 0;
    }

    @Override
    protected final int getTrunkHeight(class_5819 random) {
        return 0;
    }

    @Override
    protected byte getMapValue(int index) {
        return mapMiniTree[index];
    }

    @Override
    protected boolean placeTree(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_5819 random, class_2338 position, class_3341 boundingBox) {
        int index;
        int sZ;
        int chZ;
        int sX;
        int chX;
        int sY;
        int treeWidth = this.getTreeWidth();
        int treeHeight = this.getTreeHeight();
        if (position.method_10264() < 1 || position.method_10264() + 1 + treeHeight > WorldGenerator.getMaxWorldHeight(world)) {
            return false;
        }
        boolean onStone = false;
        if (!FeatureMiniTreeBase.isSoil(world, position.method_10074(), this.getSapling())) {
            if (this.isStone(world, position.method_10074())) {
                onStone = true;
            } else {
                return false;
            }
        }
        class_2338.class_2339 mPos = new class_2338.class_2339();
        mPos.method_10101((class_2382)position);
        int chY = position.method_10264();
        for (sY = 0; sY < treeHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.method_10263() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.method_10260() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    if (this.getMapValue(index) > 0) {
                        mPos.method_10103(chX, chY, chZ);
                        if (!FeatureMiniTreeBase.canBeReplacedByLogs(world, (class_2338)mPos)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        if (onStone) {
            mPos.method_10101((class_2382)position.method_10074());
            this.setBlock(world, bulkAccess, (class_2338)mPos, class_2246.field_10255.method_9564());
            this.toGravel(world, bulkAccess, mPos.method_10074(), random);
            this.toGravel(world, bulkAccess, mPos.method_10095(), random);
            this.toGravel(world, bulkAccess, mPos.method_10072(), random);
            this.toGravel(world, bulkAccess, mPos.method_10078(), random);
            this.toGravel(world, bulkAccess, mPos.method_10067(), random);
        }
        mPos.method_10101((class_2382)position);
        chY = position.method_10264();
        for (sY = 0; sY < treeHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.method_10263() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.method_10260() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.method_10103(chX, chY, chZ);
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    byte mapValue = this.getMapValue(index);
                    if (mapValue > 0 && FeatureMiniTreeBase.isAirOrLeaves(world, (class_2338)mPos)) {
                        this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(mapValue, random), boundingBox);
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        this.postPlacement(changedBlocks, world, bulkAccess, random, position, boundingBox, 0);
        return true;
    }

    private boolean isStone(class_1936 world, class_2338 pos) {
        return FeatureMiniTreeBase.isStateAtPosition(world, pos, state -> TagHelper.isBlockInTag((class_2680)state, Tags.Blocks.STONE));
    }

    private void toGravel(class_1936 world, class_5867 bulkAccess, class_2338 pos, class_5819 random) {
        if (random.method_43056() && this.isStone(world, pos)) {
            this.setBlock(world, bulkAccess, pos, class_2246.field_10255.method_9564());
        }
    }
}

